/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.BaseRowSetTest;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockArray;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockBlob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockClob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockRef;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseRowSetTest
extends TestCase {
    public void testGetParams() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)0, (int)objectArray.length);
    }

    public void testGetFetchDirection() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        BaseRowSetTest.assertEquals((int)1000, (int)baseRowSetImpl.getFetchDirection());
    }

    public void testGetTypeMap() {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        BaseRowSetTest.assertNull((Object)baseRowSetImpl.getTypeMap());
    }

    public void testSetNullintint() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        try {
            baseRowSetImpl.setNull(1, -2);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.initParams();
        try {
            baseRowSetImpl.setNull(0, -2);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.setNull(1, -2);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        Object[] objectArray2 = (Object[])objectArray[0];
        BaseRowSetTest.assertNotNull((Object)objectArray2);
        BaseRowSetTest.assertEquals((int)2, (int)objectArray2.length);
        BaseRowSetTest.assertNull((Object)objectArray2[0]);
        BaseRowSetTest.assertEquals((Object)-2, (Object)objectArray2[1]);
    }

    public void testSetNullintintString() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        try {
            baseRowSetImpl.setNull(1, -2, "java.lang.Boolean");
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.initParams();
        try {
            baseRowSetImpl.setNull(0, -2, "java.lang.Boolean");
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.setNull(1, -2, "java.lang.Boolean");
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        Object[] objectArray2 = (Object[])objectArray[0];
        BaseRowSetTest.assertNotNull((Object)objectArray2);
        BaseRowSetTest.assertEquals((int)3, (int)objectArray2.length);
        BaseRowSetTest.assertNull((Object)objectArray2[0]);
        BaseRowSetTest.assertEquals((Object)-2, (Object)objectArray2[1]);
        BaseRowSetTest.assertEquals((Object)"java.lang.Boolean", (Object)objectArray2[2]);
    }

    public void testSetBoolean() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        try {
            baseRowSetImpl.setBoolean(1, true);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.initParams();
        try {
            baseRowSetImpl.setBoolean(0, true);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.setBoolean(1, true);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertEquals((Object)Boolean.TRUE, (Object)objectArray[0]);
    }

    public void testSetByte() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        try {
            baseRowSetImpl.setByte(1, (byte)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.initParams();
        try {
            baseRowSetImpl.setByte(0, (byte)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.setByte(1, (byte)1);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertEquals((Object)1, (Object)objectArray[0]);
    }

    public void testSetShort() throws Exception {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        try {
            baseRowSetImpl.setShort(1, (short)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.initParams();
        try {
            baseRowSetImpl.setShort(0, (short)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        baseRowSetImpl.setShort(1, (short)1);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertEquals((Object)1, (Object)objectArray[0]);
    }

    public void testSetFetchDirectionI() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.setFetchDirection(1000);
        BaseRowSetTest.assertEquals((int)1000, (int)baseRowSetImpl.getFetchDirection());
        baseRowSetImpl.setType(1005);
        baseRowSetImpl.setFetchDirection(1002);
        BaseRowSetTest.assertEquals((int)1002, (int)baseRowSetImpl.getFetchDirection());
        baseRowSetImpl.setType(1003);
        try {
            baseRowSetImpl.setFetchDirection(1001);
            BaseRowSetTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            baseRowSetImpl.setFetchDirection(1100);
            BaseRowSetTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSetTypeMap() {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.setTypeMap(null);
        BaseRowSetTest.assertNull((Object)baseRowSetImpl.getTypeMap());
    }

    public void testSetArray() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.initParams();
        MockArray mockArray = new MockArray();
        baseRowSetImpl.setArray(1, (Array)mockArray);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialArray", (boolean)(objectArray[0] instanceof SerialArray));
    }

    public void testSetBlob() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.initParams();
        MockBlob mockBlob = new MockBlob();
        baseRowSetImpl.setBlob(1, (Blob)mockBlob);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialBlob", (boolean)(objectArray[0] instanceof SerialBlob));
    }

    public void testSetClob() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.initParams();
        MockClob mockClob = new MockClob();
        baseRowSetImpl.setClob(1, (Clob)mockClob);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertTrue((mockClob != objectArray[0] ? 1 : 0) != 0);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialClob", (boolean)(objectArray[0] instanceof SerialClob));
    }

    public void testSetRef() throws SQLException {
        BaseRowSetImpl baseRowSetImpl = new BaseRowSetImpl(null);
        baseRowSetImpl.initParams();
        MockRef mockRef = new MockRef();
        baseRowSetImpl.setRef(1, (Ref)mockRef);
        Object[] objectArray = baseRowSetImpl.getParams();
        BaseRowSetTest.assertNotNull((Object)objectArray);
        BaseRowSetTest.assertEquals((int)1, (int)objectArray.length);
        BaseRowSetTest.assertTrue((mockRef != objectArray[0] ? 1 : 0) != 0);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialRef", (boolean)(objectArray[0] instanceof SerialRef));
    }
}

