#ifndef _LINUX_ATM_H
#define _LINUX_ATM_H


#define ATM_CELL_PAYLOAD 48


/*
 * The following items should be added to sys/socket.h aka linux/socket.h
 */

#define AF_ATMPVC	6		/* ATM PVCs */
#define AF_ATMSVC	7		/* ATM SVCs */

#define ATM_AAL0	0		/* "raw" ATM cells */
#define ATM_AAL1	1		/* AAL1 (CBR) */
#define ATM_AAL2	2		/* AAL2 (VBR) */
#define ATM_AAL34	3		/* AAL3/4 (data) */
#define ATM_AAL5	5		/* AAL5 (data) */
#define ATM_SAAL	12		/* signaling AAL */
#define	ATM_CLIP	16		/* Classical IP over ATM, RFC1577 */

/*
 * UGLY - there should only be one protocol family (PF_ATM) for both
 * address families. A quick glance at some kernel internals seems to
 * suggest to me that doing it the "right" way might involve some
 * swimming against the stream ...
 */

#define PF_ATMPVC	AF_ATMPVC
#define PF_ATMSVC	AF_ATMSVC

#define SOL_ATM		2
#define SOL_AAL		3

#define ATM_SETCLP	1		/* set CLP bit value - TODO */

#define SO_BCTXOPT	16
#define SO_BCRXOPT	17

struct atm_buffconst {
	unsigned long	buf_fac;	/* buffer alignment factor */
	unsigned long	buf_off;	/* buffer alignment offset */
	unsigned long	size_fac;	/* buffer size factor */
	unsigned long	size_off;	/* buffer size offset */
	unsigned long	min_size;	/* minimum size */
	unsigned long	max_size;	/* maximum size, 0 = unlimited */
};

#define SO_CIRANGE	15		/* connection identifier range;
					   socket must be bound or connected */

struct atm_cirange {
	unsigned char	vpi_bits;	/* 1..8, 0 for maximum */
	unsigned char	vci_bits;	/* 1..16, 0 for maximum */
};

/*
 * The following items should stay in linux/atm.h, which should be linked to
 * netatm/atm.h
 */

#define ATM_UBR		0
#define ATM_CBR		1
#define ATM_VBR		2
#define ATM_ABR		3

#define ATM_MAX_PCR	-1

struct atm_trafprm {
	unsigned char	class;		/* traffic class */
	int		max_pcr;	/* PCR in cells per second */
	int		max_cdv;	/* CDV in cell slots */
	int		max_sdu;	/* SDU in bytes */
};

struct sockaddr_atmpvc {
	unsigned short 	sap_family;	/* address family */
	struct {
		short	itf;		/* ATM interface */
		short	vpi;		/* VPI (only 8 bits at UNI) */
		int	vci;		/* VCI (only 16 bits at UNI) */
	}		sap_addr;	/* PVC address */
	struct atm_trafprm sap_txtp;	/* TX traffic parameters */
	struct atm_trafprm sap_rxtp;	/* TX traffic parameters */
};

struct sockaddr_atmsvc {
    unsigned short 	family;		/* address family */
    unsigned char	pub[20];	/* public ATM address */
    unsigned char	prv[20];	/* private ATM address */
    /* unused addresses must be bzero'ed */
    /* should also include BLLI and BHLI; some might also want TNS */
};

#define MAX_IF_NAME	10

struct atmif_arps {
#if 0				/* maybe later */
    char name[MAX_IF_NAME+1];
#endif
    struct sockaddr_atmsvc addr;
};


/*
 * Some stuff for linux/sockios.h
 */

#define SIOCGIFATMARPS	0x8980		/* get ATM ARP server */
#define SIOCSIFATMARPS	0x8981		/* set ATM ARP server */
#define SIOCSIFATMTCP	0x8982		/* set ATMTCP mode */

struct atmif_sioc {
    char name[MAX_IF_NAME+1];
};

#ifdef __KERNEL__

#include <linux/net.h>	/* struct net_proto */


void atmpvc_proto_init(struct net_proto *pro);
void atmsvc_proto_init(struct net_proto *pro);

#endif /* __KERNEL__ */

#endif
