#!/usr/bin/python3

from pathlib import Path

PROJECT_ROOT = Path(__file__) / "../.."
POSIX_PXDS_DIR = PROJECT_ROOT / "Cython/Includes/posix"
TEST_PATH = PROJECT_ROOT / "tests/compile/posix_pxds.pyx"

def main():
    data = [
        "# tag: posix\n"
        "# mode: compile\n"
        "\n"
        "# This file is generated by `Tools/gen_tests_for_posix_pxds.py`.\n"
        "\n"
        "cimport posix\n"
    ]

    filenames = sorted(map(lambda path: path.name, POSIX_PXDS_DIR.iterdir()))

    for name in filenames:
        if name == "__init__.pxd":
            continue
        if name.endswith(".pxd"):
            name = name[:-4]
        else:
            continue

        s = (
            "cimport posix.{name}\n"
            "from posix cimport {name}\n"
            "from posix.{name} cimport *\n"
        ).format(name=name)

        data.append(s)

    with open(TEST_PATH, "w", encoding="utf-8", newline="\n") as f:
        f.write("\n".join(data))

if __name__ == "__main__":
    main()
