struct TestSet {
	size_t expected_length;
	char *url;
};

static struct TestSet testset[] = {
{3132,"http://ads.bluelithium.com/clk?3,eJytjcFqwzAQRL8mNyO0luUoiB7WcQUGS8RFbXBuqVEcxxbKwSDy93HS0P5AH3uYYXd2AKT4hpOjJ-d4njGWdxIySB2nnB0hoVJKRvkmhTXb8GRyIWBVdw0W01bRAh-Y3Vfb4ItS4Ee.fcqdQBJLQsTg2.5nmzOT479QirH4fOkKcfnfL9WDMk09vhd.ZxpM2cSD17G2yh8uetZWTfoGQ7tXY22N1xa53lfc2DYz.W.yLUnO83xdMVylapkYI7kdzyGQLvjF3wHZQ1eK,http%3A%2F%2Fomicronpath.com%2F%3Fa%3D448%26c%3D3201%26s1%3DYahooStream_917_Nevada4"},
{3745,"http://ads.bluelithium.com/clk?3,eJytjd2OgjAQhZ.GO9K0lEpJ48WwUNekdIWoBO8UCfKX7gUJ4tNv3bj6AvtlLs7knDlDiDgzSi8sqDzOAtfnviAecSuGGT25DhZCUGwN4tOAOX1lDGxUmULYZT0O4cGnyYoankQcsvrjV245oClCiDfDn8.UYQn.QsS7cP.UGwDbX9vXjdSp6uLwHUuIjtL5ay1btZPDsU3GZCf7ZCZNkcte5YdG3.c33cZY5wU7pq.LleNcx.F7QWHhSjvTNKH5dDUGlWaw-w-Jy1ek,http%3A%2F%2Ftanphysics.com%2Farticles%2Freview1.php%3Futm_source%3DUSA%26utm_medium%3DYHO%26utm_content%3D917-STRM4%26utm_campaign%3DYHO%26keyword%3DYHO-917-STRM4"},
{896,"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&depth=0&query=GO:0042438"},
{611,"http://amigo.geneontology.org/cgi-bin/amigo/gp-assoc.cgi?gp=UniProtKB:P30046"},
{212,"http://answers.yahoo.com/"},
{196,"http://autos.yahoo.com/"},
{348,"http://baseball.fantasysports.yahoo.com/b1"},
{234,"http://biogps.org/gene/1652/"},
{644,"http://blog.washingtonpost.com/dcsportsbog/2007/05/a_caron_butler_surprise.html"},
{340,"http://ca.wikipedia.org/wiki/Caron_Butler"},
{212,"http://careers.yahoo.com/"},
{404,"http://commons.wikimedia.org/wiki/Atlas_of_Turkey"},
{380,"http://creativecommons.org/licenses/by-sa/3.0/"},
{380,"http://da.wikipedia.org/wiki/Johann_David_Wyss"},
{244,"http://de.wikipedia.org/wiki/"},
{340,"http://de.wikipedia.org/wiki/Caron_Butler"},
{380,"http://de.wikipedia.org/wiki/Johann_David_Wyss"},
{340,"http://de.wikipedia.org/wiki/Massey_Lopes"},
{512,"http://de.wikipedia.org/wiki/T%C3%BCrkische_Verfassung_von_1921"},
{336,"http://dx.doi.org/10.1002%2Felps.11501301201"},
{334,"http://dx.doi.org/10.1006%2Fbbrc.1993.2524"},
{296,"http://dx.doi.org/10.1007%2Fs003359900858"},
{304,"http://dx.doi.org/10.1021%2Fbi982184o"},
{402,"http://dx.doi.org/10.1034%2Fj.1600-0625.2003.120307.x"},
{255,"http://dx.doi.org/10.1038%2F990031"},
{296,"http://dx.doi.org/10.1038%2Fmsb4100134"},
{282,"http://dx.doi.org/10.1038%2Fnbt810"},
{329,"http://dx.doi.org/10.1073%2Fpnas.242603899"},
{326,"http://dx.doi.org/10.1074%2Fjbc.M203220200"},
{307,"http://dx.doi.org/10.1101%2Fgr.2596504"},
{360,"http://dx.doi.org/10.1186%2Fgb-2004-5-10-r84"},
{228,"http://education.yahoo.com/"},
{364,"http://en.m.wikipedia.org/wiki/Ambrose_Dyson"},
{356,"http://en.m.wikipedia.org/wiki/Caron_Butler"},
{340,"http://en.m.wikipedia.org/wiki/DDT_(gene)"},
{396,"http://en.m.wikipedia.org/wiki/Johann_David_Wyss"},
{332,"http://en.m.wikipedia.org/wiki/Lady_Anne"},
{492,"http://en.m.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet"},
{308,"http://en.m.wikipedia.org/wiki/Tumula"},
{480,"http://en.m.wikipedia.org/wiki/Turkish_Constitution_of_1921"},
{556,"http://en.m.wikipedia.org/wiki/Vietnam_University_Admission_Rankings"},
{444,"http://en.m.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{196,"http://en.wikipedia.org"},
{816,"http://en.wikipedia.org/w/index.php?title=2013%E2%80%9314_Milwaukee_Bucks_season&action=edit&redlink=1"},
{548,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&action=edit"},
{628,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&action=edit&section=1"},
{572,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&action=history"},
{548,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&action=info"},
{552,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&oldid=562636681"},
{564,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&printable=yes"},
{564,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&veaction=edit"},
{644,"http://en.wikipedia.org/w/index.php?title=Ambrose_Dyson&veaction=edit&section=1"},
{540,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&action=edit"},
{620,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&action=edit&section=1"},
{564,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&action=history"},
{540,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&action=info"},
{544,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&oldid=571697645"},
{556,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&printable=yes"},
{556,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&veaction=edit"},
{636,"http://en.wikipedia.org/w/index.php?title=Caron_Butler&veaction=edit&section=1"},
{780,"http://en.wikipedia.org/w/index.php?title=Court_of_Jurisdictional_Conflict&action=edit&redlink=1"},
{524,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&action=edit"},
{604,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&action=edit&section=1"},
{548,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&action=history"},
{524,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&action=info"},
{528,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&oldid=453962249"},
{540,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&printable=yes"},
{540,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&veaction=edit"},
{620,"http://en.wikipedia.org/w/index.php?title=DDT_(gene)&veaction=edit&section=1"},
{724,"http://en.wikipedia.org/w/index.php?title=Devonshire_County_Council&action=edit&redlink=1"},
{812,"http://en.wikipedia.org/w/index.php?title=H%C3%A0_T%C4%A9nh_Gifted_High_School&action=edit&redlink=1"},
{820,"http://en.wikipedia.org/w/index.php?title=H%C6%B0ng_Y%C3%AAn_Gifted_High_School&action=edit&redlink=1"},
{580,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&action=edit"},
{660,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&action=edit&section=1"},
{660,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&action=edit&section=2"},
{604,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&action=history"},
{580,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&action=info"},
{584,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&oldid=568638498"},
{596,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&printable=yes"},
{596,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&veaction=edit"},
{676,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&veaction=edit&section=1"},
{676,"http://en.wikipedia.org/w/index.php?title=Johann_David_Wyss&veaction=edit&section=2"},
{684,"http://en.wikipedia.org/w/index.php?title=Johann_Emmanuel_Wyss&action=edit&redlink=1"},
{652,"http://en.wikipedia.org/w/index.php?title=Josh_Oppenheimer&action=edit&redlink=1"},
{588,"http://en.wikipedia.org/w/index.php?title=Lady_Ann&action=edit&redlink=1"},
{516,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&action=edit"},
{596,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&action=edit&section=1"},
{540,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&action=history"},
{516,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&action=info"},
{520,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&oldid=372343156"},
{532,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&printable=yes"},
{532,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&veaction=edit"},
{612,"http://en.wikipedia.org/w/index.php?title=Lady_Anne&veaction=edit&section=1"},
{740,"http://en.wikipedia.org/w/index.php?title=Military_Court_of_Cassation&action=edit&redlink=1"},
{820,"http://en.wikipedia.org/w/index.php?title=Military_High_Court_of_Administration&action=edit&redlink=1"},
{620,"http://en.wikipedia.org/w/index.php?title=Monte_Mathis&action=edit&redlink=1"},
{764,"http://en.wikipedia.org/w/index.php?title=Quang_Trung_Gifted_High_School&action=edit&redlink=1"},
{740,"http://en.wikipedia.org/w/index.php?title=Robert_Hackett_(basketball)&action=edit&redlink=1"},
{676,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&action=edit"},
{756,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&action=edit&section=1"},
{700,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&action=history"},
{676,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&action=info"},
{680,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&oldid=545042390"},
{692,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&printable=yes"},
{692,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&veaction=edit"},
{772,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&veaction=edit&section=1"},
{772,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&veaction=edit&section=2"},
{772,"http://en.wikipedia.org/w/index.php?title=Sir_Massey_Lopes,_3rd_Baronet&veaction=edit&section=3"},
{788,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Ambrose+Dyson"},
{780,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Caron+Butler"},
{796,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=DDT+%28gene%29"},
{820,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Johann+David+Wyss"},
{756,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Lady+Anne"},
{932,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Sir+Massey+Lopes%2C+3rd+Baronet"},
{732,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Tumula"},
{908,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Turkish+Constitution+of+1921"},
{980,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Vietnam+University+Admission+Rankings"},
{868,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=book_creator&referer=Vy%C5%A1n%C3%BD+Slavkov"},
{1004,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Ambrose+Dyson&oldid=562636681&writer=rl"},
{996,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Caron+Butler&oldid=571697645&writer=rl"},
{1012,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=DDT+%28gene%29&oldid=453962249&writer=rl"},
{1036,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Johann+David+Wyss&oldid=568638498&writer=rl"},
{972,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Lady+Anne&oldid=372343156&writer=rl"},
{1148,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Sir+Massey+Lopes%2C+3rd+Baronet&oldid=545042390&writer=rl"},
{948,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Tumula&oldid=401070860&writer=rl"},
{1124,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Turkish+Constitution+of+1921&oldid=566504847&writer=rl"},
{1196,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Vietnam+University+Admission+Rankings&oldid=568532236&writer=rl"},
{1084,"http://en.wikipedia.org/w/index.php?title=Special:Book&bookcmd=render_article&arttitle=Vy%C5%A1n%C3%BD+Slavkov&oldid=541325469&writer=rl"},
{672,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Ambrose_Dyson&id=562636681"},
{664,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Caron_Butler&id=571697645"},
{680,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=DDT_%28gene%29&id=453962249"},
{704,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Johann_David_Wyss&id=568638498"},
{640,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Lady_Anne&id=372343156"},
{816,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Sir_Massey_Lopes%2C_3rd_Baronet&id=545042390"},
{616,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Tumula&id=401070860"},
{792,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Turkish_Constitution_of_1921&id=566504847"},
{864,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Vietnam_University_Admission_Rankings&id=568532236"},
{752,"http://en.wikipedia.org/w/index.php?title=Special:Cite&page=Vy%C5%A1n%C3%BD_Slavkov&id=541325469"},
{668,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Ambrose+Dyson"},
{764,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Ambrose+Dyson&type=signup"},
{660,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Caron+Butler"},
{756,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Caron+Butler&type=signup"},
{676,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=DDT+%28gene%29"},
{772,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=DDT+%28gene%29&type=signup"},
{700,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Johann+David+Wyss"},
{796,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Johann+David+Wyss&type=signup"},
{636,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Lady+Anne"},
{732,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Lady+Anne&type=signup"},
{812,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Sir+Massey+Lopes%2C+3rd+Baronet"},
{908,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Sir+Massey+Lopes%2C+3rd+Baronet&type=signup"},
{612,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Tumula"},
{708,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Tumula&type=signup"},
{788,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Turkish+Constitution+of+1921"},
{884,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Turkish+Constitution+of+1921&type=signup"},
{860,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Vietnam+University+Admission+Rankings"},
{956,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Vietnam+University+Admission+Rankings&type=signup"},
{748,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Vy%C5%A1n%C3%BD+Slavkov"},
{844,"http://en.wikipedia.org/w/index.php?title=Special:UserLogin&returnto=Vy%C5%A1n%C3%BD+Slavkov&type=signup"},
{692,"http://en.wikipedia.org/w/index.php?title=Special:WhatLinksHere/Lady_Anne&namespace=0"},
{636,"http://en.wikipedia.org/w/index.php?title=Talk:Lady_Anne&action=edit&redlink=1"},
{628,"http://en.wikipedia.org/w/index.php?title=Template:2002_NBA_Draft&action=edit"},
{1028,"http://en.wikipedia.org/w/index.php?title=Template:Big_East_Conference_Men%27s_Basketball_Player_of_the_Year_navbox&action=edit"},
{636,"http://en.wikipedia.org/w/index.php?title=Template:Cartoonist-stub&action=edit"},
{692,"http://en.wikipedia.org/w/index.php?title=Template:Constitution_of_Turkey&action=edit"},
{872,"http://en.wikipedia.org/w/index.php?title=Template:Dallas_Mavericks_2010%E2%80%9311_NBA_champions&action=edit"},
{612,"http://en.wikipedia.org/w/index.php?title=Template:Gene-22-stub&action=edit"},
{676,"http://en.wikipedia.org/w/index.php?title=Template:Levo%C4%8Da_District&action=edit"},
{756,"http://en.wikipedia.org/w/index.php?title=Template:Milwaukee_Bucks_current_roster&action=edit"},
{636,"http://en.wikipedia.org/w/index.php?title=Template:Noctuoidea-stub&action=edit"},
{580,"http://en.wikipedia.org/w/index.php?title=Template:PBB/1652&action=edit"},
{604,"http://en.wikipedia.org/w/index.php?title=Template:PDB_Gallery&action=edit"},
{660,"http://en.wikipedia.org/w/index.php?title=Template:Politics_of_Turkey&action=edit"},
{676,"http://en.wikipedia.org/w/index.php?title=Template:Pre%C5%A1ov-geo-stub&action=edit"},
{700,"http://en.wikipedia.org/w/index.php?title=Template:Switzerland-writer-stub&action=edit"},
{716,"http://en.wikipedia.org/w/index.php?title=Template:The_Swiss_Family_Robinson&action=edit"},
{700,"http://en.wikipedia.org/w/index.php?title=Template_talk:PBB/1652&action=edit&redlink=1"},
{836,"http://en.wikipedia.org/w/index.php?title=Template_talk:The_Swiss_Family_Robinson&action=edit&redlink=1"},
{492,"http://en.wikipedia.org/w/index.php?title=Tumula&action=edit"},
{572,"http://en.wikipedia.org/w/index.php?title=Tumula&action=edit&section=1"},
{516,"http://en.wikipedia.org/w/index.php?title=Tumula&action=history"},
{492,"http://en.wikipedia.org/w/index.php?title=Tumula&action=info"},
{496,"http://en.wikipedia.org/w/index.php?title=Tumula&oldid=401070860"},
{508,"http://en.wikipedia.org/w/index.php?title=Tumula&printable=yes"},
{508,"http://en.wikipedia.org/w/index.php?title=Tumula&veaction=edit"},
{588,"http://en.wikipedia.org/w/index.php?title=Tumula&veaction=edit&section=1"},
{668,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&action=edit"},
{748,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&action=edit&section=1"},
{692,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&action=history"},
{668,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&action=info"},
{672,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&oldid=566504847"},
{684,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&printable=yes"},
{684,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&veaction=edit"},
{764,"http://en.wikipedia.org/w/index.php?title=Turkish_Constitution_of_1921&veaction=edit&section=1"},
{724,"http://en.wikipedia.org/w/index.php?title=Turkish_Court_of_Accounts&action=edit&redlink=1"},
{740,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&action=edit"},
{820,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&action=edit&section=1"},
{764,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&action=history"},
{740,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&action=info"},
{744,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&oldid=568532236"},
{756,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&printable=yes"},
{756,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&veaction=edit"},
{836,"http://en.wikipedia.org/w/index.php?title=Vietnam_University_Admission_Rankings&veaction=edit&section=1"},
{628,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&action=edit"},
{708,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&action=edit&section=1"},
{652,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&action=history"},
{628,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&action=info"},
{632,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&oldid=541325469"},
{644,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&printable=yes"},
{644,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&veaction=edit"},
{724,"http://en.wikipedia.org/w/index.php?title=Vy%C5%A1n%C3%BD_Slavkov&veaction=edit&section=1"},
{568,"http://en.wikipedia.org/w/index.php?title=Vyšný_Slavkov&oldid=541325469"},
{525,"http://en.wikipedia.org/wiki/%C4%90%E1%BA%AFk_L%E1%BA%AFk_Province"},
{469,"http://en.wikipedia.org/wiki/%C4%90%E1%BB%93ng_Nai_Province"},
{685,"http://en.wikipedia.org/wiki/2001%E2%80%9302_NCAA_Division_I_men%27s_basketball_season"},
{493,"http://en.wikipedia.org/wiki/2002%E2%80%9303_Miami_Heat_season"},
{437,"http://en.wikipedia.org/wiki/2002%E2%80%9303_NBA_season"},
{356,"http://en.wikipedia.org/wiki/2002_NBA_Draft"},
{356,"http://en.wikipedia.org/wiki/2002_NBA_draft"},
{493,"http://en.wikipedia.org/wiki/2003%E2%80%9304_Miami_Heat_season"},
{437,"http://en.wikipedia.org/wiki/2003%E2%80%9304_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2004%E2%80%9305_Los_Angeles_Lakers_season"},
{437,"http://en.wikipedia.org/wiki/2004%E2%80%9305_NBA_season"},
{380,"http://en.wikipedia.org/wiki/2004_NBA_Playoffs"},
{437,"http://en.wikipedia.org/wiki/2005%E2%80%9306_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2005%E2%80%9306_Washington_Wizards_season"},
{437,"http://en.wikipedia.org/wiki/2006%E2%80%9307_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2006%E2%80%9307_Washington_Wizards_season"},
{364,"http://en.wikipedia.org/wiki/2006_NBA_Finals"},
{380,"http://en.wikipedia.org/wiki/2006_NBA_Playoffs"},
{437,"http://en.wikipedia.org/wiki/2007%E2%80%9308_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2007%E2%80%9308_Washington_Wizards_season"},
{420,"http://en.wikipedia.org/wiki/2007_NBA_All-Star_Game"},
{437,"http://en.wikipedia.org/wiki/2008%E2%80%9309_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2008%E2%80%9309_Washington_Wizards_season"},
{420,"http://en.wikipedia.org/wiki/2008_NBA_All-Star_Game"},
{380,"http://en.wikipedia.org/wiki/2008_NBA_Playoffs"},
{541,"http://en.wikipedia.org/wiki/2009%E2%80%9310_Dallas_Mavericks_season"},
{437,"http://en.wikipedia.org/wiki/2009%E2%80%9310_NBA_season"},
{557,"http://en.wikipedia.org/wiki/2009%E2%80%9310_Washington_Wizards_season"},
{541,"http://en.wikipedia.org/wiki/2010%E2%80%9311_Dallas_Mavericks_season"},
{437,"http://en.wikipedia.org/wiki/2010%E2%80%9311_NBA_season"},
{380,"http://en.wikipedia.org/wiki/2010_NBA_Playoffs"},
{573,"http://en.wikipedia.org/wiki/2011%E2%80%9312_Los_Angeles_Clippers_season"},
{437,"http://en.wikipedia.org/wiki/2011%E2%80%9312_NBA_season"},
{364,"http://en.wikipedia.org/wiki/2011_NBA_Finals"},
{380,"http://en.wikipedia.org/wiki/2011_NBA_Playoffs"},
{573,"http://en.wikipedia.org/wiki/2012%E2%80%9313_Los_Angeles_Clippers_season"},
{437,"http://en.wikipedia.org/wiki/2012%E2%80%9313_NBA_season"},
{380,"http://en.wikipedia.org/wiki/2012_NBA_Playoffs"},
{437,"http://en.wikipedia.org/wiki/2013%E2%80%9314_NBA_season"},
{380,"http://en.wikipedia.org/wiki/2013_NBA_Playoffs"},
{380,"http://en.wikipedia.org/wiki/Abdullah_G%C3%BCl"},
{572,"http://en.wikipedia.org/wiki/Accession_of_Turkey_to_the_European_Union"},
{308,"http://en.wikipedia.org/wiki/Adelaide"},
{332,"http://en.wikipedia.org/wiki/Albert_Pell"},
{308,"http://en.wikipedia.org/wiki/Alderman"},
{396,"http://en.wikipedia.org/wiki/Alfredton,_Victoria"},
{340,"http://en.wikipedia.org/wiki/All_American"},
{412,"http://en.wikipedia.org/wiki/Allies_of_World_War_I"},
{364,"http://en.wikipedia.org/wiki/Alonzo_Mourning"},
{396,"http://en.wikipedia.org/wiki/Amar%27e_Stoudemire"},
{420,"http://en.wikipedia.org/wiki/Amateur_Athletic_Union"},
{348,"http://en.wikipedia.org/wiki/Ambrose_Dyson"},
{356,"http://en.wikipedia.org/wiki/Ambrose_Dyson#"},
{444,"http://en.wikipedia.org/wiki/Ambrose_Dyson#cite_note-2"},
{516,"http://en.wikipedia.org/wiki/Ambrose_Dyson#cite_note-lindesay-1"},
{436,"http://en.wikipedia.org/wiki/Ambrose_Dyson#cite_ref-2"},
{524,"http://en.wikipedia.org/wiki/Ambrose_Dyson#cite_ref-lindesay_1-0"},
{524,"http://en.wikipedia.org/wiki/Ambrose_Dyson#cite_ref-lindesay_1-1"},
{460,"http://en.wikipedia.org/wiki/Ambrose_Dyson#mw-navigation"},
{420,"http://en.wikipedia.org/wiki/Ambrose_Dyson#p-search"},
{292,"http://en.wikipedia.org/wiki/Animal"},
{580,"http://en.wikipedia.org/wiki/Anne,_Duchess_of_Cumberland_and_Strathearn"},
{324,"http://en.wikipedia.org/wiki/Anne_Bacon"},
{332,"http://en.wikipedia.org/wiki/Anne_Brewis"},
{492,"http://en.wikipedia.org/wiki/Anne_Conway,_Viscountess_Conway"},
{340,"http://en.wikipedia.org/wiki/Anne_Halkett"},
{316,"http://en.wikipedia.org/wiki/Anne_Hyde"},
{340,"http://en.wikipedia.org/wiki/Anne_Lambton"},
{500,"http://en.wikipedia.org/wiki/Anne_Lennard,_Countess_of_Sussex"},
{500,"http://en.wikipedia.org/wiki/Anne_Stanley,_Countess_of_Ancram"},
{540,"http://en.wikipedia.org/wiki/Anne_Stanley,_Countess_of_Castlehaven"},
{332,"http://en.wikipedia.org/wiki/Anne_Wilson"},
{356,"http://en.wikipedia.org/wiki/Antawn_Jamison"},
{276,"http://en.wikipedia.org/wiki/Area"},
{316,"http://en.wikipedia.org/wiki/Arthropod"},
{396,"http://en.wikipedia.org/wiki/Assist_(basketball)"},
{436,"http://en.wikipedia.org/wiki/Atat%C3%BCrk%27s_Reforms"},
{380,"http://en.wikipedia.org/wiki/Authority_control"},
{669,"http://en.wikipedia.org/wiki/B%C3%A0_R%E1%BB%8Ba%E2%80%93V%C5%A9ng_T%C3%A0u_Province"},
{520,"http://en.wikipedia.org/wiki/B%C3%ACnh_%C4%90%E1%BB%8Bnh_Province"},
{528,"http://en.wikipedia.org/wiki/B%C3%ACnh_Ph%C6%B0%E1%BB%9Bc_Province"},
{450,"http://en.wikipedia.org/wiki/B%E1%BA%AFc_Giang_Province"},
{442,"http://en.wikipedia.org/wiki/B%E1%BA%AFc_Ninh_Province"},
{308,"http://en.wikipedia.org/wiki/Baldovce"},
{308,"http://en.wikipedia.org/wiki/Ballarat"},
{388,"http://en.wikipedia.org/wiki/Ballarat,_Victoria"},
{364,"http://en.wikipedia.org/wiki/Baron_Roborough"},
{324,"http://en.wikipedia.org/wiki/Basketball"},
{316,"http://en.wikipedia.org/wiki/Beharovce"},
{356,"http://en.wikipedia.org/wiki/Ben_Hansbrough"},
{380,"http://en.wikipedia.org/wiki/Benjamin_Disraeli"},
{476,"http://en.wikipedia.org/wiki/Beverly_Hills_Family_Robinson"},
{539,"http://en.wikipedia.org/wiki/Big_East_Conference_(1979%E2%80%932013)"},
{700,"http://en.wikipedia.org/wiki/Big_East_Conference_Men%27s_Basketball_Player_of_the_Year"},
{316,"http://en.wikipedia.org/wiki/Bijacovce"},
{644,"http://en.wikipedia.org/wiki/Bill_Russell_NBA_Finals_Most_Valuable_Player_Award"},
{332,"http://en.wikipedia.org/wiki/Billy_Owens"},
{444,"http://en.wikipedia.org/wiki/Biological_classification"},
{388,"http://en.wikipedia.org/wiki/Block_(basketball)"},
{284,"http://en.wikipedia.org/wiki/Blogs"},
{404,"http://en.wikipedia.org/wiki/Bo%C5%A1tjan_Nachbar"},
{324,"http://en.wikipedia.org/wiki/Bob_Bender"},
{356,"http://en.wikipedia.org/wiki/Brandin_Knight"},
{460,"http://en.wikipedia.org/wiki/Brandon_Knight_(basketball)"},
{364,"http://en.wikipedia.org/wiki/Brendan_Haywood"},
{356,"http://en.wikipedia.org/wiki/Brian_Cardinal"},
{332,"http://en.wikipedia.org/wiki/Brian_Grant"},
{308,"http://en.wikipedia.org/wiki/Brutovce"},
{308,"http://en.wikipedia.org/wiki/Buglovce"},
{332,"http://en.wikipedia.org/wiki/Burger_King"},
{340,"http://en.wikipedia.org/wiki/C._J._Dennis"},
{380,"http://en.wikipedia.org/wiki/Cabinet_of_Turkey"},
{292,"http://en.wikipedia.org/wiki/Caliph"},
{316,"http://en.wikipedia.org/wiki/Caliphate"},
{372,"http://en.wikipedia.org/wiki/Carlo_Pellegrini"},
{348,"http://en.wikipedia.org/wiki/Carlos_Boozer"},
{356,"http://en.wikipedia.org/wiki/Carlos_Delfino"},
{340,"http://en.wikipedia.org/wiki/Caron_Butler"},
{348,"http://en.wikipedia.org/wiki/Caron_Butler#"},
{460,"http://en.wikipedia.org/wiki/Caron_Butler#College_career"},
{428,"http://en.wikipedia.org/wiki/Caron_Butler#Early_life"},
{460,"http://en.wikipedia.org/wiki/Caron_Butler#External_links"},
{428,"http://en.wikipedia.org/wiki/Caron_Butler#NBA_career"},
{516,"http://en.wikipedia.org/wiki/Caron_Butler#NBA_career_statistics"},
{452,"http://en.wikipedia.org/wiki/Caron_Butler#Personal_life"},
{412,"http://en.wikipedia.org/wiki/Caron_Butler#Playoffs"},
{428,"http://en.wikipedia.org/wiki/Caron_Butler#References"},
{460,"http://en.wikipedia.org/wiki/Caron_Butler#Regular_season"},
{444,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-10"},
{436,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-5"},
{524,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-AllStories-7"},
{466,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-BK-20"},
{492,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-oprah1-1"},
{492,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-oprah2-2"},
{492,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-straws-3"},
{524,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-toughjuice-8"},
{516,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-washtimes-9"},
{556,"http://en.wikipedia.org/wiki/Caron_Butler#cite_note-wp-greatescape-4"},
{436,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-10"},
{428,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-5"},
{532,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-AllStories_7-0"},
{532,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-AllStories_7-1"},
{476,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-BK_20-0"},
{476,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-BK_20-1"},
{500,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-oprah1_1-0"},
{500,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-oprah2_2-0"},
{500,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-straws_3-0"},
{500,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-straws_3-1"},
{500,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-straws_3-2"},
{532,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-toughjuice_8-0"},
{524,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-washtimes_9-0"},
{564,"http://en.wikipedia.org/wiki/Caron_Butler#cite_ref-wp-greatescape_4-0"},
{452,"http://en.wikipedia.org/wiki/Caron_Butler#mw-navigation"},
{412,"http://en.wikipedia.org/wiki/Caron_Butler#p-search"},
{324,"http://en.wikipedia.org/wiki/Cartoonist"},
{356,"http://en.wikipedia.org/wiki/Casey_Jacobsen"},
{404,"http://en.wikipedia.org/wiki/Category:1743_births"},
{404,"http://en.wikipedia.org/wiki/Category:1818_births"},
{404,"http://en.wikipedia.org/wiki/Category:1818_deaths"},
{404,"http://en.wikipedia.org/wiki/Category:1876_births"},
{404,"http://en.wikipedia.org/wiki/Category:1908_deaths"},
{404,"http://en.wikipedia.org/wiki/Category:1913_deaths"},
{524,"http://en.wikipedia.org/wiki/Category:1921_in_the_Ottoman_Empire"},
{404,"http://en.wikipedia.org/wiki/Category:1980_births"},
{492,"http://en.wikipedia.org/wiki/Category:19th-century_novelists"},
{576,"http://en.wikipedia.org/wiki/Category:Accuracy_disputes_from_March_2012"},
{596,"http://en.wikipedia.org/wiki/Category:African-American_basketball_players"},
{572,"http://en.wikipedia.org/wiki/Category:All_article_disambiguation_pages"},
{636,"http://en.wikipedia.org/wiki/Category:All_articles_lacking_reliable_references"},
{652,"http://en.wikipedia.org/wiki/Category:All_articles_needing_additional_references"},
{572,"http://en.wikipedia.org/wiki/Category:All_articles_needing_coordinates"},
{532,"http://en.wikipedia.org/wiki/Category:All_articles_to_be_expanded"},
{620,"http://en.wikipedia.org/wiki/Category:All_articles_with_unsourced_statements"},
{508,"http://en.wikipedia.org/wiki/Category:All_disambiguation_pages"},
{620,"http://en.wikipedia.org/wiki/Category:All_pages_needing_factual_verification"},
{644,"http://en.wikipedia.org/wiki/Category:Articles_containing_Turkish-language_text"},
{752,"http://en.wikipedia.org/wiki/Category:Articles_lacking_reliable_references_from_February_2013"},
{760,"http://en.wikipedia.org/wiki/Category:Articles_needing_additional_references_from_January_2011"},
{716,"http://en.wikipedia.org/wiki/Category:Articles_needing_translation_from_German_Wikipedia"},
{632,"http://en.wikipedia.org/wiki/Category:Articles_to_be_expanded_from_August_2013"},
{636,"http://en.wikipedia.org/wiki/Category:Articles_with_%27species%27_microformats"},
{744,"http://en.wikipedia.org/wiki/Category:Articles_with_unsourced_statements_from_September_2010"},
{492,"http://en.wikipedia.org/wiki/Category:Australian_cartoonists"},
{500,"http://en.wikipedia.org/wiki/Category:Australian_illustrators"},
{476,"http://en.wikipedia.org/wiki/Category:Australian_satirists"},
{700,"http://en.wikipedia.org/wiki/Category:Baronets_in_the_Baronetage_of_the_United_Kingdom"},
{580,"http://en.wikipedia.org/wiki/Category:Basketball_players_from_Wisconsin"},
{444,"http://en.wikipedia.org/wiki/Category:Cartoonist_stubs"},
{524,"http://en.wikipedia.org/wiki/Category:Cartoonists_from_Melbourne"},
{508,"http://en.wikipedia.org/wiki/Category:Chromosome_22_gene_stubs"},
{684,"http://en.wikipedia.org/wiki/Category:Connecticut_Huskies_men%27s_basketball_players"},
{532,"http://en.wikipedia.org/wiki/Category:Conservative_Party_(UK)_MPs"},
{500,"http://en.wikipedia.org/wiki/Category:Constitutions_of_Turkey"},
{508,"http://en.wikipedia.org/wiki/Category:Dallas_Mavericks_players"},
{484,"http://en.wikipedia.org/wiki/Category:Defunct_constitutions"},
{476,"http://en.wikipedia.org/wiki/Category:Disambiguation_pages"},
{492,"http://en.wikipedia.org/wiki/Category:High_Sheriffs_of_Devon"},
{620,"http://en.wikipedia.org/wiki/Category:High_schools_for_the_gifted_in_Vietnam"},
{500,"http://en.wikipedia.org/wiki/Category:High_schools_in_Vietnam"},
{428,"http://en.wikipedia.org/wiki/Category:Human_proteins"},
{420,"http://en.wikipedia.org/wiki/Category:Living_people"},
{540,"http://en.wikipedia.org/wiki/Category:Los_Angeles_Clippers_players"},
{524,"http://en.wikipedia.org/wiki/Category:Los_Angeles_Lakers_players"},
{852,"http://en.wikipedia.org/wiki/Category:Members_of_the_United_Kingdom_Parliament_for_English_constituencies"},
{492,"http://en.wikipedia.org/wiki/Category:Miami_Heat_draft_picks"},
{460,"http://en.wikipedia.org/wiki/Category:Miami_Heat_players"},
{428,"http://en.wikipedia.org/wiki/Category:Micronoctuidae"},
{644,"http://en.wikipedia.org/wiki/Category:National_Basketball_Association_All-Stars"},
{444,"http://en.wikipedia.org/wiki/Category:Noctuoidea_stubs"},
{556,"http://en.wikipedia.org/wiki/Category:Pages_with_no_translate_target"},
{444,"http://en.wikipedia.org/wiki/Category:People_from_Bern"},
{548,"http://en.wikipedia.org/wiki/Category:People_from_Racine,_Wisconsin"},
{588,"http://en.wikipedia.org/wiki/Category:Pre%C5%A1ov_Region_geography_stubs"},
{460,"http://en.wikipedia.org/wiki/Category:Schools_in_Vietnam"},
{436,"http://en.wikipedia.org/wiki/Category:Shooting_guards"},
{428,"http://en.wikipedia.org/wiki/Category:Small_forwards"},
{386,"http://en.wikipedia.org/wiki/Category:Spi%C5%A1"},
{524,"http://en.wikipedia.org/wiki/Category:Swiss_children%27s_writers"},
{436,"http://en.wikipedia.org/wiki/Category:Swiss_novelists"},
{460,"http://en.wikipedia.org/wiki/Category:Swiss_writer_stubs"},
{479,"http://en.wikipedia.org/wiki/Category:UK_MPs_1857%E2%80%931859"},
{479,"http://en.wikipedia.org/wiki/Category:UK_MPs_1859%E2%80%931865"},
{479,"http://en.wikipedia.org/wiki/Category:UK_MPs_1868%E2%80%931874"},
{479,"http://en.wikipedia.org/wiki/Category:UK_MPs_1874%E2%80%931880"},
{479,"http://en.wikipedia.org/wiki/Category:UK_MPs_1880%E2%80%931885"},
{548,"http://en.wikipedia.org/wiki/Category:United_States_Navy_ship_names"},
{592,"http://en.wikipedia.org/wiki/Category:Use_British_English_from_March_2012"},
{560,"http://en.wikipedia.org/wiki/Category:Use_dmy_dates_from_January_2012"},
{536,"http://en.wikipedia.org/wiki/Category:Use_dmy_dates_from_July_2013"},
{660,"http://en.wikipedia.org/wiki/Category:Vietnam_articles_missing_geocoordinate_data"},
{724,"http://en.wikipedia.org/wiki/Category:Villages_and_municipalities_in_Levo%C4%8Da_District"},
{524,"http://en.wikipedia.org/wiki/Category:Washington_Wizards_players"},
{964,"http://en.wikipedia.org/wiki/Category:Wikipedia_articles_incorporating_an_LRPP-Bt_template_without_an_unnamed_parameter"},
{816,"http://en.wikipedia.org/wiki/Category:Wikipedia_articles_needing_factual_verification_from_March_2012"},
{848,"http://en.wikipedia.org/wiki/Category:Wikipedia_articles_needing_page_number_citations_from_February_2013"},
{636,"http://en.wikipedia.org/wiki/Category:Wikipedia_articles_with_VIAF_identifiers"},
{412,"http://en.wikipedia.org/wiki/Cemil_%C3%87i%C3%A7ek"},
{540,"http://en.wikipedia.org/wiki/Charles_Smith_(basketball,_born_1965)"},
{540,"http://en.wikipedia.org/wiki/Charles_Smith_(basketball,_born_1967)"},
{364,"http://en.wikipedia.org/wiki/Chris_Jefferies"},
{444,"http://en.wikipedia.org/wiki/Chris_Mullin_(basketball)"},
{436,"http://en.wikipedia.org/wiki/Chris_Owens_(basketball)"},
{340,"http://en.wikipedia.org/wiki/Chris_Wilcox"},
{348,"http://en.wikipedia.org/wiki/Chromosome_22"},
{348,"http://en.wikipedia.org/wiki/Chucky_Atkins"},
{380,"http://en.wikipedia.org/wiki/Clare_Sewell_Read"},
{396,"http://en.wikipedia.org/wiki/Cleveland_Cavaliers"},
{548,"http://en.wikipedia.org/wiki/Connecticut_Huskies_men%27s_basketball"},
{499,"http://en.wikipedia.org/wiki/Conservative_Government_1874-1880"},
{428,"http://en.wikipedia.org/wiki/Conservative_Party_(UK)"},
{340,"http://en.wikipedia.org/wiki/Constitution"},
{420,"http://en.wikipedia.org/wiki/Constitution_of_Turkey"},
{484,"http://en.wikipedia.org/wiki/Constitutional_Court_of_Turkey"},
{500,"http://en.wikipedia.org/wiki/Constitutional_history_of_Turkey"},
{428,"http://en.wikipedia.org/wiki/Constitutional_monarchy"},
{340,"http://en.wikipedia.org/wiki/Corey_Brewer"},
{364,"http://en.wikipedia.org/wiki/Corsley_Edwards"},
{460,"http://en.wikipedia.org/wiki/Court_of_Cassation_(Turkey)"},
{372,"http://en.wikipedia.org/wiki/Curtis_Borchardt"},
{516,"http://en.wikipedia.org/wiki/D%C3%BAbrava,_Levo%C4%8Da_District"},
{324,"http://en.wikipedia.org/wiki/DDT_(gene)"},
{332,"http://en.wikipedia.org/wiki/DDT_(gene)#"},
{476,"http://en.wikipedia.org/wiki/DDT_(gene)#cite_note-entrez-3"},
{506,"http://en.wikipedia.org/wiki/DDT_(gene)#cite_note-pmid9480844-1"},
{484,"http://en.wikipedia.org/wiki/DDT_(gene)#cite_ref-entrez_3-0"},
{484,"http://en.wikipedia.org/wiki/DDT_(gene)#cite_ref-entrez_3-1"},
{518,"http://en.wikipedia.org/wiki/DDT_(gene)#cite_ref-pmid9480844_1-0"},
{436,"http://en.wikipedia.org/wiki/DDT_(gene)#mw-navigation"},
{396,"http://en.wikipedia.org/wiki/DDT_(gene)#p-search"},
{300,"http://en.wikipedia.org/wiki/Da_Nang"},
{348,"http://en.wikipedia.org/wiki/Dajuan_Wagner"},
{372,"http://en.wikipedia.org/wiki/Dallas_Mavericks"},
{372,"http://en.wikipedia.org/wiki/Dan_Callandrillo"},
{324,"http://en.wikipedia.org/wiki/Dan_Dickau"},
{340,"http://en.wikipedia.org/wiki/Dan_Gadzuric"},
{340,"http://en.wikipedia.org/wiki/Daniel_Defoe"},
{364,"http://en.wikipedia.org/wiki/Darius_Songaila"},
{380,"http://en.wikipedia.org/wiki/Darrell_Armstrong"},
{300,"http://en.wikipedia.org/wiki/Das_Bus"},
{356,"http://en.wikipedia.org/wiki/David_Andersen"},
{340,"http://en.wikipedia.org/wiki/DeJuan_Blair"},
{380,"http://en.wikipedia.org/wiki/DeShawn_Stevenson"},
{364,"http://en.wikipedia.org/wiki/Derrick_Coleman"},
{380,"http://en.wikipedia.org/wiki/Deshawn_Stevenson"},
{444,"http://en.wikipedia.org/wiki/Digital_object_identifier"},
{348,"http://en.wikipedia.org/wiki/Dirk_Nowitzki"},
{447,"http://en.wikipedia.org/wiki/Dlh%C3%A9_Str%C3%A1%C5%BEe"},
{508,"http://en.wikipedia.org/wiki/Do%C4%BEany,_Levo%C4%8Da_District"},
{356,"http://en.wikipedia.org/wiki/Doma%C5%88ovce"},
{364,"http://en.wikipedia.org/wiki/Dominique_Jones"},
{372,"http://en.wikipedia.org/wiki/Donyell_Marshall"},
{292,"http://en.wikipedia.org/wiki/Dravce"},
{332,"http://en.wikipedia.org/wiki/Drew_Gooden"},
{364,"http://en.wikipedia.org/wiki/Duke_University"},
{332,"http://en.wikipedia.org/wiki/Dwane_Casey"},
{436,"http://en.wikipedia.org/wiki/Eastern_Conference_(NBA)"},
{380,"http://en.wikipedia.org/wiki/Economy_of_Turkey"},
{444,"http://en.wikipedia.org/wiki/Eddie_Jordan_(basketball)"},
{404,"http://en.wikipedia.org/wiki/Edward_Ambrose_Dyson"},
{340,"http://en.wikipedia.org/wiki/Edward_Dyson"},
{316,"http://en.wikipedia.org/wiki/Ekpe_Udoh"},
{396,"http://en.wikipedia.org/wiki/Elections_in_Turkey"},
{540,"http://en.wikipedia.org/wiki/Elections_in_Turkey#General_elections"},
{524,"http://en.wikipedia.org/wiki/Elections_in_Turkey#Local_elections"},
{316,"http://en.wikipedia.org/wiki/Elevation"},
{300,"http://en.wikipedia.org/wiki/Elite_8"},
{340,"http://en.wikipedia.org/wiki/Emeka_Okafor"},
{300,"http://en.wikipedia.org/wiki/Ensembl"},
{356,"http://en.wikipedia.org/wiki/Entente_powers"},
{292,"http://en.wikipedia.org/wiki/Entrez"},
{292,"http://en.wikipedia.org/wiki/Enzyme"},
{436,"http://en.wikipedia.org/wiki/Enzyme_Commission_number"},
{436,"http://en.wikipedia.org/wiki/Erdo%C4%9Fan_III_Cabinet"},
{340,"http://en.wikipedia.org/wiki/Eric_Bledsoe"},
{396,"http://en.wikipedia.org/wiki/Ersan_%C4%B0lyasova"},
{580,"http://en.wikipedia.org/wiki/Establishment_of_Turkish_national_movement"},
{604,"http://en.wikipedia.org/wiki/European_Union_%E2%80%93_Turkey_Customs_Union"},
{420,"http://en.wikipedia.org/wiki/Executive_(government)"},
{500,"http://en.wikipedia.org/wiki/FIBA_Under-21_World_Championship"},
{372,"http://en.wikipedia.org/wiki/Family_(biology)"},
{396,"http://en.wikipedia.org/wiki/Federico_Kammerichs"},
{428,"http://en.wikipedia.org/wiki/Field_goal_(basketball)"},
{484,"http://en.wikipedia.org/wiki/File:A_coloured_voting_box.svg"},
{508,"http://en.wikipedia.org/wiki/File:Bryant_Fades_Over_Butler.jpg"},
{412,"http://en.wikipedia.org/wiki/File:Caron_Butler.JPG"},
{428,"http://en.wikipedia.org/wiki/File:Creatorballoon.png"},
{380,"http://en.wikipedia.org/wiki/File:DNA_stub.png"},
{420,"http://en.wikipedia.org/wiki/File:Disambig_gray.svg"},
{428,"http://en.wikipedia.org/wiki/File:Flag_of_Turkey.svg"},
{610,"http://en.wikipedia.org/wiki/File:Massey_Lopes,_Vanity_Fair,_1875-05-15.jpg"},
{468,"http://en.wikipedia.org/wiki/File:Noctua.pronuba.7199.jpg"},
{412,"http://en.wikipedia.org/wiki/File:Okres_levoca.png"},
{514,"http://en.wikipedia.org/wiki/File:PBB_GE_DDT_202929_s_at_tn.png"},
{412,"http://en.wikipedia.org/wiki/File:PDB_1dpt_EBI.jpg"},
{356,"http://en.wikipedia.org/wiki/File:P_vip.svg"},
{476,"http://en.wikipedia.org/wiki/File:Protein_DDT_PDB_1dpt.png"},
{420,"http://en.wikipedia.org/wiki/File:Quill_and_ink.svg"},
{460,"http://en.wikipedia.org/wiki/File:Slovakiatynk%C3%A4.svg"},
{412,"http://en.wikipedia.org/wiki/File:Speaker_Icon.svg"},
{540,"http://en.wikipedia.org/wiki/File:Translation_to_english_arrow.svg"},
{436,"http://en.wikipedia.org/wiki/File:Wikisource-logo.svg"},
{524,"http://en.wikipedia.org/wiki/Financial_Secretary_to_the_Treasury"},
{524,"http://en.wikipedia.org/wiki/Foreign_Language_Specialized_School"},
{460,"http://en.wikipedia.org/wiki/Foreign_relations_of_Turkey"},
{564,"http://en.wikipedia.org/wiki/Francis_Cottington,_1st_Baron_Cottington"},
{460,"http://en.wikipedia.org/wiki/Frank_Williams_(basketball)"},
{428,"http://en.wikipedia.org/wiki/Fred_Jones_(basketball)"},
{324,"http://en.wikipedia.org/wiki/Free_throw"},
{456,"http://en.wikipedia.org/wiki/French_Constitution_of_1791"},
{316,"http://en.wikipedia.org/wiki/Gary_Neal"},
{276,"http://en.wikipedia.org/wiki/Gene"},
{316,"http://en.wikipedia.org/wiki/GeneCards"},
{348,"http://en.wikipedia.org/wiki/Gene_Ontology"},
{284,"http://en.wikipedia.org/wiki/Genus"},
{468,"http://en.wikipedia.org/wiki/Geographic_coordinate_system"},
{412,"http://en.wikipedia.org/wiki/Geography_of_Slovakia"},
{412,"http://en.wikipedia.org/wiki/Giannis_Antetokounmpo"},
{356,"http://en.wikipedia.org/wiki/Gilbert_Arenas"},
{396,"http://en.wikipedia.org/wiki/Gran%C4%8D-Petrovce"},
{508,"http://en.wikipedia.org/wiki/Grand_National_Assembly_of_Turkey"},
{412,"http://en.wikipedia.org/wiki/Great_Western_Railway"},
{404,"http://en.wikipedia.org/wiki/H%C3%A0_Nam_Province"},
{452,"http://en.wikipedia.org/wiki/H%C3%A0_T%C4%A9nh_Province"},
{460,"http://en.wikipedia.org/wiki/H%C6%B0ng_Y%C3%AAn_Province"},
{523,"http://en.wikipedia.org/wiki/H%E1%BA%A3i_D%C6%B0%C6%A1ng_Province"},
{316,"http://en.wikipedia.org/wiki/Hai_Phong"},
{348,"http://en.wikipedia.org/wiki/Hakim_Warrick"},
{284,"http://en.wikipedia.org/wiki/Hanoi"},
{540,"http://en.wikipedia.org/wiki/Hanoi_%E2%80%93_Amsterdam_High_School"},
{316,"http://en.wikipedia.org/wiki/Harakovce"},
{364,"http://en.wikipedia.org/wiki/Hasheem_Thabeet"},
{348,"http://en.wikipedia.org/wiki/Help:Category"},
{348,"http://en.wikipedia.org/wiki/Help:Contents"},
{396,"http://en.wikipedia.org/wiki/Help:Disambiguation"},
{396,"http://en.wikipedia.org/wiki/Help:IPA_for_German"},
{516,"http://en.wikipedia.org/wiki/Help:Introduction_to_referencing/1"},
{524,"http://en.wikipedia.org/wiki/Henry_Chaplin,_1st_Viscount_Chaplin"},
{476,"http://en.wikipedia.org/wiki/Henry_Lopes,_1st_Baron_Ludlow"},
{500,"http://en.wikipedia.org/wiki/Henry_Lopes,_1st_Baron_Roborough"},
{604,"http://en.wikipedia.org/wiki/Her_Majesty%27s_Most_Honourable_Privy_Council"},
{812,"http://en.wikipedia.org/wiki/High_School_for_Gifted_Students,_Hanoi_National_University_of_Education"},
{724,"http://en.wikipedia.org/wiki/High_School_for_Gifted_Students,_Hanoi_University_of_Science"},
{452,"http://en.wikipedia.org/wiki/High_School_for_the_Gifted"},
{412,"http://en.wikipedia.org/wiki/High_Sheriff_of_Devon"},
{300,"http://en.wikipedia.org/wiki/History"},
{380,"http://en.wikipedia.org/wiki/History_of_Turkey"},
{572,"http://en.wikipedia.org/wiki/History_of_Turkish_presidential_elections"},
{372,"http://en.wikipedia.org/wiki/Ho_Chi_Minh_City"},
{324,"http://en.wikipedia.org/wiki/HomoloGene"},
{444,"http://en.wikipedia.org/wiki/Human_Genome_Organisation"},
{332,"http://en.wikipedia.org/wiki/Ian_Mahinmi"},
{292,"http://en.wikipedia.org/wiki/Insect"},
{372,"http://en.wikipedia.org/wiki/Internet_Archive"},
{316,"http://en.wikipedia.org/wiki/Ish_Smith"},
{332,"http://en.wikipedia.org/wiki/Islamic_Law"},
{340,"http://en.wikipedia.org/wiki/J._J._Redick"},
{308,"http://en.wikipedia.org/wiki/Jablonov"},
{332,"http://en.wikipedia.org/wiki/Jae_Crowder"},
{348,"http://en.wikipedia.org/wiki/Jamal_Sampson"},
{468,"http://en.wikipedia.org/wiki/James_Singleton_(basketball)"},
{468,"http://en.wikipedia.org/wiki/James_Wilson_(UK_politician)"},
{340,"http://en.wikipedia.org/wiki/Jared_Dudley"},
{356,"http://en.wikipedia.org/wiki/Jared_Jeffries"},
{460,"http://en.wikipedia.org/wiki/Jason_Jennings_(basketball)"},
{324,"http://en.wikipedia.org/wiki/Jason_Kidd"},
{332,"http://en.wikipedia.org/wiki/Jason_Terry"},
{444,"http://en.wikipedia.org/wiki/Jay_Williams_(basketball)"},
{428,"http://en.wikipedia.org/wiki/Jeff_Green_(basketball)"},
{407,"http://en.wikipedia.org/wiki/Ji%C5%99%C3%AD_Welsch"},
{332,"http://en.wikipedia.org/wiki/Jim_Calhoun"},
{340,"http://en.wikipedia.org/wiki/Jim_Cleamons"},
{380,"http://en.wikipedia.org/wiki/Johann_David_Wyss"},
{388,"http://en.wikipedia.org/wiki/Johann_David_Wyss#"},
{476,"http://en.wikipedia.org/wiki/Johann_David_Wyss#cite_note-1"},
{468,"http://en.wikipedia.org/wiki/Johann_David_Wyss#cite_ref-1"},
{492,"http://en.wikipedia.org/wiki/Johann_David_Wyss#mw-navigation"},
{452,"http://en.wikipedia.org/wiki/Johann_David_Wyss#p-search"},
{388,"http://en.wikipedia.org/wiki/Johann_Rudolf_Wyss"},
{436,"http://en.wikipedia.org/wiki/John_Bagley_(basketball)"},
{420,"http://en.wikipedia.org/wiki/John_Carpenter_Garnier"},
{324,"http://en.wikipedia.org/wiki/John_Duren"},
{436,"http://en.wikipedia.org/wiki/John_Henson_(basketball)"},
{380,"http://en.wikipedia.org/wiki/John_Lewis_Phipps"},
{492,"http://en.wikipedia.org/wiki/John_Russell,_Viscount_Amberley"},
{340,"http://en.wikipedia.org/wiki/John_Salmons"},
{460,"http://en.wikipedia.org/wiki/John_Tremayne_(1825_-_1901)"},
{540,"http://en.wikipedia.org/wiki/John_Yarde-Buller,_1st_Baron_Churston"},
{404,"http://en.wikipedia.org/wiki/Jos%C3%A9_Juan_Barea"},
{332,"http://en.wikipedia.org/wiki/Josh_Howard"},
{500,"http://en.wikipedia.org/wiki/Juan_Carlos_Navarro_(basketball)"},
{324,"http://en.wikipedia.org/wiki/Juan_Dixon"},
{332,"http://en.wikipedia.org/wiki/Kareem_Rush"},
{543,"http://en.wikipedia.org/wiki/Kemal_K%C4%B1l%C4%B1%C3%A7daro%C4%9Flu"},
{348,"http://en.wikipedia.org/wiki/Kerry_Kittles"},
{324,"http://en.wikipedia.org/wiki/Kew_Asylum"},
{468,"http://en.wikipedia.org/wiki/Kh%C3%A1nh_H%C3%B2a_Province"},
{364,"http://en.wikipedia.org/wiki/Khris_Middleton"},
{324,"http://en.wikipedia.org/wiki/Kl%C4%8Dov"},
{332,"http://en.wikipedia.org/wiki/Kobe_Bryant"},
{338,"http://en.wikipedia.org/wiki/Korytn%C3%A9"},
{308,"http://en.wikipedia.org/wiki/Kurimany"},
{332,"http://en.wikipedia.org/wiki/Kwame_Brown"},
{530,"http://en.wikipedia.org/wiki/L%C3%BA%C4%8Dka,_Levo%C4%8Da_District"},
{316,"http://en.wikipedia.org/wiki/Lady_Anne"},
{324,"http://en.wikipedia.org/wiki/Lady_Anne#"},
{484,"http://en.wikipedia.org/wiki/Lady_Anne#Fictional_characters"},
{372,"http://en.wikipedia.org/wiki/Lady_Anne#People"},
{388,"http://en.wikipedia.org/wiki/Lady_Anne#See_also"},
{364,"http://en.wikipedia.org/wiki/Lady_Anne#Ships"},
{428,"http://en.wikipedia.org/wiki/Lady_Anne#mw-navigation"},
{388,"http://en.wikipedia.org/wiki/Lady_Anne#p-search"},
{412,"http://en.wikipedia.org/wiki/Lady_Anne-Marie_Byrne"},
{380,"http://en.wikipedia.org/wiki/Lady_Anne_Barnard"},
{364,"http://en.wikipedia.org/wiki/Lady_Anne_Berry"},
{364,"http://en.wikipedia.org/wiki/Lady_Anne_Blunt"},
{468,"http://en.wikipedia.org/wiki/Lady_Anne_Cavendish-Bentinck"},
{396,"http://en.wikipedia.org/wiki/Lady_Anne_Churchill"},
{388,"http://en.wikipedia.org/wiki/Lady_Anne_Clifford"},
{500,"http://en.wikipedia.org/wiki/Lady_Anne_Farquharson-MacKintosh"},
{356,"http://en.wikipedia.org/wiki/Lady_Anne_Rhys"},
{396,"http://en.wikipedia.org/wiki/Lam_Son_High_School"},
{324,"http://en.wikipedia.org/wiki/Lamar_Odom"},
{340,"http://en.wikipedia.org/wiki/Laron_Profit"},
{324,"http://en.wikipedia.org/wiki/Larry_Drew"},
{452,"http://en.wikipedia.org/wiki/Larry_Sanders_(basketball)"},
{492,"http://en.wikipedia.org/wiki/Lawrence_Palk,_1st_Baron_Haldon"},
{340,"http://en.wikipedia.org/wiki/LeBron_James"},
{444,"http://en.wikipedia.org/wiki/Le_Hong_Phong_High_School"},
{556,"http://en.wikipedia.org/wiki/Leader_of_the_Main_Opposition_of_Turkey"},
{548,"http://en.wikipedia.org/wiki/Legal_System_in_the_Republic_of_Turkey"},
{756,"http://en.wikipedia.org/wiki/Legal_System_in_the_Republic_of_Turkey#Turkish_Court_of_Accounts"},
{548,"http://en.wikipedia.org/wiki/Legal_system_of_the_Republic_of_Turkey"},
{332,"http://en.wikipedia.org/wiki/Legislative"},
{332,"http://en.wikipedia.org/wiki/Lepidoptera"},
{332,"http://en.wikipedia.org/wiki/Levo%C4%8Da"},
{404,"http://en.wikipedia.org/wiki/Levo%C4%8Da_District"},
{308,"http://en.wikipedia.org/wiki/LibriVox"},
{412,"http://en.wikipedia.org/wiki/List_of_NBA_champions"},
{468,"http://en.wikipedia.org/wiki/List_of_Presidents_of_Turkey"},
{692,"http://en.wikipedia.org/wiki/List_of_Presidents_of_the_Constitutional_Court_of_Turkey"},
{508,"http://en.wikipedia.org/wiki/List_of_Prime_Ministers_of_Turkey"},
{596,"http://en.wikipedia.org/wiki/List_of_Speakers_of_the_Parliament_of_Turkey"},
{444,"http://en.wikipedia.org/wiki/List_of_Turkish_diplomats"},
{540,"http://en.wikipedia.org/wiki/List_of_diplomatic_missions_of_Turkey"},
{452,"http://en.wikipedia.org/wiki/List_of_extant_baronetcies"},
{524,"http://en.wikipedia.org/wiki/List_of_political_parties_in_Turkey"},
{372,"http://en.wikipedia.org/wiki/Long_An_Province"},
{340,"http://en.wikipedia.org/wiki/Lonny_Baxter"},
{516,"http://en.wikipedia.org/wiki/Lord_Commissioner_of_the_Admiralty"},
{404,"http://en.wikipedia.org/wiki/Los_Angeles_Clippers"},
{388,"http://en.wikipedia.org/wiki/Los_Angeles_Lakers"},
{348,"http://en.wikipedia.org/wiki/Lost_in_Space"},
{324,"http://en.wikipedia.org/wiki/Luis_Scola"},
{356,"http://en.wikipedia.org/wiki/Luke_Harangody"},
{340,"http://en.wikipedia.org/wiki/Luke_Ridnour"},
{548,"http://en.wikipedia.org/wiki/Macrophage_migration_inhibitory_factor"},
{604,"http://en.wikipedia.org/wiki/Macrophage_migration_inhibitory_factor_domain"},
{316,"http://en.wikipedia.org/wiki/Main_Page"},
{428,"http://en.wikipedia.org/wiki/Maine_Central_Institute"},
{356,"http://en.wikipedia.org/wiki/Marcus_Haislip"},
{348,"http://en.wikipedia.org/wiki/Marcus_Taylor"},
{332,"http://en.wikipedia.org/wiki/Mario_Kasun"},
{388,"http://en.wikipedia.org/wiki/Maryland_Terrapins"},
{332,"http://en.wikipedia.org/wiki/Matt_Barnes"},
{372,"http://en.wikipedia.org/wiki/Melbourne_Herald"},
{364,"http://en.wikipedia.org/wiki/Melbourne_Punch"},
{324,"http://en.wikipedia.org/wiki/Melvin_Ely"},
{468,"http://en.wikipedia.org/wiki/Mendelian_Inheritance_in_Man"},
{324,"http://en.wikipedia.org/wiki/Miami_Heat"},
{356,"http://en.wikipedia.org/wiki/Micronoctuidae"},
{388,"http://en.wikipedia.org/wiki/Mike_Dunleavy,_Jr."},
{426,"http://en.wikipedia.org/wiki/Milo%C5%A1_Vujani%C4%87"},
{364,"http://en.wikipedia.org/wiki/Milwaukee_Bucks"},
{404,"http://en.wikipedia.org/wiki/Ministries_of_Turkey"},
{596,"http://en.wikipedia.org/wiki/Ministry_of_Education_and_Training_(Vietnam)"},
{532,"http://en.wikipedia.org/wiki/Ministry_of_Foreign_Affairs_(Turkey)"},
{388,"http://en.wikipedia.org/wiki/Miroslav_Raduljica"},
{412,"http://en.wikipedia.org/wiki/Mladen_%C5%A0ekularac"},
{300,"http://en.wikipedia.org/wiki/Monarch"},
{276,"http://en.wikipedia.org/wiki/Moth"},
{340,"http://en.wikipedia.org/wiki/Mountain_Dew"},
{436,"http://en.wikipedia.org/wiki/Mouse_Genome_Informatics"},
{340,"http://en.wikipedia.org/wiki/Municipality"},
{452,"http://en.wikipedia.org/wiki/Mustafa_Kemal_Atat%C3%BCrk"},
{268,"http://en.wikipedia.org/wiki/NBA"},
{396,"http://en.wikipedia.org/wiki/NBA_All-Rookie_Team"},
{380,"http://en.wikipedia.org/wiki/NBA_All-Star_Game"},
{292,"http://en.wikipedia.org/wiki/Nahiye"},
{472,"http://en.wikipedia.org/wiki/Nam_%C4%90%E1%BB%8Bnh_Province"},
{340,"http://en.wikipedia.org/wiki/Nate_Wolters"},
{540,"http://en.wikipedia.org/wiki/National_Basketball_Association_draft"},
{516,"http://en.wikipedia.org/wiki/National_Security_Council_(Turkey)"},
{404,"http://en.wikipedia.org/wiki/National_sovereignty"},
{348,"http://en.wikipedia.org/wiki/Neme%C5%A1any"},
{314,"http://en.wikipedia.org/wiki/Nen%C3%AA"},
{378,"http://en.wikipedia.org/wiki/Nenad_Krsti%C4%87"},
{420,"http://en.wikipedia.org/wiki/New_Orleans,_Louisiana"},
{364,"http://en.wikipedia.org/wiki/New_York_Knicks"},
{436,"http://en.wikipedia.org/wiki/Ngh%E1%BB%87_An_Province"},
{484,"http://en.wikipedia.org/wiki/Nguyen_Thuong_Hien_High_School"},
{460,"http://en.wikipedia.org/wiki/Ni%C5%BEn%C3%A9_Repa%C5%A1e"},
{348,"http://en.wikipedia.org/wiki/Nick_Van_Exel"},
{404,"http://en.wikipedia.org/wiki/Nikoloz_Tskitishvili"},
{324,"http://en.wikipedia.org/wiki/Noctuoidea"},
{378,"http://en.wikipedia.org/wiki/O%C4%BE%C5%A1avica"},
{324,"http://en.wikipedia.org/wiki/O._J._Mayo"},
{340,"http://en.wikipedia.org/wiki/Open_Library"},
{316,"http://en.wikipedia.org/wiki/Ordzovany"},
{412,"http://en.wikipedia.org/wiki/Oriel_College,_Oxford"},
{332,"http://en.wikipedia.org/wiki/Otto_Porter"},
{356,"http://en.wikipedia.org/wiki/Ottoman_Empire"},
{364,"http://en.wikipedia.org/wiki/Ottoman_dynasty"},
{372,"http://en.wikipedia.org/wiki/Ottoman_language"},
{620,"http://en.wikipedia.org/wiki/Outline_of_political_science#Politics_by_region"},
{500,"http://en.wikipedia.org/wiki/Parliament_of_the_United_Kingdom"},
{332,"http://en.wikipedia.org/wiki/Pat_Garrity"},
{348,"http://en.wikipedia.org/wiki/Patrick_Ewing"},
{340,"http://en.wikipedia.org/wiki/Pav%C4%BEany"},
{402,"http://en.wikipedia.org/wiki/Peja_Stojakovi%C4%87"},
{388,"http://en.wikipedia.org/wiki/Perils_of_the_Wild"},
{332,"http://en.wikipedia.org/wiki/Peter_Fehse"},
{476,"http://en.wikipedia.org/wiki/Ph%C3%BA_Th%E1%BB%8D_Province"},
{452,"http://en.wikipedia.org/wiki/Ph%C3%BA_Y%C3%AAn_Province"},
{340,"http://en.wikipedia.org/wiki/Phoenix_Suns"},
{380,"http://en.wikipedia.org/wiki/Pittsfield,_Maine"},
{356,"http://en.wikipedia.org/wiki/Po%C4%BEanovce"},
{388,"http://en.wikipedia.org/wiki/Politics_of_Turkey"},
{524,"http://en.wikipedia.org/wiki/Politics_of_Turkey#Executive_branch"},
{540,"http://en.wikipedia.org/wiki/Politics_of_Turkey#Legislative_branch"},
{372,"http://en.wikipedia.org/wiki/Pongr%C3%A1covce"},
{324,"http://en.wikipedia.org/wiki/Population"},
{372,"http://en.wikipedia.org/wiki/Portal:Biography"},
{364,"http://en.wikipedia.org/wiki/Portal:Contents"},
{412,"http://en.wikipedia.org/wiki/Portal:Current_events"},
{428,"http://en.wikipedia.org/wiki/Portal:Featured_content"},
{364,"http://en.wikipedia.org/wiki/Portal:Politics"},
{348,"http://en.wikipedia.org/wiki/Portal:Turkey"},
{388,"http://en.wikipedia.org/wiki/Pre%C5%A1ov_Region"},
{396,"http://en.wikipedia.org/wiki/President_of_Turkey"},
{436,"http://en.wikipedia.org/wiki/Prime_Minister_of_Turkey"},
{380,"http://en.wikipedia.org/wiki/Project_Gutenberg"},
{380,"http://en.wikipedia.org/wiki/Protein_Data_Bank"},
{292,"http://en.wikipedia.org/wiki/PubMed"},
{356,"http://en.wikipedia.org/wiki/PubMed_Central"},
{380,"http://en.wikipedia.org/wiki/PubMed_Identifier"},
{372,"http://en.wikipedia.org/wiki/Public_relations"},
{284,"http://en.wikipedia.org/wiki/Qadaa"},
{460,"http://en.wikipedia.org/wiki/Qu%E1%BA%A3ng_Ninh_Province"},
{340,"http://en.wikipedia.org/wiki/Quinton_Ross"},
{636,"http://en.wikipedia.org/wiki/Quoc_Hoc_%E2%80%93_Hue_High_School_for_the_Gifted"},
{340,"http://en.wikipedia.org/wiki/Qyntel_Woods"},
{380,"http://en.wikipedia.org/wiki/Racine,_Wisconsin"},
{428,"http://en.wikipedia.org/wiki/Racine_Park_High_School"},
{324,"http://en.wikipedia.org/wiki/Randy_Foye"},
{348,"http://en.wikipedia.org/wiki/Randy_Holcomb"},
{348,"http://en.wikipedia.org/wiki/Rasual_Butler"},
{316,"http://en.wikipedia.org/wiki/Ray_Allen"},
{404,"http://en.wikipedia.org/wiki/Rebound_(basketball)"},
{444,"http://en.wikipedia.org/wiki/Recep_Tayyip_Erdo%C4%9Fan"},
{556,"http://en.wikipedia.org/wiki/Reggie_Williams_(basketball,_born_1964)"},
{308,"http://en.wikipedia.org/wiki/Republic"},
{388,"http://en.wikipedia.org/wiki/Republic_of_Turkey"},
{476,"http://en.wikipedia.org/wiki/Richard_Hamilton_(basketball)"},
{348,"http://en.wikipedia.org/wiki/Rick_Carlisle"},
{372,"http://en.wikipedia.org/wiki/Robert_Archibald"},
{604,"http://en.wikipedia.org/wiki/Robert_Haldane-Duncan,_3rd_Earl_of_Camperdown"},
{364,"http://en.wikipedia.org/wiki/Robinson_Crusoe"},
{340,"http://en.wikipedia.org/wiki/Rod_Grizzard"},
{380,"http://en.wikipedia.org/wiki/Rodrigue_Beaubois"},
{372,"http://en.wikipedia.org/wiki/Roger_Mason,_Jr."},
{348,"http://en.wikipedia.org/wiki/Ronald_Murray"},
{348,"http://en.wikipedia.org/wiki/Ryan_Humphrey"},
{364,"http://en.wikipedia.org/wiki/Sam_Clancy,_Jr."},
{436,"http://en.wikipedia.org/wiki/Samuel_Trehawke_Kekewich"},
{380,"http://en.wikipedia.org/wiki/San_Antonio_Spurs"},
{460,"http://en.wikipedia.org/wiki/Scott_Williams_(basketball)"},
{404,"http://en.wikipedia.org/wiki/Secularism_in_Turkey"},
{348,"http://en.wikipedia.org/wiki/Sephardi_Jews"},
{388,"http://en.wikipedia.org/wiki/Shaquille_O%27Neal"},
{340,"http://en.wikipedia.org/wiki/Shawn_Marion"},
{548,"http://en.wikipedia.org/wiki/Sir_Manasseh_Masseh_Lopes,_1st_Baronet"},
{476,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet"},
{484,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet#"},
{572,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet#cite_note-1"},
{564,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet#cite_ref-1"},
{588,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet#mw-navigation"},
{548,"http://en.wikipedia.org/wiki/Sir_Massey_Lopes,_3rd_Baronet#p-search"},
{468,"http://en.wikipedia.org/wiki/Sir_Ralph_Lopes,_2nd_Baronet"},
{308,"http://en.wikipedia.org/wiki/Slovakia"},
{348,"http://en.wikipedia.org/wiki/Small_forward"},
{564,"http://en.wikipedia.org/wiki/South_Devon_(UK_Parliament_constituency)"},
{444,"http://en.wikipedia.org/wiki/South_Melbourne,_Victoria"},
{332,"http://en.wikipedia.org/wiki/Sovereignty"},
{412,"http://en.wikipedia.org/wiki/Space_Family_Robinson"},
{463,"http://en.wikipedia.org/wiki/Special:BookSources/0091354609"},
{356,"http://en.wikipedia.org/wiki/Special:Random"},
{412,"http://en.wikipedia.org/wiki/Special:RecentChanges"},
{572,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Ambrose_Dyson"},
{564,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Caron_Butler"},
{548,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/DDT_(gene)"},
{604,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Johann_David_Wyss"},
{540,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Lady_Anne"},
{700,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Sir_Massey_Lopes,_3rd_Baronet"},
{516,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Tumula"},
{688,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Turkish_Constitution_of_1921"},
{764,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Vietnam_University_Admission_Rankings"},
{652,"http://en.wikipedia.org/wiki/Special:RecentChangesLinked/Vy%C5%A1n%C3%BD_Slavkov"},
{404,"http://en.wikipedia.org/wiki/Special:SpecialPages"},
{524,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Ambrose_Dyson"},
{516,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Caron_Butler"},
{500,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/DDT_(gene)"},
{556,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Johann_David_Wyss"},
{492,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Lady_Anne"},
{652,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Sir_Massey_Lopes,_3rd_Baronet"},
{468,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Tumula"},
{640,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Turkish_Constitution_of_1921"},
{716,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Vietnam_University_Admission_Rankings"},
{604,"http://en.wikipedia.org/wiki/Special:WhatLinksHere/Vy%C5%A1n%C3%BD_Slavkov"},
{460,"http://en.wikipedia.org/wiki/Spi%C5%A1sk%C3%A9_Podhradie"},
{484,"http://en.wikipedia.org/wiki/Spi%C5%A1sk%C3%BD_%C5%A0tvrtok"},
{428,"http://en.wikipedia.org/wiki/Spi%C5%A1sk%C3%BD_Hrhov"},
{388,"http://en.wikipedia.org/wiki/Steal_(basketball)"},
{332,"http://en.wikipedia.org/wiki/Steve_Logan"},
{404,"http://en.wikipedia.org/wiki/Stranded_(2002_film)"},
{492,"http://en.wikipedia.org/wiki/Studenec_(Levo%C4%8Da_District)"},
{292,"http://en.wikipedia.org/wiki/Sultan"},
{524,"http://en.wikipedia.org/wiki/Supreme_Electoral_Council_of_Turkey"},
{444,"http://en.wikipedia.org/wiki/Swiss_Family_Guy_Robinson"},
{508,"http://en.wikipedia.org/wiki/Swiss_Family_Robinson_(1940_film)"},
{508,"http://en.wikipedia.org/wiki/Swiss_Family_Robinson_(1960_film)"},
{548,"http://en.wikipedia.org/wiki/Swiss_Family_Robinson_(1974_TV_series)"},
{332,"http://en.wikipedia.org/wiki/Switzerland"},
{292,"http://en.wikipedia.org/wiki/Sydney"},
{324,"http://en.wikipedia.org/wiki/Tactusinae"},
{388,"http://en.wikipedia.org/wiki/Talk:Ambrose_Dyson"},
{380,"http://en.wikipedia.org/wiki/Talk:Caron_Butler"},
{364,"http://en.wikipedia.org/wiki/Talk:DDT_(gene)"},
{420,"http://en.wikipedia.org/wiki/Talk:Johann_David_Wyss"},
{516,"http://en.wikipedia.org/wiki/Talk:Sir_Massey_Lopes,_3rd_Baronet"},
{332,"http://en.wikipedia.org/wiki/Talk:Tumula"},
{504,"http://en.wikipedia.org/wiki/Talk:Turkish_Constitution_of_1921"},
{580,"http://en.wikipedia.org/wiki/Talk:Vietnam_University_Admission_Rankings"},
{468,"http://en.wikipedia.org/wiki/Talk:Vy%C5%A1n%C3%BD_Slavkov"},
{324,"http://en.wikipedia.org/wiki/Tamar_Slay"},
{364,"http://en.wikipedia.org/wiki/Tayshaun_Prince"},
{428,"http://en.wikipedia.org/wiki/Template:2002_NBA_Draft"},
{828,"http://en.wikipedia.org/wiki/Template:Big_East_Conference_Men%27s_Basketball_Player_of_the_Year_navbox"},
{436,"http://en.wikipedia.org/wiki/Template:Cartoonist-stub"},
{436,"http://en.wikipedia.org/wiki/Template:Citation_needed"},
{492,"http://en.wikipedia.org/wiki/Template:Constitution_of_Turkey"},
{672,"http://en.wikipedia.org/wiki/Template:Dallas_Mavericks_2010%E2%80%9311_NBA_champions"},
{412,"http://en.wikipedia.org/wiki/Template:Gene-22-stub"},
{476,"http://en.wikipedia.org/wiki/Template:Levo%C4%8Da_District"},
{556,"http://en.wikipedia.org/wiki/Template:Milwaukee_Bucks_current_roster"},
{436,"http://en.wikipedia.org/wiki/Template:Noctuoidea-stub"},
{371,"http://en.wikipedia.org/wiki/Template:PBB/1652"},
{404,"http://en.wikipedia.org/wiki/Template:PDB_Gallery"},
{460,"http://en.wikipedia.org/wiki/Template:Politics_of_Turkey"},
{476,"http://en.wikipedia.org/wiki/Template:Pre%C5%A1ov-geo-stub"},
{500,"http://en.wikipedia.org/wiki/Template:Switzerland-writer-stub"},
{516,"http://en.wikipedia.org/wiki/Template:The_Swiss_Family_Robinson"},
{396,"http://en.wikipedia.org/wiki/Template:Translated"},
{468,"http://en.wikipedia.org/wiki/Template_talk:2002_NBA_Draft"},
{868,"http://en.wikipedia.org/wiki/Template_talk:Big_East_Conference_Men%27s_Basketball_Player_of_the_Year_navbox"},
{476,"http://en.wikipedia.org/wiki/Template_talk:Cartoonist-stub"},
{532,"http://en.wikipedia.org/wiki/Template_talk:Constitution_of_Turkey"},
{712,"http://en.wikipedia.org/wiki/Template_talk:Dallas_Mavericks_2010%E2%80%9311_NBA_champions"},
{452,"http://en.wikipedia.org/wiki/Template_talk:Gene-22-stub"},
{516,"http://en.wikipedia.org/wiki/Template_talk:Levo%C4%8Da_District"},
{596,"http://en.wikipedia.org/wiki/Template_talk:Milwaukee_Bucks_current_roster"},
{476,"http://en.wikipedia.org/wiki/Template_talk:Noctuoidea-stub"},
{444,"http://en.wikipedia.org/wiki/Template_talk:PDB_Gallery"},
{500,"http://en.wikipedia.org/wiki/Template_talk:Politics_of_Turkey"},
{516,"http://en.wikipedia.org/wiki/Template_talk:Pre%C5%A1ov-geo-stub"},
{540,"http://en.wikipedia.org/wiki/Template_talk:Switzerland-writer-stub"},
{340,"http://en.wikipedia.org/wiki/Terry_Dehere"},
{340,"http://en.wikipedia.org/wiki/Terry_Stotts"},
{468,"http://en.wikipedia.org/wiki/Th%C3%A1i_B%C3%ACnh_Province"},
{660,"http://en.wikipedia.org/wiki/Th%E1%BB%ABa_Thi%C3%AAn%E2%80%93Hu%E1%BA%BF_Province"},
{356,"http://en.wikipedia.org/wiki/Thanh_H%C3%B3a"},
{428,"http://en.wikipedia.org/wiki/Thanh_H%C3%B3a_Province"},
{340,"http://en.wikipedia.org/wiki/The_Bulletin"},
{444,"http://en.wikipedia.org/wiki/The_Castaways_of_the_Flag"},
{388,"http://en.wikipedia.org/wiki/The_London_Gazette"},
{444,"http://en.wikipedia.org/wiki/The_Swiss_Family_Robinson"},
{700,"http://en.wikipedia.org/wiki/The_Swiss_Family_Robinson:_Flone_of_the_Mysterious_Island"},
{580,"http://en.wikipedia.org/wiki/The_Swiss_Family_Robinson_(1975_TV_series)"},
{500,"http://en.wikipedia.org/wiki/Thomas_Brassey,_1st_Earl_Brassey"},
{420,"http://en.wikipedia.org/wiki/Three-point_field_goal"},
{340,"http://en.wikipedia.org/wiki/Tim_Grgurich"},
{420,"http://en.wikipedia.org/wiki/Tim_James_(basketball)"},
{332,"http://en.wikipedia.org/wiki/Tito_Maddox"},
{324,"http://en.wikipedia.org/wiki/Tom_Durkin"},
{300,"http://en.wikipedia.org/wiki/Torysky"},
{452,"http://en.wikipedia.org/wiki/Tran_Dai_Nghia_High_School"},
{388,"http://en.wikipedia.org/wiki/Treaty_of_Lausanne"},
{412,"http://en.wikipedia.org/wiki/Treaty_of_S%C3%A8vres"},
{316,"http://en.wikipedia.org/wiki/Troy_Bell"},
{332,"http://en.wikipedia.org/wiki/Troy_Murphy"},
{292,"http://en.wikipedia.org/wiki/Tumula"},
{300,"http://en.wikipedia.org/wiki/Tumula#"},
{404,"http://en.wikipedia.org/wiki/Tumula#mw-navigation"},
{364,"http://en.wikipedia.org/wiki/Tumula#p-search"},
{388,"http://en.wikipedia.org/wiki/Tumula_flavicollis"},
{292,"http://en.wikipedia.org/wiki/Turkey"},
{660,"http://en.wikipedia.org/wiki/Turkey%27s_membership_of_international_organizations"},
{404,"http://en.wikipedia.org/wiki/Turkish_Armed_Forces"},
{464,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921"},
{476,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#"},
{556,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#Background"},
{588,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#External_links"},
{540,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#Overview"},
{556,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#References"},
{644,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#Text_.28as_enacted.29"},
{540,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#Timeline"},
{564,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#cite_note-1"},
{556,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#cite_ref-1"},
{580,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#mw-navigation"},
{540,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1921#p-search"},
{464,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1924"},
{464,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1961"},
{464,"http://en.wikipedia.org/wiki/Turkish_Constitution_of_1982"},
{436,"http://en.wikipedia.org/wiki/Turkish_Council_of_State"},
{436,"http://en.wikipedia.org/wiki/Turkish_Independence_War"},
{460,"http://en.wikipedia.org/wiki/Turkish_War_of_Independence"},
{480,"http://en.wikipedia.org/wiki/Turkish_general_election,_2011"},
{372,"http://en.wikipedia.org/wiki/Turkish_language"},
{472,"http://en.wikipedia.org/wiki/Turkish_local_elections,_2009"},
{520,"http://en.wikipedia.org/wiki/Turkish_presidential_election,_2007"},
{356,"http://en.wikipedia.org/wiki/Tyson_Chandler"},
{420,"http://en.wikipedia.org/wiki/USS_Lady_Anne_(SP-154)"},
{324,"http://en.wikipedia.org/wiki/Ulo%C5%BEa"},
{300,"http://en.wikipedia.org/wiki/UniProt"},
{348,"http://en.wikipedia.org/wiki/United_States"},
{548,"http://en.wikipedia.org/wiki/United_States_national_basketball_team"},
{444,"http://en.wikipedia.org/wiki/University_of_Connecticut"},
{468,"http://en.wikipedia.org/wiki/V%C4%A9nh_Ph%C3%BAc_Province"},
{567,"http://en.wikipedia.org/wiki/Vanity_Fair_(British_magazine_1868-1914)"},
{396,"http://en.wikipedia.org/wiki/Viacheslav_Kravtsov"},
{540,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings"},
{548,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings#"},
{636,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings#cite_note-1"},
{628,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings#cite_ref-1"},
{652,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings#mw-navigation"},
{612,"http://en.wikipedia.org/wiki/Vietnam_University_Admission_Rankings#p-search"},
{340,"http://en.wikipedia.org/wiki/Vil%C3%A2yet"},
{300,"http://en.wikipedia.org/wiki/Village"},
{380,"http://en.wikipedia.org/wiki/Vincent_Yarbrough"},
{532,"http://en.wikipedia.org/wiki/Virtual_International_Authority_File"},
{460,"http://en.wikipedia.org/wiki/Vy%C5%A1n%C3%A9_Repa%C5%A1e"},
{428,"http://en.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{436,"http://en.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov#"},
{540,"http://en.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov#mw-navigation"},
{500,"http://en.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov#p-search"},
{444,"http://en.wikipedia.org/wiki/Walter_Berry_(basketball)"},
{372,"http://en.wikipedia.org/wiki/Washington,_D.C."},
{460,"http://en.wikipedia.org/wiki/Washington_Park_High_School"},
{388,"http://en.wikipedia.org/wiki/Washington_Wizards"},
{460,"http://en.wikipedia.org/wiki/Wesley_Johnson_(basketball)"},
{540,"http://en.wikipedia.org/wiki/Westbury_(UK_Parliament_constituency)"},
{364,"http://en.wikipedia.org/wiki/Wikipedia:About"},
{444,"http://en.wikipedia.org/wiki/Wikipedia:Citation_needed"},
{436,"http://en.wikipedia.org/wiki/Wikipedia:Citing_sources"},
{452,"http://en.wikipedia.org/wiki/Wikipedia:Community_portal"},
{404,"http://en.wikipedia.org/wiki/Wikipedia:Contact_us"},
{516,"http://en.wikipedia.org/wiki/Wikipedia:Copying_within_Wikipedia"},
{468,"http://en.wikipedia.org/wiki/Wikipedia:File_Upload_Wizard"},
{468,"http://en.wikipedia.org/wiki/Wikipedia:General_disclaimer"},
{548,"http://en.wikipedia.org/wiki/Wikipedia:Identifying_reliable_sources"},
{362,"http://en.wikipedia.org/wiki/Wikipedia:NOTRS"},
{404,"http://en.wikipedia.org/wiki/Wikipedia:Persondata"},
{356,"http://en.wikipedia.org/wiki/Wikipedia:Stub"},
{868,"http://en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License"},
{412,"http://en.wikipedia.org/wiki/Wikipedia:Translation"},
{372,"http://en.wikipedia.org/wiki/Wikipedia:V#SELF"},
{580,"http://en.wikipedia.org/wiki/Wikipedia:Verifiability#Burden_of_evidence"},
{324,"http://en.wikipedia.org/wiki/Will_Dyson"},
{388,"http://en.wikipedia.org/wiki/Winchester_College"},
{316,"http://en.wikipedia.org/wiki/Wisconsin"},
{332,"http://en.wikipedia.org/wiki/World_War_I"},
{292,"http://en.wikipedia.org/wiki/Yahoo!"},
{308,"http://en.wikipedia.org/wiki/Yao_Ming"},
{348,"http://en.wikipedia.org/wiki/Zaza_Pachulia"},
{556,"http://en.wikisource.org/wiki/Constitution_of_the_Republic_of_Turkey"},
{428,"http://eo.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{340,"http://es.wikipedia.org/wiki/Caron_Butler"},
{380,"http://es.wikipedia.org/wiki/Johann_David_Wyss"},
{228,"http://everything.yahoo.com"},
{236,"http://everything.yahoo.com/"},
{420,"http://feedback.yahoo.com/forums/206380-us-homepage"},
{204,"http://finance.yahoo.com"},
{212,"http://finance.yahoo.com/"},
{602,"http://finance.yahoo.com/news/brazil-looks-break-us-centric-040621384.html"},
{554,"http://finance.yahoo.com/news/did-ted-cruz-just-force-211204954.html"},
{642,"http://finance.yahoo.com/news/theyve-turned-over-costa-concordia-102731647.html"},
{284,"http://finance.yahoo.com/q?s=^IXIC"},
{578,"http://finance.yahoo.com/video/winning-lottery-beat-odds-193258229.html"},
{148,"http://flickr.com"},
{404,"http://flss.edu.vn/Home.asp?param=news&NewsID=147"},
{980,"http://football.fantasysports.yahoo.com/?ovchn=YAH&ovcpn=Front+Page&ovcrn=Front+page+P+Link+Nav+button&ovrfd=YAH&ovtac=AD"},
{340,"http://fr.wikipedia.org/wiki/Caron_Butler"},
{380,"http://fr.wikipedia.org/wiki/Johann_David_Wyss"},
{428,"http://fr.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{196,"http://games.yahoo.com/"},
{697,"http://genome.ucsc.edu/cgi-bin/hgTracks?org=Human&db=hg19&position=chr22:24313554-24322660"},
{689,"http://genome.ucsc.edu/cgi-bin/hgTracks?org=Mouse&db=mm9&position=chr10:75771230-75773414"},
{340,"http://gl.wikipedia.org/wiki/Caron_Butler"},
{196,"http://green.yahoo.com/"},
{204,"http://groups.yahoo.com/"},
{687,"http://hangtime.blogs.nba.com/2011/01/04/caron-butler-out-for-season/?ls=iref:nbahpt2"},
{476,"http://hansard.millbanksystems.com/people/sir-massey-lopes"},
{618,"http://he.wikipedia.org/wiki/%D7%A7%D7%90%D7%A8%D7%95%D7%9F_%D7%91%D7%90%D7%98%D7%9C%D7%A8"},
{196,"http://health.yahoo.net"},
{636,"http://health.yahoo.net/articles/weight-loss/why-obese-people-cant-lose-weight"},
{653,"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553"},
{372,"http://help.yahoo.com/l/us/yahoo/helpcentral/"},
{268,"http://homes.yahoo.com/own-rent/"},
{340,"http://hr.wikipedia.org/wiki/Caron_Butler"},
{412,"http://hu.wikipedia.org/wiki/Fels%C5%91szal%C3%B3k"},
{180,"http://info.yahoo.com"},
{188,"http://info.yahoo.com/"},
{396,"http://info.yahoo.com/legal/us/yahoo/utos/terms/"},
{396,"http://info.yahoo.com/privacy/us/yahoo/homepage/"},
{452,"http://info.yahoo.com/privacy/us/yahoo/relevantads.html"},
{340,"http://it.wikipedia.org/wiki/Caron_Butler"},
{428,"http://it.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{651,"http://ja.wikipedia.org/wiki/%E3%82%AB%E3%83%AD%E3%83%B3%E3%83%BB%E3%83%90%E3%83%88%E3%83%A9%E3%83%BC"},
{898,"http://ja.wikipedia.org/wiki/%E3%83%A8%E3%83%8F%E3%83%B3%E3%83%BB%E3%83%80%E3%83%93%E3%83%83%E3%83%88%E3%83%BB%E3%82%A6%E3%82%A3%E3%83%BC%E3%82%B9"},
{564,"http://jobsearch.monster.com/search/?cy=us&WT.mc_n=yta_trough_jsrtest"},
{596,"http://librivox.org/newcatalog/search.php?title=&author=Johann+David+Wyss"},
{356,"http://lv.wikipedia.org/wiki/Kerons_Batlers"},
{252,"http://mail.yahoo.com?.intl=us"},
{188,"http://maps.yahoo.com/"},
{220,"http://messenger.yahoo.com"},
{196,"http://movies.yahoo.com"},
{522,"http://movies.yahoo.com/video/short-game-crushing-224038083.html"},
{428,"http://ms.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{188,"http://music.yahoo.com"},
{276,"http://my.yahoo.com/?fr=yfp-t-403"},
{634,"http://myespn.go.com/blogs/truehoop/0-24-118/Caron-Butler-in-the-Basement.html"},
{188,"http://news.yahoo.com/"},
{618,"http://news.yahoo.com/amazing-roll-cloud-tumbles-over-dc-area-161409111.html"},
{994,"http://news.yahoo.com/blogs/trending-now/family-sells-home--goes-on-epic-yearlong-trip-to-all-50-states-185712913.html?vp=1"},
{388,"http://news.yahoo.com/comics/dilbert-slideshow/"},
{746,"http://news.yahoo.com/cost-cutting-may-have-played-role-in-navy-yard-shooting-134106229.html"},
{682,"http://news.yahoo.com/giant-underground-blob-magma-puzzles-scientists-210726200.html"},
{746,"http://news.yahoo.com/lightbox/dilbert-slideshow/20130523-dt130523-gif-photo-050423497.html"},
{516,"http://news.yahoo.com/photos/costa-concordia-salvage-slideshow/"},
{599,"http://news.yahoo.com/photos/turtle-rescue-in-israel-1379421810-slideshow/"},
{666,"http://news.yahoo.com/put-business-trauma-doctor-pleads-u-navy-yard-181522657.html"},
{698,"http://news.yahoo.com/touting-obamacare-us-says-millions-could-pay-less-212243340.html"},
{578,"http://news.yahoo.com/video/old-soda-bottles-giving-life-001700872.html"},
{380,"http://nl.wikipedia.org/wiki/Johann_David_Wyss"},
{428,"http://nl.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{380,"http://no.wikipedia.org/wiki/Johann_David_Wyss"},
{180,"http://omg.yahoo.com/"},
{650,"http://omg.yahoo.com/blogs/celeb-news/brad-pitt-finally-makes-cut-223549188.html"},
{794,"http://omg.yahoo.com/blogs/celeb-news/fashion-faceoff-miley-cyrus-vs-rachel-mcadams-190957403.html"},
{882,"http://omg.yahoo.com/blogs/celeb-news/justin-theroux-reveals-one-thing-jennifer-aniston-wouldn-113635271.html"},
{882,"http://omg.yahoo.com/news/courteney-cox-david-arquette-selling-beverly-hills-mansion-184500328-us-weekly.html"},
{232,"http://omim.org/entry/602750"},
{3387,"http://open.login.yahoo.net/openid/yrp/hr_signin?.intl=us&idp=facebook&ts=1379461518&rpcrumb=&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history&.done=http%3A%2F%2Fwww.yahoo.com%2F"},
{320,"http://openlibrary.org/authors/OL342629A"},
{340,"http://pl.wikipedia.org/wiki/Caron_Butler"},
{380,"http://pl.wikipedia.org/wiki/Johann_David_Wyss"},
{428,"http://pl.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{855,"http://probasketballtalk.nbcsports.com/2010/07/21/caron-butler-used-to-work-at-a-burger-king-now-owns-six/"},
{340,"http://pt.wikipedia.org/wiki/Caron_Butler"},
{659,"http://ru.wikipedia.org/wiki/%D0%91%D0%B0%D1%82%D0%BB%D0%B5%D1%80,_%D0%9A%D1%8D%D1%80%D0%BE%D0%BD"},
{917,"http://ru.wikipedia.org/wiki/%D0%9A%D0%BE%D0%BD%D1%81%D1%82%D0%B8%D1%82%D1%83%D1%86%D0%B8%D1%8F_%D0%A2%D1%83%D1%80%D1%86%D0%B8%D0%B8_(1921)"},
{204,"http://screen.yahoo.com/"},
{453,"http://screen.yahoo.com/11-old-boy-made-9-134626064.html"},
{738,"http://screen.yahoo.com/snl-women-skits/girl-wish-hadnt-started-conversation-000000658.html"},
{204,"http://search.yahoo.com/"},
{244,"http://search.yahoo.com/local"},
{741,"http://search.yahoo.com/search?cs=bz&p=Biblical-era%20town&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{765,"http://search.yahoo.com/search?cs=bz&p=Green%20River%20Killer&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{733,"http://search.yahoo.com/search?cs=bz&p=Hostile%20takeover&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{741,"http://search.yahoo.com/search?cs=bz&p=Jennifer%20Lopez%20&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{701,"http://search.yahoo.com/search?cs=bz&p=Jessa%20Duggar&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{717,"http://search.yahoo.com/search?cs=bz&p=Kim%20Zolciak%20&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{717,"http://search.yahoo.com/search?cs=bz&p=LSU%20fraternity&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{741,"http://search.yahoo.com/search?cs=bz&p=Linda%20Ronstadt%20&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{749,"http://search.yahoo.com/search?cs=bz&p=Star%20Trek%20NSA%20&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{781,"http://search.yahoo.com/search?cs=bz&p=Walking%20Dead%20spinoff&fr=fp-tts-900&fr2=ps&woeid=23424856"},
{188,"http://shine.yahoo.com"},
{196,"http://shine.yahoo.com/"},
{276,"http://shine.yahoo.com/horoscope/"},
{548,"http://shine.yahoo.com/horoscope/virgo/extended-daily-20130917.html"},
{548,"http://shine.yahoo.com/horoscope/virgo/overview-daily-20130917.html"},
{754,"http://shine.yahoo.com/shine-food/5-things-didnt-know-could-pillsbury-biscuits-205500571.html"},
{730,"http://shine.yahoo.com/shine-food/fabios-ultimate-pulled-pork-sandwich-011700797.html?vp=1"},
{220,"http://shopping.yahoo.com/"},
{412,"http://simple.wikipedia.org/wiki/Johann_David_Wyss"},
{428,"http://sk.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{436,"http://smallbusiness.yahoo.com/?s_fptrough=ysb_acq_fp"},
{402,"http://sports.espn.go.com/nba/news/story?id=3290089"},
{400,"http://sports.espn.go.com/nba/recap?gameId=270117027"},
{400,"http://sports.espn.go.com/nba/recap?gameId=280313027"},
{196,"http://sports.yahoo.com"},
{204,"http://sports.yahoo.com/"},
{911,"http://sports.yahoo.com/blogs/mlb-big-league-stew/fan-dashes-onto-field-during-rays-game-only-192151790--mlb.html"},
{991,"http://sports.yahoo.com/blogs/nfl-shutdown-corner/does-andy-reid-still-wish-philadelphia-jamaal-charles-180705907--nfl.html"},
{260,"http://sports.yahoo.com/fantasy"},
{228,"http://sports.yahoo.com/mlb"},
{376,"http://sports.yahoo.com/mlb/preview?gid=330917104"},
{360,"http://sports.yahoo.com/mlb/recap?gid=330917220"},
{308,"http://sports.yahoo.com/mlb/teams/atl"},
{939,"http://sports.yahoo.com/nba/blog/ball_dont_lie/post/More-on-Caron-Butler-s-extreme-Mountain-Dew-addi?urn=nba%2C198240"},
{332,"http://sports.yahoo.com/nba/players/3608"},
{647,"http://sports.yahoo.com/news/team-report-san-francisco-49ers-211200051--nfl.html"},
{228,"http://sports.yahoo.com/nfl"},
{383,"http://sports.yahoo.com/nfl/preview?gid=20130919021"},
{367,"http://sports.yahoo.com/nfl/recap?gid=20130916004"},
{308,"http://sports.yahoo.com/nfl/teams/cin"},
{228,"http://sports.yahoo.com/nhl"},
{308,"http://sports.yahoo.com/nhl/teams/was"},
{684,"http://sr.wikipedia.org/wiki/%D0%92%D0%B8%D1%88%D0%BD%D0%B8_%D0%A1%D0%BB%D0%B0%D0%B2%D0%BA%D0%BE%D0%B2"},
{832,"http://ta.wikipedia.org/wiki/%E0%AE%95%E0%AE%B0%E0%AE%BE%E0%AE%A9%E0%AF%8D_%E0%AE%AA%E0%AE%9F%E0%AF%8D%E0%AE%B2%E0%AE%B0%E0%AF%8D"},
{931,"http://th.wikipedia.org/wiki/%E0%B9%81%E0%B8%84%E0%B8%A3%E0%B8%AD%E0%B8%99_%E0%B8%9A%E0%B8%B1%E0%B8%95%E0%B9%80%E0%B8%A5%E0%B8%AD%E0%B8%A3%E0%B9%8C"},
{818,"http://thptbinhxuyen.edu.vn/vp/Top-200-truong-THPT-co-diem-thi-dai-hoc-cao-nhat-2011-t11736-7938.html"},
{972,"http://tools.wmflabs.org/geohack/geohack.php?pagename=Vy%C5%A1n%C3%BD_Slavkov&params=49_04_N_20_52_E_region:SK_type:city"},
{340,"http://tr.wikipedia.org/wiki/Caron_Butler"},
{604,"http://tr.wikipedia.org/wiki/Te%C5%9Fkil%C3%A2t-%C4%B1_Esas%C3%AEye_Kanunu"},
{204,"http://travel.yahoo.com/"},
{172,"http://tv.yahoo.com/"},
{770,"http://tv.yahoo.com/news/ncis-exclusive-sopranos-alum-eyed-zivas-successor-debut-205821229.html"},
{684,"http://tv.yahoo.com/photos/emmys-unrecognizable-emmy-star-transformations-slideshow/"},
{717,"http://uk.wikipedia.org/wiki/%D0%92%D0%B8%D1%88%D0%BD%D1%96%D0%B9_%D0%A1%D0%BB%D0%B0%D0%B2%D0%BA%D0%BE%D0%B2"},
{801,"http://vi.wikipedia.org/wiki/Tr%C6%B0%E1%BB%9Dng_THPT_chuy%C3%AAn_L%C6%B0%C6%A1ng_V%C4%83n_Ch%C3%A1nh"},
{1046,"http://vi.wikipedia.org/wiki/X%E1%BA%BFp_h%E1%BA%A1ng_tr%C6%B0%E1%BB%9Dng_trung_h%E1%BB%8Dc_ph%E1%BB%95_th%C3%B4ng_Vi%E1%BB%87t_Nam"},
{232,"http://viaf.org/viaf/94287141"},
{684,"http://voices.washingtonpost.com/dcsportsbog/2007/04/on_caron_butler_and_straws.html"},
{436,"http://war.wikipedia.org/wiki/Vy%C5%A1n%C3%BD_Slavkov"},
{505,"http://washingtontimes.com/sports/20060417-122458-4991r_page2.htm"},
{204,"http://weather.yahoo.com"},
{404,"http://weather.yahoo.com/forecast/JAXX0077_f.html"},
{740,"http://web.archive.org/web/20040603025509/http://www.usabasketball.com/history/ymwc_2001.html"},
{260,"http://wikimediafoundation.org/"},
{412,"http://wikimediafoundation.org/wiki/Privacy_policy"},
{396,"http://wikimediafoundation.org/wiki/Terms_of_Use"},
{308,"http://www.anayasa.gen.tr/1921tek.htm"},
{492,"http://www.basketball-reference.com/players/b/butleca01.html"},
{587,"http://www.basketballreference.com/players/playerpage.htm?ilkid=BUTLECA01"},
{380,"http://www.bilkent.edu.tr/~genckaya/1921C.html"},
{308,"http://www.caronbutlersummercamp.com/"},
{308,"http://www.daao.org.au/main/read/2355"},
{386,"http://www.ebi.ac.uk/QuickGO/GProtein?ac=P30046"},
{1416,"http://www.ebi.ac.uk/pdbe/searchResults.html?display=both&term=P30046%20or%20Q53Y51%20or%20E2RQU0%20or%20A5PK65%20or%20O35215%20or%20Q3UNI8%20or%20P80254%20or%20Q5ZMG0%20or%20Q6IQL4"},
{574,"http://www.ensembl.org/Homo_sapiens/geneview?gene=ENSG00000099977;db=core"},
{591,"http://www.ensembl.org/Mus_musculus/geneview?gene=ENSMUSG00000001666;db=core"},
{188,"http://www.flickr.com/"},
{550,"http://www.flickr.com/photos/yahooeditorspicks/galleries/72157635598104765"},
{901,"http://www.flickr.com/photos/yahooeditorspicks/galleries/72157635598104765/with/7037921709/lightbox/?yc=www.yahoo.com"},
{952,"http://www.fool.com/investing/general/2013/09/16/3-car-brands-that-may-disappear-before-2020.aspx?source=eogyholnk0000001"},
{576,"http://www.genecards.org/cgi-bin/carddisp.pl?id_type=entrezgene&id=1652"},
{456,"http://www.genenames.org/data/hgnc_data.php?hgnc_id=2732"},
{443,"http://www.genome.jp/dbget-bin/www_bget?enzyme+4.1.1.84"},
{404,"http://www.gutenberg.org/author/Johann_David_Wyss"},
{597,"http://www.informatics.jax.org/searches/accession_report.cgi?id=MGI:1298381"},
{212,"http://www.intonow.com/ci"},
{348,"http://www.leighrayment.com/baronetage.htm"},
{444,"http://www.london-gazette.co.uk/issues/21964/pages/379"},
{436,"http://www.mapress.com/zootaxa/2010/f/z02583p119f.pdf"},
{340,"http://www.mapress.com/zootaxa/index.html"},
{212,"http://www.mediawiki.org/"},
{544,"http://www.nba.com/allstar2007/news/allstar_reserves_070201.html"},
{332,"http://www.nba.com/news/pow_070122.html"},
{348,"http://www.nba.com/playerfile/caron_butler"},
{356,"http://www.nba.com/playerfile/caron_butler/"},
{492,"http://www.nba.com/suns/news/suns-trade-kravtsov-smith-bucks"},
{588,"http://www.nba.com/suns/suns-complete-deal-eric-bledsoe-and-caron-butler"},
{832,"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=homologene&dopt=HomoloGene&list_uids=1038"},
{812,"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=retrieve&dopt=default&list_uids=13202&rn=1"},
{804,"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=retrieve&dopt=default&list_uids=1652&rn=1"},
{488,"http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_001084392"},
{478,"http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=NM_010027"},
{405,"http://www.ncbi.nlm.nih.gov/pmc/articles/PMC1219731"},
{400,"http://www.ncbi.nlm.nih.gov/pmc/articles/PMC139241"},
{405,"http://www.ncbi.nlm.nih.gov/pmc/articles/PMC1847948"},
{344,"http://www.ncbi.nlm.nih.gov/pubmed/10079069"},
{341,"http://www.ncbi.nlm.nih.gov/pubmed/1286669"},
{341,"http://www.ncbi.nlm.nih.gov/pubmed/8267597"},
{688,"http://www.ncbi.nlm.nih.gov/sites/entrez?Db=gene&Cmd=ShowDetailView&TermToSearch=1652"},
{747,"http://www.ncbi.nlm.nih.gov/sites/entrez?db=gene&cmd=Link&LinkName=gene_pubmed&from_uid=13202"},
{744,"http://www.ncbi.nlm.nih.gov/sites/entrez?db=gene&cmd=Link&LinkName=gene_pubmed&from_uid=1652"},
{428,"http://www.oprah.com/oprahshow/Overcoming-the-Odds/8"},
{428,"http://www.oprah.com/oprahshow/Overcoming-the-Odds/9"},
{412,"http://www.rcsb.org/pdb/cgi/explore.cgi?pdbId=1DPT"},
{1322,"http://www.rcsb.org/pdb/search/smartSubquery.do?smartSearchSubtype=UpAccessionIdQuery&accessionIdList=P30046,Q53Y51,E2RQU0,A5PK65,O35215,Q3UNI8,P80254,Q5ZMG0,Q6IQL4"},
{806,"http://www.sbnation.com/golf/2013/9/17/4737628/bmw-championship-2013-tiger-woods-penalty-johnny-miller"},
{364,"http://www.statistics.sk/mosmis/eng/run.html"},
{188,"http://www.tbmm.gov.tr"},
{372,"http://www.tbmm.gov.tr/english/about_tgna.htm"},
{212,"http://www.thepeerage.com"},
{284,"http://www.thepeerage.com/info.htm"},
{585,"http://www.uconnhuskies.com/AllStories/MBasketball/2002/06/26/20020626.html"},
{304,"http://www.uniprot.org/uniprot/O35215"},
{304,"http://www.uniprot.org/uniprot/P30046"},
{644,"http://www.washingtonpost.com/wp-dyn/content/article/2008/02/16/AR2008021600752_2.html"},
{293,"http://www.wikidata.org/wiki/Q115822"},
{460,"http://www.wikidata.org/wiki/Q115822#sitelinks-wikipedia"},
{292,"http://www.wikimediafoundation.org/"},
{172,"http://www.yahoo.com"},
{180,"http://www.yahoo.com/"},
{188,"http://www.yahoo.com/#"},
{276,"http://www.yahoo.com/#suggestions"},
{244,"http://www.yahoo.com/?hps=210"},
{444,"http://yahoo.match.com?trackingid=526100&bannerid=673168"},
{535,"http://zh.wikipedia.org/wiki/%E5%8D%A1%E9%9A%86%C2%B7%E5%B7%B4%E7%89%B9%E5%8B%92"},
{1164,"https://donate.wikimedia.org/wiki/Special:FundraiserRedirector?utm_source=donate&utm_medium=sidebar&utm_campaign=C13_en.wikipedia.org&uselang=en"},
{740,"https://edit.yahoo.com/registration?.src=fpctx&.intl=us&.done=http%3A%2F%2Fwww.yahoo.com%2F"},
{748,"https://login.yahoo.com/config/login?.src=fpctx&.intl=us&.done=http%3A%2F%2Fwww.yahoo.com%2F"},
{548,"https://www.mediawiki.org/wiki/Special:MyLanguage/How_to_contribute"},
{0,NULL}
};
