#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "include/syscallmgr.h"
#include "ucmd.h"
#include "log.h"

int __NR_sys_audit_log=-1;
int __NR_sys_aprintf=-1;

static inline _syscall3(int,sys_audit_log,int,type,char *,buf,int,len);
static inline _syscall2(int,sys_aprintf,char *,s,int,len);

void main (int argc,char *argv[]) {
	int i,j;
	char buf[1024];
	
	__NR_sys_aprintf=resolve_syscall(SYS_APRINTF_ID,0);
	if (__NR_sys_aprintf==-1) {
	printf("%d\n",__NR_sys_aprintf);
		printf("(aprintf) Error. Probably module not loaded\n");
		exit(2);
	}
	
	__NR_sys_audit_log=resolve_syscall(SYS_AUDIT_LOG_ID,0);
	if (__NR_sys_audit_log==-1) {
		printf("(auditlog) Error. Probably module not loaded\n");
		exit(2);
	}
	
	sys_audit_log(LOG_CLEAR,NULL,0);
        u_aprintf("Auditing started...\n");
	while (1) {
		if ((i=sys_audit_log(LOG_READ,buf,1024))>0) {
			printf("%s",buf);
		} else {
			printf("\n-- %d --\n",i);
		}
	}
}
	
	
	
