# frozen_string_literal: true

class CreateVulnerabilityNamespaceHistoricalStatistic < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  TRAVERSAL_IDS_DATE_INDEX_NAME = 'index_vuln_namespace_historical_statistics_traversal_ids_date'
  NAMESPACE_ID_FK_INDEX_NAME = 'index_vuln_namespace_historical_statistics_on_namespace_id'
  # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
  def up
    create_table :vulnerability_namespace_historical_statistics do |t|
      t.bigint :namespace_id, null: false, index: { name: NAMESPACE_ID_FK_INDEX_NAME }
      t.timestamps_with_timezone null: false
      t.bigint :traversal_ids, array: true, default: [], null: false
      t.integer :total, default: 0, null: false
      t.integer :critical, default: 0, null: false
      t.integer :high, default: 0, null: false
      t.integer :medium, default: 0, null: false
      t.integer :low, default: 0, null: false
      t.integer :unknown, default: 0, null: false
      t.integer :info, default: 0, null: false
      t.date :date, null: false
      t.integer :letter_grade, limit: 1, null: false
      t.index [:traversal_ids, :date], unique: true, name: TRAVERSAL_IDS_DATE_INDEX_NAME
    end
  end
  # rubocop:enable Migration/EnsureFactoryForTable

  def down
    drop_table :vulnerability_namespace_historical_statistics
  end
end
