// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.components.webapk.lib.client;

/** Public key and signature for WebAPKs */
public class ChromeWebApkHostSignature {
    // The public key to verify whether a WebAPK is signed by WebAPK Server.
    public static final byte[] EXPECTED_SIGNATURE = new byte[] {48, -126, 4, 104, 48, -126, 2, -48,
            -96, 3, 2, 1, 2, 2, 20, 120, 33, -22, -36, -115, 7, 116, 66, 116, 113, -122, -126, -124,
            32, 44, 72, -43, 127, -13, -11, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5,
            0, 48, 67, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 15, 48, 13, 6, 3, 85, 4,
            10, 19, 6, 71, 111, 111, 103, 108, 101, 49, 22, 48, 20, 6, 3, 85, 4, 11, 19, 13, 67,
            104, 114, 111, 109, 101, 32, 87, 101, 98, 65, 80, 75, 49, 11, 48, 9, 6, 3, 85, 4, 3, 19,
            2, 67, 65, 48, 30, 23, 13, 49, 54, 48, 56, 50, 51, 50, 48, 48, 56, 49, 49, 90, 23, 13,
            52, 52, 48, 49, 49, 48, 50, 48, 48, 56, 49, 49, 90, 48, 67, 49, 11, 48, 9, 6, 3, 85, 4,
            6, 19, 2, 85, 83, 49, 15, 48, 13, 6, 3, 85, 4, 10, 19, 6, 71, 111, 111, 103, 108, 101,
            49, 22, 48, 20, 6, 3, 85, 4, 11, 19, 13, 67, 104, 114, 111, 109, 101, 32, 87, 101, 98,
            65, 80, 75, 49, 11, 48, 9, 6, 3, 85, 4, 3, 19, 2, 67, 65, 48, -126, 1, -94, 48, 13, 6,
            9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, -113, 0, 48, -126, 1, -118, 2,
            -126, 1, -127, 0, -60, 57, -128, 54, 45, -71, -75, 1, 42, 100, 64, 111, -6, 104, -8,
            -57, -45, 42, 33, 124, 43, 20, -115, -88, -100, -115, -19, 90, 25, 16, 50, -96, 27, 4,
            64, -65, 92, -74, 61, 98, 54, 88, 122, -71, -116, -86, -26, -30, -34, -16, -87, -113,
            103, -81, -76, -2, -120, -124, -70, 41, 30, 46, 75, 119, 22, 61, 92, -8, 92, 55, 8, -53,
            -70, 100, 40, 77, 77, 10, -5, -74, 37, 48, -71, 108, 92, -72, -56, 17, 39, -11, 61, -86,
            -52, -3, -128, 72, 68, 27, 28, -128, -126, 91, 64, -117, -67, 58, 114, -70, 112, -44,
            -70, -51, -81, -95, -78, 12, -1, 123, 68, -96, -32, -76, 65, -59, 37, -31, 88, 34, -125,
            -67, 58, 77, 75, -112, 23, 127, -15, -45, 56, -10, 46, -40, -82, -49, 42, 35, 127, -70,
            120, -37, 8, 24, 38, 59, -1, -39, -104, -85, 101, 43, 39, 107, -35, -7, -80, -38, -47,
            -86, -53, -94, 11, 62, 86, 78, 72, 90, -54, 5, 21, -72, -122, 14, 102, 95, -81, 94, -11,
            -101, 36, -31, 104, -66, -51, 24, -99, 74, 21, -106, 76, 67, 86, 49, 121, 59, -7, 79,
            -87, -115, 27, -82, -98, 15, -5, 13, -90, -20, 70, 17, -68, 124, 82, 35, 53, 76, -52,
            69, 23, -97, -2, -117, 7, -27, 79, 46, -54, -99, 41, -22, -108, -25, 8, 108, 109, -23,
            13, -11, 56, 11, -71, 20, 37, -64, -13, -114, -34, -78, -49, 7, 45, 80, 7, 69, 106, 3,
            -128, 70, 0, 41, -105, 76, 106, -114, 18, -22, 92, -113, -12, 109, 11, 111, 48, -63, 22,
            29, -5, -113, -2, 117, -105, 1, -21, 40, 23, -8, -36, -109, -41, -1, 92, 94, 51, 122,
            -67, -116, -64, 28, 38, 112, 4, -25, -18, -92, 53, -119, -37, 58, -28, 62, -88, 126,
            -66, -113, -101, 57, -66, -48, -88, -47, -65, -65, 108, -116, -52, -87, -33, 30, 121,
            -6, -50, -97, 99, -102, 106, -31, 119, -26, -49, 63, 90, -19, 119, 103, -83, 125, 29,
            -32, -102, -97, -99, -45, 59, 36, 30, 58, 28, 59, 2, 48, 0, -76, 108, 98, 62, 68, -11,
            -82, -74, -38, 93, -22, -79, -110, 73, 13, 2, 3, 1, 0, 1, -93, 84, 48, 82, 48, 14, 6, 3,
            85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 2, -92, 48, 19, 6, 3, 85, 29, 37, 4, 12, 48, 10, 6, 8,
            43, 6, 1, 5, 5, 7, 3, 1, 48, 12, 6, 3, 85, 29, 19, 1, 1, -1, 4, 2, 48, 0, 48, 29, 6, 3,
            85, 29, 14, 4, 22, 4, 20, 62, -89, -113, -1, -62, -65, -19, 4, 56, -51, 41, -53, 51, 41,
            -28, -42, -36, 31, -89, -19, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 11, 5, 0,
            3, -126, 1, -127, 0, 27, -3, -41, -125, 123, -93, 20, -83, -83, -13, -120, -13, -123,
            29, 107, -9, 77, -75, -118, 106, 5, 113, -11, 40, -84, 98, -126, -55, 39, 77, -87, -53,
            -5, 122, -63, -108, 23, 112, -88, 17, 28, 15, -103, 75, 75, 123, -21, 119, 125, -78,
            -125, 87, 78, 41, -103, 6, 9, 91, 89, 42, 86, 25, -62, -30, 117, 22, -107, 53, 66, 56,
            -23, -115, 16, -85, -38, 77, -117, -87, 106, -4, -91, 36, 81, 40, -31, 123, -40, 69,
            -119, -69, -83, -78, 64, 123, 46, 36, 31, -29, 64, 36, -8, -22, -93, 22, -48, -49, 11,
            -67, 48, -1, 26, 94, -82, 65, 6, 82, 18, 91, -56, 118, -55, 111, -18, -114, -86, -98,
            -3, 40, -48, -46, -102, -120, 20, 101, -60, 91, -103, -92, 43, 12, -104, -10, -60, 10,
            -31, -26, 111, -125, 103, 102, -105, 116, -66, -89, -58, 11, 34, 1, 22, 112, 126, 81,
            115, -104, -120, 115, -43, -59, 50, -67, -42, -42, 122, -66, 57, 121, 30, -22, -8, 96,
            114, -110, -98, 102, 41, -64, 115, -44, -84, 10, 63, 19, -105, 118, -2, 98, 45, -49, 94,
            114, 81, -84, -111, -34, -23, 49, 73, 91, 76, 81, 90, 86, 112, 12, -87, -41, -61, -82,
            32, -87, -7, 95, -28, -25, -9, -38, -102, 54, -81, -109, -126, 59, -82, 103, 126, -92,
            -51, -81, 44, 61, 103, 127, -1, -23, -84, -35, -43, -88, 41, 120, 76, 120, 39, -124, 81,
            90, 64, 69, 112, 18, 54, -115, -7, 12, -110, 105, 48, -44, 88, 35, -104, 107, -83, -4,
            -16, 123, 59, -13, 121, 63, -89, 118, 100, 38, 118, -30, 9, -57, -54, -108, -26, -45,
            29, -22, 57, -81, 83, -124, -114, -50, 16, 78, 23, -41, -4, 119, -13, -68, 38, -23, 56,
            22, -96, -63, -27, 70, -94, -35, 111, -45, -9, 59, -90, -27, 103, 95, 16, 127, -118,
            -98, -75, -52, 7, 32, 65, -27, -68, 62, -81, 98, -54, -80, -23, 59, 38, -127, 96, 71,
            123, 34, -113, -23, -80, 32, -97, -55, -100, 121, 120, 50, -48, 58, 69, -105, 26, 126,
            30, -1, -112, -41, -18, -16, 62, 48, -22, -2, 19, 117, -6, 59, 74, -13, 92, -1};

    // The public key for comment signed WebAPK's. Elliptic Curve, NIST P-256 in ASN.1 format.
    public static final byte[] PUBLIC_KEY = new byte[] {48, 89, 48, 19, 6, 7, 42, -122, 72, -50, 61,
            2, 1, 6, 8, 42, -122, 72, -50, 61, 3, 1, 7, 3, 66, 0, 4, -25, 45, 2, 49, 44, -60, 107,
            -108, -45, 27, -40, -8, -116, 44, 7, -38, -103, 52, -81, 33, -90, -80, -94, 125, -3,
            -67, 51, -125, -63, 6, -127, 89, 32, 53, 83, -120, -106, -113, -121, -39, 115, -50, 15,
            117, 66, 78, -89, -124, -120, 4, -61, 8, -90, -67, -6, 71, -120, -120, 23, 23, 77, 75,
            103, -28};
}
