#!/usr/local/bin/tclsh8.0
# generates the webpages to get into a class
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.


proc outputHeader { } {
    puts "Content-type: text/html\n\n<HTML><TITLE></TITLE><BODY bgcolor=\"#ffffff\"> "
}

proc outputFooter {} {
    puts "</BODY></HTML>"
}

proc getid.outputButton { capaid argumentsVar } {
    global machine
    upvar $argumentsVar arguments
    puts "<FORM METHOD=\"POST\"  ACTION=\"http://$machine/capa-bin/capahtml\">"
    puts "<input type=\"HIDDEN\" name=\"M\" value=1>"
    puts "<input type=\"HIDDEN\" name=\"CAPAID\" value=$capaid>"
    puts "<input type=\"HIDDEN\" name=\"SNUM\" value=$arguments(SNUM)>"
    puts "<input type=\"HIDDEN\" name=\"CLASS\" value=$arguments(CLASS)>"
    puts "Click <input type=\"submit\" value=\"  here  \"> to work on <i>CAPA</i>."
    puts "</form>"
}

proc getid.main {argumentsVar} {
    global config classList
    upvar $argumentsVar arguments
    outputHeader
    if { [array names classList $arguments(CLASS).path] != "" } {
	set pwd [pwd]
	catch {cd $classList($arguments(CLASS).path)} error
	 #   puts "hey :$error:"
	catch {set result [exec $config(webpage) -getid $arguments(SNUM) \
			       $arguments(SETID) $arguments(CAPAID) ]} error
	 #   puts "hey :$error:"
	 #   puts "hey :$error:$result:"
	switch $result {
	    InvalidSetId { puts "The set requested, $arguments(SETID), is not a valid set number." }
	    InvalidOldCapaID -
	    NotFound { puts "The provided old <i>CAPA</i>ID ($arguments(CAPAID)) is not a valid <i>CAPA</i>ID for any set previous to the requested set $arguments(SETID)." }
	    NotOpen { puts "The set requested, $arguments(SETID), is not open." }
	    default { puts "Your <i>CAPA</i>ID is <font size=+2>$result</font> for Set $arguments(SETID) in class $arguments(CLASS)."; getid.outputButton $result arguments}
	}
	cd $pwd
    } else {
	puts "Invalid request. Class $arguments(CLASS) not found."
    }
    outputFooter
}

proc capaid.outputButton { capaid argumentsVar } {
    global machine
    upvar $argumentsVar arguments
    puts "<FORM METHOD=\"POST\"  ACTION=\"http://$machine/capa-bin/capahtml\">"
    puts "<input type=\"HIDDEN\" name=\"M\" value=1>"
    puts "<input type=\"HIDDEN\" name=\"CAPAID\" value=$capaid>"
    puts "<input type=\"HIDDEN\" name=\"SNUM\" value=$arguments(SNUM)>"
    puts "<input type=\"HIDDEN\" name=\"CLASS\" value=$arguments(CLASS)>"
    puts "Click <input type=\"submit\" value=\"  here  \"> to work on <i>CAPA</i>."
    puts "</form>"
}

proc capaid.main {argumentsVar} {
    global config classList
    upvar $argumentsVar arguments
    outputHeader
    if { [array names classList $arguments(CLASS).path] != "" } {
	set pwd [pwd]
	catch {cd $classList($arguments(CLASS).path)} error
	#    puts "hey :$error:"
	catch {set result [exec $config(webpage) -getid $arguments(SNUM) \
			       $arguments(SETID)]} error
	#    puts "hey :$error:"
	#    puts "hey :$error:$result:"
	switch $result {
	    InvalidSetId { puts "The set requested, $arguments(SETID), is not a valid set number." }
	    InvalidOldCapaID -
	    NotFound { puts "The provided Student Number $arguments(SNUM) is not a valid for $arguments(CLASS)." }
	    NotOpen { puts "The set requested, $arguments(SETID), is not open." }
	    default { puts "Your <i>CAPA</i>ID is <font size=+2>$result</font> for Set $arguments(SETID) in class $arguments(CLASS)."; capaid.outputButton $result arguments}
	}
	cd $pwd
    } else {
	puts "Invalid request. Class $arguments(CLASS) not found."
    }
    outputFooter
}

proc emailid.sendmail { what who argumentsVar } {
    global config 
    upvar $argumentsVar arguments
    if { $who == "" } {
	puts "There is no e-mail address available for this student. Please contact you r instructor to obtain your <i>CAPA</i>ID."
    } else {
	set mailID [open "|$config(mail) -s \"Requested CAPAID\" $who" w]
	puts $mailID "The CAPAID you requested for class $arguments(CLASS), set number $arguments(SETID) is $what."
	close $mailID
	puts "Your <i>CAPA</i>ID has been mailed to your university e-mail account."
    }    
}

proc emailid.main {argumentsVar} {
    global classList config
    upvar $argumentsVar arguments
    outputHeader
    if { [array names classList $arguments(CLASS).path] != "" } {
	set pwd [pwd]
	if {[catch {cd $classList($arguments(CLASS).path)} error ]} {
	    puts $error; return
	}
	if {[catch {set result [exec $config(webpage) -emailcapaid $arguments(SNUM) \
				    $arguments(SETID) ]} error ]} {
	    puts $error; return
	}
	cd $pwd
	switch $result {
	    InvalidSetId { puts "The set requested, $arguments(SETID), is not a valid set number." }
	    NotOpen { puts "The set requested, $arguments(SETID), is not yet open for access." }
	    NotFound { puts "Unable to find student number $arguments(SNUM) in classlist."}
	    default {
		if { [catch { eval "emailid.sendmail $result arguments" } error ] } {
		    puts "$error:There is no e-mail address available for this student. Please contact your instructor to obtain your <i>CAPA</i>ID."
		}
	    }
	}
    } else {
	puts "Invalid request. Class $arguments(CLASS) not found."
    }
    
    outputFooter
}

proc getSettings { } {
    global classList
    set confID [open "class.conf"]
    set aline [gets $confID]
    while {![eof $confID]} {
	set class [lindex $aline 0]
	set path [lindex $aline 1]
	set classList($class.path) [file join $path $class]
	set aline [gets $confID]
    }
}

proc ids.main {} {
    global env
    getSettings
    set request [string trim [read file0]]
    foreach {var value} [split $request "&="] {set arguments($var) [string trim $value]}
    catch {set arguments(SETID) [string trimleft $arguments(SETID) 0]}
    catch {set logFileId [open ids.log "a"]} error

    set b [split $request "&="]
    if { [catch {lappend b $env(REMOTE_HOST)}]} {
	if { [catch {lappend b $env(REMOTE_ADDR)}] } {
	    lappend b UNKNOWN
	}
    }
    puts $logFileId "[clock format [clock seconds]] $b"
    close $logFileId
    
    $arguments(TYPE).main arguments
}

proc optionlist { match } {
    global env
    set request ""
    catch {puts $env(QUERY_STRING)}
    catch {set request [string trim $env(QUERY_STRING)]}
    if { $request == "" } {
	set arguments(CLASS) ""
    } else {
     foreach {var value} [split $request "&="] {set arguments($var) [string trim $value]}
    }
    set confID [open "class.conf"]
    set aline [gets $confID]
    while {!([eof $confID] && ($aline == ""))} {
	set type [lindex $aline 3]
	if { [lsearch $type $match] != -1 } {
	    set classname [lindex $aline 0]
	    if { [string toupper $classname] == [string toupper $arguments(CLASS)] } {
		puts "<option selected> [lindex $aline 0]"
	    } else {
		puts "<option> [lindex $aline 0]"
	    }
	}
	set aline [gets $confID]
    }
}

proc main {} {
    global argv0 machine class.head class.tail emailid.head emailid.tail \
	getid.head getid.tail capaid.head capaid.tail config 
    eval "global [info globals]"
    source web.settings
    switch -glob -- [file tail $argv0] {
	class.* -
	index.* {
	    puts "Content-type: text/html\n\n"
	    puts "<!-- class.html 5.1 -->"
	    puts [subst -nocommands ${class.head}]
	    optionlist class
	    puts [subst -nocommands ${class.tail}]
	}
	emailid.* {
	    puts "Content-type: text/html\n\n"
	    puts "<!-- emailid.html 5.1 -->"
	    puts [subst -nocommands ${emailid.head}]
	    optionlist emailid
	    puts [subst -nocommands ${emailid.tail}]
	}
	getid.* {
	    puts "Content-type: text/html\n\n"
	    puts "<!-- getid.html 5.1 -->"
	    puts [subst -nocommands ${getid.head}]
	    optionlist getid
	    puts [subst -nocommands ${getid.tail}]
	}
	capaid.* {
	    puts "Content-type: text/html\n\n"
	    puts "<!-- capaid.html 5.1 -->"
	    puts [subst -nocommands ${capaid.head}]
	    optionlist capaid
	    puts [subst -nocommands ${capaid.tail}]
	}
	default { ids.main }
    }
}

main
