/***************************************************************************/
/* TestView.h - interface file for TestView class for the BitmapTest App   */
/* January 1990 Carl F. Sutter							   */
/***************************************************************************/

#import <appkit/View.h>
#import <objc/List.h>
#import "Animator.h"
#import "MovingBitmap.h"

@interface TestView:View
   {
   /* outlets */
   id	count;
   id	size;
   id	speed;
   id	timerPeriod;
   id	xVel, yVel;
   
   /* internal instance variables */ 
   Animator	*timer;  			// Instance of Animator object
   List		*listMB;		// list of moving bitmaps
   BOOL		bMoving;		// flag set if bitmaps are moving
   BOOL		bGState;		// flag indicating if a GState is being saved
   BOOL		bPing;		// flag indicating is being used in drawing
   BOOL		bEraseBackground;	// flag to erase whole view before each draw
   BOOL		bEraseBitmaps;	// flag to tell bitmaps to erase themselves
   BOOL		bTightDrawLoop;	// flag to draw in a loop until any event
   BOOL		bRandomVelocity;	// flag to use random velocity for new bitmaps
   NXSize	nxsMinWindow;		// minimum size of window to hold controls
   double	dPeriod;			// timer period
   }

/* factory method */
+ newFrame:(NXRect *)rect;

/* outlet initialization methods */
- setCount:anObject;
- setSize:anObject;
- setSpeed:anObject;
- setTimerPeriod:anObject;
- setXVel:anObject;
- setYVel:anObject;

/* application and window delegate messages */
- appDidInit:(id)sender;
- windowWillResize:sender toSize:(NXSize *)frameSize;
- windowDidResize:(id)sender;

/* actions */
- setPeriod:sender;
- create:sender;
- removeOne:sender;
- start:sender;
- allocateGState:sender;
- nxPing:sender;
- eraseBackground:sender;
- eraseBitmaps:sender;
- tightDrawLoop:sender;
- randomVel:sender;

/* internal methods */
- step:sender;
- drawBitmaps;
- drawSelf:(NXRect *)r :(int) count;

@end
