/* options to add
/* introduce specifying rows and columns and labeling each subimage */
/* using the max and min in each sub-image 
/* 
*/

/* explore using sunrastII  on robotics systems instead of rastsun */

/* coverts images from cpl to char format (0-255) range */
/* The values of the range are read from file Sframe and mapped to */
/* 0-255 , and printed out as a single large image so as to fit on */
/* the console */
/* image by image */
#include <stdio.h>
#include <math.h>

/*#define ScreenWidth 900
#define ScreenHeight 1152 /* temporarirly exchange these two to get */
			  /* portrait images for transparency */
#define image(y,x) image[(y)*screenWidth+x]
#define edge(y,x)  edge[(y)*screenWidth+x]

int noOfHWindows, noOfVWindows;
int screenWidth, screenHeight;
int nwind; /* actual number of windows */
int imRows,imColumns,Factor;
int ScreenWidth;
int ScreenHeight;
int rowset,columnset;
int wR;
char display[100];

char filename[30];
float RangeL,RangeH; /* range of values to displays. rangeL maps to 0 */
		   /* and RangeH maps to 255 */
int Hexagonal;
int Skip; /* Skip = 2 means display 1 and skip 2 views */
int BlackAndWhite,EDGE,Initial;
int displayAll;

#define TitleHeight 20
FILE *fp;

main(argc, argv)
int argc;
char *argv[];
{
  char rastCall[200];
  int myscreen;
  unsigned long myforeground, mybackground;
  int i;
  char text[10];
  int done;
  
  getArgs(argc,argv);
  wR = windowsRequired();

  if (noOfHWindows*noOfVWindows == 0) {/* If either hasn't been set */
    if ( !displayAll) {
      if (noOfHWindows  == 0) {
	for(noOfHWindows=1;TitleHeight + noOfHWindows*(imColumns+Factor)*Factor
	    <=ScreenWidth; noOfHWindows++);
	--noOfHWindows;
      }
      if (noOfVWindows  == 0) {
	for(noOfVWindows=1;noOfVWindows*(imRows + Factor)*Factor <= ScreenHeight;
	    noOfVWindows++);
	--noOfVWindows; 
      }
      if( noOfVWindows * noOfHWindows > wR) {
	if (!(rowset || columnset)) {
	  noOfHWindows= irint(sqrt(1.0*wR*ScreenWidth*imRows/imColumns/ScreenHeight));
	  noOfVWindows = ceil(1.0*wR/noOfHWindows);
	}
	else if (rowset)
	  noOfHWindows = ceil(1.0*wR/noOfVWindows);
	else if (columnset)
	  noOfVWindows = ceil(1.0*wR/noOfHWindows);
      }
      else if ( noOfVWindows * noOfHWindows < wR) {
	fprintf(stderr,"Cannot display all the %d images on one screen\n", 
		wR, "displaying only the top %d images\n", 
		noOfVWindows * noOfHWindows, 
		"Use the -A option to display images larger than screen size\n");
	wR = noOfVWindows * noOfHWindows; /* change wR to what is feasible */
      }
    }
    else { /* display All */
      if (noOfHWindows  == 0) 
	noOfHWindows = irint(sqrt(1.0*wR*ScreenWidth*imRows/imColumns/ScreenHeight));
      if (noOfVWindows  == 0) 
	noOfVWindows = ceil(1.0*wR/noOfHWindows);
    }
    if ( !columnset && (noOfHWindows-1)*noOfVWindows >= wR) noOfHWindows--;
  }
  else if (wR > noOfHWindows*noOfVWindows) {
    fprintf(stderr,
	"Cannot display all the %d images in %d rows and %d columns\n", 
	wR, noOfVWindows,  noOfHWindows, "displaying only the top %d images\n",
	    noOfVWindows * noOfHWindows, "\n");
    wR = noOfHWindows*noOfVWindows;
  }

  screenWidth= noOfHWindows*(imColumns+Factor)*Factor+ Factor; 
  /* extra one for the boundary */
  screenHeight= noOfVWindows*(imRows + Factor)*Factor+ Factor;
  fprintf(stdout, "%d windows each of size (%d,%d) arranged in %d rows and %d columns\n",
	  wR,(imColumns+Factor),(imRows + Factor), noOfVWindows,noOfHWindows);
  
  makeCharFormat();
  if (display[0] == ' ')
    sprintf(rastCall,"rm -f cpl.img;rastsun -r %d -c %d < /tmp/cpl.ras > cpl.img;rm -f /tmp/cpl.ras;xv cpl.img &",
	    screenHeight,screenWidth);
  else
    sprintf(rastCall,"rm -f cpl.img;rastsun -r %d -c %d </tmp/cpl.ras > cpl.img;rm -f /tmp/cpl.ras;xv cpl.img -display %s &",
	  screenHeight,screenWidth,display);
  fprintf(stdout,"System call being made:\n%s\n",rastCall);
  system(rastCall);
  exit(0);
}


makeCharFormat()
{
  unsigned char *image,*edge;
  int x,y,i;
  char c;
  unsigned char pc;
  float tis;
  int count=0,shift=0;
  int hWind=0, vWind=0;
  int skip;
  float tisMin=9999999,tisMax=-99999999;
  int pointsDisplayed;
  
  image = (char *)malloc(screenHeight*screenWidth);
  for (y=0;y<screenHeight;y++)
    for (x=0;x<screenWidth;x++)
      image(y,x) = (unsigned char)(RangeH>=RangeL)?255:0;
  
  hWind=vWind=0;
  fp=fopen(filename, "r");
  for (skip =1;skip<=Initial;skip++) /* skip "Skip" # of pictures */
    if (getc(fp) == EOF) break;
    else for ( y=imRows-1; y>=0; y--) {
      /* only lines with colons count */
      while ((c=getc(fp)) !=':' && c!=EOF); /* skip to beginning of line */
      while ((c=getc(fp)) !='\n' && c !=EOF); /* skip to end of line */
    }
  while((c=getc(fp)) != EOF && count < wR) {
    pointsDisplayed = 0;
    for ( y=(imRows-1); y>=0; y--) {
      shift = (y-imRows/2)*(Factor/2);
      while ((c=getc(fp)) !=':' && c !=EOF); /* skip to beginning of line */
      for(x=0;x < imColumns; x++){
	if (fscanf(fp,"%f ",&tis) == EOF) break;
	if (tis!=0)
	  if (tis < tisMin) tisMin=tis;
	  else if (tis > tisMax) tisMax=tis;
	if (BlackAndWhite) 
	  if (tis >= RangeL && tis <= RangeH) {
	    pc = (unsigned char)(RangeH>=RangeL)?0:255;
	    pointsDisplayed++;
	  }
	  else pc = (unsigned char)(RangeH>=RangeL)?255:0;
	else { /* Grey Scale */
	  if (RangeL < RangeH) {
	    if (tis < RangeL) tis = RangeL;
	    if (tis > RangeH) tis = RangeH;
	    pc = (int)((RangeH-tis)*255/(RangeH-RangeL));
	  }
	  else {
	    if (tis > RangeL) tis = RangeL;
	    if (tis < RangeH) tis = RangeH;
	    pc = BlackAndWhite?255:(int)((tis-RangeH)*255/(RangeL-RangeH));
	  }
	}
	if (Hexagonal) 
	  image( Factor*(vWind*(imRows+Factor) + ((imRows+Factor)-1-y)),
		Factor*(hWind*(imColumns + Factor)+1 + x) + shift) =  
		  image( Factor*(vWind*(imRows+Factor) + ((imRows+Factor)-1-y)),
			Factor*(hWind*(imColumns + Factor)+1 + x) + shift + 1) = 
			  image( Factor*(vWind*(imRows+Factor) + ((imRows+Factor)-1-y))+1,
				Factor*(hWind*(imColumns + Factor)+1 + x) +shift) = 
				  image( Factor*(vWind*(imRows+Factor) + ((imRows+Factor)-1-y))+1,
					Factor*(hWind*(imColumns + Factor)+1 + x) +shift +1)
				    = pc;
	else
	  image( vWind*(imRows+Factor) + ((imRows+Factor)-1-y),
		1+hWind*(imColumns + Factor)+ x) = pc;
      }
      while ((c=getc(fp)) !='\n' && c !=EOF); /* skip to end of line */
    }
    if (BlackAndWhite)
      fprintf(stdout,"In image section %d: Number of visible points = %d\n", 
	      count,pointsDisplayed);
    for (skip =1;skip<=Skip;skip++) /* skip "Skip" # of pictures */
      if (getc(fp) == EOF) break;
      else for ( y=imRows-1; y>=0; y--) {
	/* only lines with colons count */
	while ((c=getc(fp)) !=':' && c!=EOF); /* skip to beginning of line */
	while ((c=getc(fp)) !='\n' && c !=EOF); /* skip to end of line */
      }
    count++;
    hWind++;
    if (hWind==noOfHWindows){hWind=0; vWind++;}
  }
  fclose(fp);
  fprintf(stdout," Minumum found = %f, Maximum found = %f\n",tisMin,tisMax);
  
  if (EDGE) {
    edge = (char *)malloc(screenHeight*screenWidth);
    for (y=0;y<screenHeight;y++)
      for (x=0;x<screenWidth;x++)
	edge(y,x) = (unsigned char)(RangeH>=RangeL)?255:0;
    for (y=1;y<screenHeight;y++)
      for (x=1;x<screenWidth;x++)
	if (image(y,x) != image(y-1,x) || image(y,x) != image(y,x-1) || 
	    image(y,x) != image(y-1,x-1)) 
	  edge(y,x) = (unsigned char)(RangeH<=RangeL)?255:0;
    
    free(image);
    image = edge;
  }

  /* mark boundary */
  for (y=0;y<=noOfVWindows;y++)
    for (x=0;x<screenWidth;x++) 
      image( y*(imRows+Factor)*Factor,x) =
	image(y*(imRows+Factor)*Factor + Factor - 1,x) = 
	  (unsigned char)(RangeH>=RangeL)?0:255; 
  
  for (y=0;y<screenHeight;y++)
    for (x=0;x<=noOfHWindows;x++)
      image(y,x*(imColumns + Factor)*Factor) = 
	image(y,x*(imColumns + Factor)*Factor + Factor -1) = 
	  (unsigned char)(RangeH>=RangeL)?0:255; 
  
  fp = fopen("/tmp/cpl.ras","w");
  for (y=0;y<screenHeight;y++)
    for (x=0;x<screenWidth;x++)
      putc(image(y,x),fp);
  fclose(fp);
  nwind= count;
}

int windowsRequired()
{
  int y,result=0;
  char c,line[1000];
  int skip;
  
  fp=fopen(filename, "r");
  if (fp==NULL) {
    fprintf(stderr,"%s: file does not exist\n",filename);
    exit(2);
  }
  /* explicit information about image size */
  while( fscanf(fp,"%s\n",line) != EOF && imRows == 0) 
    if (strncmp(line,"GridSize->(",strlen("GridSize->(")) == 0)
      sscanf(line,"GridSize->(%d,%d)",&imColumns,&imRows);
  if (imRows == 0)
    fprintf(stderr,"%s: Information about grid size not found, assuming equal number of rows and columns in each sub image. They can also be explicitly specified using -mageRows option\n",filename);

  /* implicit information about number of columns */
  fclose(fp);
  fp=fopen(filename, "r");
  while ((c=getc(fp)) !=':' && c !=EOF); 
  if (c==EOF) {
    fprintf(stderr,"%s: no CPL image data in file\n",filename);
    exit(3);
  }
  imColumns=0;
  c=getc(fp);
  while ((c=getc(fp)) !=':' && c !=EOF) 
    if (c==' ') imColumns++;
  if (imRows == 0) imRows = imColumns;
  while(getc(fp) != EOF) {
    result++;
    for ( y=imRows-1; y>=0; y--) {
      /* only lines with colons count */
      while ((c=getc(fp)) !=':' && c!=EOF); /* skip to beginning of line */
      while ((c=getc(fp)) !='\n' && c != EOF); /* skip to end of line */
      if (c == EOF) { /* incomplete last image */
	break;
      }
    }
  }
  fclose(fp);
  return (result-Initial-1)/(Skip+1)+1;
}

getArgs(argc, argv) 
     int argc;
     char **argv;
{
  int argx;

  RangeL=RangeH=Hexagonal=Skip=Initial=0;
  BlackAndWhite =0;
  Factor=1;
  displayAll=0;
  ScreenWidth =1152;
  ScreenHeight = 900;
  noOfHWindows = noOfVWindows =0;
  rowset=columnset=0;

  argx=1;
  if (argc == 1) {
    fprintf(stdout,"Usage: %s -f <input-file> -l <lower-bound> -u <upper-bound> [-hexagonal] [-s <skip-images>] [-i <skip-initial-images>] [-blackAndWhite] [-all] [-portrait] [-rows <row-count>] [-columns <column-count>] [-mageRows <rows-in-each-subframe>] [-edge] [-display DISPLAY]\n", argv[0]);
    exit(-1);
  }
  while (argx <argc) {
    switch (argv[argx][1] ) {
      case 'f':
	strcpy( filename, argv[++argx]);
	fprintf(stdout,"Input file name: %s\n", filename);
	break;
      case 'l':
	sscanf(argv[++argx], "%f", &RangeL);
	fprintf(stdout,"Lower Range: %f\n", RangeL);
	break;
      case 'u':
	sscanf(argv[++argx], "%f", &RangeH);
	fprintf(stdout,"Upper Range: %f\n", RangeH);
	break;
      case 'h':
	Hexagonal=1;
	Factor =2; /* image size gets doubled to handle hexagonal topology */
	fprintf(stdout,"Hexagonal Geometry\n");
	break;
      case 'a':
	displayAll = 1;
	fprintf(stdout,"Displaying all images even if they exceed screen size\n");
	break;
      case 's':
	sscanf(argv[++argx], "%d", &Skip);
	fprintf(stdout,"Skip Images: %d \n", Skip);
	break;
      case 'i':
	sscanf(argv[++argx], "%d", &Initial);
	fprintf(stdout,"Initial images to skip: %d\n", Initial);
	break;
      case 'b':
	BlackAndWhite = 1;
	fprintf(stdout,"Black & White\n");
	break;
      case 'p': /*portrait mode */
	ScreenHeight = 1152;
	ScreenWidth = 900;
	fprintf(stdout,"Portrait Mode\n");
	break;
      case 'm':
	sscanf(argv[++argx], "%d", &imRows);
	fprintf(stdout,"Number of rows in each subframe: %d \n", imRows);
	break;
      case 'e':
	EDGE = 1;
	fprintf(stdout,"Only edges displayed\n");
	break;
      case 'r':
	sscanf(argv[++argx], "%d", &noOfVWindows);
	rowset=1;
	fprintf(stdout,"Number of subframe rows: %d \n", noOfVWindows);
	break;
      case 'c':
	sscanf(argv[++argx], "%d", &noOfHWindows);
	columnset=1;
	fprintf(stdout,"Number of subframe columns: %d \n", noOfHWindows);
	break;
      case 'd':
	strcpy( display, argv[++argx]);
	fprintf(stdout,"Displayed on screen: %s\n",display);
	break;
      default:
	fprintf(stderr, "**********unexpected arg: %s**********\n", argv[argx]);
      }
      argx++;
  }

}
