// This may look like C code, but it is really -*- C++ -*-
#include "header.h"
#include "cell.h"
#include "tissue.h"
#define RANDOM_ORDERING

extern "C" void monitor(int);

Tissue*  tissue[MAX_NUMBER_TISSUES];
Cell*    cell[MAX_NUMBER_CELLS];

int floatToInt(float x)
{
  return int(x>=0?x+0.5:x-0.5);
}

int* 
randomOrdering( int n)
// returns an array containing a random ordering of numbers from 1 to n
{

  int* orderArray = new int[ n + 1];
  for( int i=1; i<=n; i++) orderArray[ i] = i;
#ifndef RANDOM_ORDERING
  return orderArray; 
#endif
  for( i=n; i>=2; i--)
    {
      int r = (int) (random()%i +1);
      // exchange location r with location i
      int tmp = orderArray[ i];
      orderArray[ i] = orderArray[ r];
      orderArray[ r] = tmp;
    }
  return orderArray;
}

void
error(char *msg)
{
  cerr << msg << '\n';
}

int 
randBetween( int low, int high) 
/* Returns a random number r, low<=r<=high */
{
  return ( random()%(high-low+1)+low );
}

void 
saveSimulation( float time)
{
#ifdef _NEW_STREAMS
  ofstream status ("STATUS");
#else
  File statusFile("STATUS", io_writeonly, a_create);
  ostream status (statusFile.filedesc(), io_writeonly);
#endif
  status << time << ' ' << Cell::numberDefined << '\n';
  for (int i = 0; i < Cell::numberDefined; i++)
    cell[ i]->saveState( status);
}

float
resumeSimulation(char *filename)
{
//  initializeSymbolTableAndProgram( FALSE); // ColdStart= FALSE

#ifdef _NEW_STREAMS
  ifstream recover (filename);
#else
  File recoveryFile(filename, io_readonly, a_useonly);
  istream recover (recoveryFile.filedesc(), io_readonly);
#endif
  float time;
  int numberDefined;
  recover >> time >> numberDefined;
  delete cell[0];
  for (int i = 0; i < numberDefined; i++)
    cell[ i] = new Cell( recover);
  return time;
}

void 
getArgs(int argc,char *argv[], int& ColdStart, float& runtime, char* filename)
{

  ColdStart = 1;// default: start from scratch
  int argx=1;
  if (argc == 1) {
    fprintf(stderr,"Usage: %s -t <run-time> [-resume <file-name>]\n",argv[0]);
    exit(-1);
  }
  while (argx <argc) {
    switch (argv[argx][1] ) {
    case 't':
      if (argx+1 >= argc) {
	fprintf(stderr,"Usage: %s -t <run-time> [-resume <file-name>]\n",argv[0]);
	exit(-1);
      }
      sscanf(argv[++argx], "%f", &runtime);
      cout << "Run time-> " << runtime << '\n';
      break;
    case 'r': {
      ColdStart=0;
      if (argx+1 >= argc) {
	fprintf(stderr,"Usage: %s -t <run-time> [-resume <file-name>]\n",argv[0]);
	exit(-1);
      }
      strcpy( filename, argv[++argx]);
      ifstream from(filename);
      if (from)
	fprintf(stderr,"Simulation will be resumed from previous stoppage using %s as the status file\n",filename);
      else {
	cerr << "Cannot open saved status file:" << filename << " from which simulation was to be recovered\n";
	exit(-1);
      }
    }
      break;
    default:
      fprintf(stderr, "**********unexpected arg: %s**********\n", argv[argx]);
    }
    argx++;
  }
}

main(int argc, char* argv[])
{
  int ColdStart;
  float startTime;
  float runtime;
  char filename[30];

  getArgs(argc, argv, ColdStart, runtime, filename);
  initializeTissue();
  if (ColdStart) {
    cell[ 0]->_cellInitialize();
    startTime = 0;
  }
  else startTime = resumeSimulation(filename);

  Int c;
  int cellCount = Cell::numberDefined;
  int* randOrder = randomOrdering( cellCount - 2); // leave out the
						   // environment and the
						   // observer 
  Cell::setTime( startTime);
  cell[ 1]->executeState(); //observer cell executes before start of simulation
  for( float time = startTime+Cell::intervalf; time <= runtime;
       time+=Cell::intervalf) 
    {
      Cell::setTime( time);
      for( c = 2; c < cellCount; c++)
	cell[ c]->startTimeStep();

      for( int i = 1; i <= cellCount - 2; i++)
	{
	  c = randOrder[ i] + 1;
	  cell[ c]->executeState();
	}
      cell[ 1]->executeState(); // observer cell executes after all the others
      cellCount = Cell::numberDefined; // in case new cells were created
#ifdef RANDOM_ORDERING
      delete randOrder;
      randOrder = randomOrdering( cellCount - 2);
#endif
  }
  monitor(0); // compile with -pg or -p, to get profile
  cerr << "DONE\n";
//  exit(0);
}
