#include "cell.h"
#include "tissue.h"

extern Tissue* tissue[];
extern Cell* cell[];

void initializeTissue(){
tissue[ 0] = new Tissue( "environment",0);
tissue[ 1] = new Tissue( "observer",3);
tissue[ 2] = new Tissue( "generic",1);
Cell::intervalf = 1.000000;
Cell::height = 53;
Cell::width = 53;
cell[ 0] = new Cell( (Cell*) 0, FALSE);
}

void Cell::startTimeStep()
//  Set all the cell variables to the new values 
{
}

void Cell::divideCopyVar( Cell* p)
// Copy all the cell variables from p after a division 
{
 _CPLenergy = p->_CPLenergy;
 _CPLcontact = p->_CPLcontact;
 _CPLdir = p->_CPLdir;
 _CPLbest = p->_CPLbest;
 _CPLcurrent = p->_CPLcurrent;
}

void Cell::saveVar(ofstream& s)
//  Save the user defined variables and biochemicals 
{
s << _CPLenergy <<'\n';
s << _CPLcontact <<'\n';
_CPLdir.saveState(s);
s << _CPLbest <<'\n';
s << _CPLcurrent <<'\n';
}

void Cell::recoverVar(ifstream& s)
//  recover the user defined variables and biochemicals 
{
s >> _CPLenergy;
s >> _CPLcontact;
_CPLdir.recoverState(s);
s >> _CPLbest;
s >> _CPLcurrent;
}

void Cell::_CPLdoNothing() {}


#line 25 "adhes.cpl"
void Cell::_CPLsplitUp() {

#line 26 "adhes.cpl"
if ((randBetween(0,4) <= 2)) {
_CPLcontact = 1;
}

#line 27 "adhes.cpl"
 else {
if ((randBetween(0,2) <= 1)) {
_CPLcontact = 2;
}

#line 28 "adhes.cpl"

#line 29 "adhes.cpl"
 else {
_CPLcontact = 4;
}
}

#line 30 "adhes.cpl"
code = &_CPLmotion;
 stateCounter = 2;
 return;

#line 31 "adhes.cpl"
}


#line 32 "adhes.cpl"
void Cell::_CPLmotion() {

#line 33 "adhes.cpl"
_CPLenergy = 0;

#line 34 "adhes.cpl"
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();

#line 35 "adhes.cpl"

#line 36 "adhes.cpl"
_CPLenergy += currentNeighbor->cell->_CPLcontact;
}; // end for each neighbor do


#line 37 "adhes.cpl"
_CPLbest = 0;

#line 38 "adhes.cpl"
// for each neighbor do
if (neighborListCurrent) 
// old list of neighbors exists, use it
neighbor->resetList();
   else {
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
if (DEBUG || debug) neighbor->display(cerr);
neighborListCurrent = TRUE;
  }

while (!neighbor->emptyList()) {
currentNeighbor = neighbor->nextItemInList();

#line 39 "adhes.cpl"
if ((currentNeighbor->cell->_CPLcontact != _CPLcontact)
#line 40 "adhes.cpl"
) {

#line 41 "adhes.cpl"
_CPLcurrent = _CPLenergy * currentNeighbor->cell->_CPLcontact + currentNeighbor->cell->_CPLenergy * _CPLcontact - 
#line 42 "adhes.cpl"
(_CPLenergy * _CPLcontact + currentNeighbor->cell->_CPLenergy * currentNeighbor->cell->_CPLcontact) - 
#line 43 "adhes.cpl"
(_CPLcontact - currentNeighbor->cell->_CPLcontact) * (_CPLcontact - currentNeighbor->cell->_CPLcontact);

#line 44 "adhes.cpl"
if ((_CPLcurrent > _CPLbest)) {

#line 45 "adhes.cpl"
_CPLbest = _CPLcurrent;

#line 46 "adhes.cpl"
_CPLdir = currentNeighbor->direction;

#line 47 "adhes.cpl"
}

#line 48 "adhes.cpl"
}

#line 49 "adhes.cpl"
}; // end for each neighbor do

if ((_CPLbest > 0 && randBetween(0,1) == 0)
#line 50 "adhes.cpl"
) {
{// with neighbor do 
 FPoint _CPLdirection = matrix->getLocation( cellNumber) +_CPLdir;
 int neighb = matrix->findNeighborInDirection( cellNumber, _CPLdirection);
 if (neighborListCurrent)
neighbor->resetList();
else {
 // reconstruct neighbor list
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
neighborListCurrent = TRUE;
}
while (!neighbor->emptyList() && neighb != 
(currentNeighbor = neighbor->nextItemInList())->cell->cellNumber);
if ( neighb != currentNeighbor->cell->cellNumber){
error("Error:cplCode.cc-> Shouldn't be in this part of the code, In with neighbor do, mistakenly thought neighbors were current");
#ifdef STABLE_NEIGHBORS
error("Try recompiling the entire program with -USTABLE_NEIGHBORS");
#endif STABLE_NEIGHBORS
}


#line 51 "adhes.cpl"

#line 52 "adhes.cpl"
cout <<matrix->getLocation( cellNumber) << ' ';

#line 53 "adhes.cpl"
cout <<currentNeighbor->cell->_CPLcontact << ' ';

#line 54 "adhes.cpl"
cout << "\n";

#line 55 "adhes.cpl"
matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +_CPLdir);
neighborListCurrent = FALSE;

#line 56 "adhes.cpl"
cout <<matrix->getLocation( cellNumber) << ' ';

#line 57 "adhes.cpl"
cout <<_CPLcontact << ' ';

#line 58 "adhes.cpl"
cout << "\n";

#line 59 "adhes.cpl"

#line 60 "adhes.cpl"
currentNeighbor = (neighborInfo* ) Undefined;
}// end with neighbor do 
}

#line 61 "adhes.cpl"

#line 62 "adhes.cpl"
if ((randBetween(0,3) == 0)) {

#line 63 "adhes.cpl"
_CPLdir = matrix->randomDirection();

#line 64 "adhes.cpl"
{// with neighbor do 
 FPoint _CPLdirection = matrix->getLocation( cellNumber) +_CPLdir
#line 65 "adhes.cpl"
;
 int neighb = matrix->findNeighborInDirection( cellNumber, _CPLdirection);
 if (neighborListCurrent)
neighbor->resetList();
else {
 // reconstruct neighbor list
  if (neighbor != NULL) delete neighbor;
neighbor = matrix->neighborList( cellNumber, perimeter);
neighborListCurrent = TRUE;
}
while (!neighbor->emptyList() && neighb != 
(currentNeighbor = neighbor->nextItemInList())->cell->cellNumber);
if ( neighb != currentNeighbor->cell->cellNumber){
error("Error:cplCode.cc-> Shouldn't be in this part of the code, In with neighbor do, mistakenly thought neighbors were current");
#ifdef STABLE_NEIGHBORS
error("Try recompiling the entire program with -USTABLE_NEIGHBORS");
#endif STABLE_NEIGHBORS
}

if ((currentNeighbor->cell->_CPLcontact != _CPLcontact && currentNeighbor->cell->_CPLcontact > 0)) {

#line 66 "adhes.cpl"

#line 67 "adhes.cpl"
cout <<matrix->getLocation( cellNumber) << ' ';

#line 68 "adhes.cpl"
cout <<currentNeighbor->cell->_CPLcontact << ' ';

#line 69 "adhes.cpl"
cout << "\n";

#line 70 "adhes.cpl"
matrix->swapCellDirection( cellNumber, matrix->getLocation( cellNumber) +_CPLdir);
neighborListCurrent = FALSE;

#line 71 "adhes.cpl"
cout <<matrix->getLocation( cellNumber) << ' ';

#line 72 "adhes.cpl"
cout <<_CPLcontact << ' ';

#line 73 "adhes.cpl"
cout << "\n";

#line 74 "adhes.cpl"

#line 75 "adhes.cpl"
}

#line 76 "adhes.cpl"
currentNeighbor = (neighborInfo* ) Undefined;
}// end with neighbor do 
}

#line 77 "adhes.cpl"

#line 78 "adhes.cpl"
}


#line 79 "adhes.cpl"

#line 80 "adhes.cpl"

#line 81 "adhes.cpl"

#line 82 "adhes.cpl"
void Cell::_CPLunnamedState_a() {
cout << "Time = ";

#line 83 "adhes.cpl"
cout <<time << ' ';

#line 84 "adhes.cpl"
cout << " \n";

#line 85 "adhes.cpl"
if ((int((time - 1) / 20) * 20 == int(time - 1))) {

#line 86 "adhes.cpl"
{
for (int y = height - 1; y >= 0; y--)
{
cout << "@ " << y << ':';
for(int x = 0; x < width; x++)
cout << cell[ matrix->getCell(x,y)]->_CPLcontact << ' ';
cout << ':' << y << '\n';
}
}

#line 87 "adhes.cpl"
}

#line 88 "adhes.cpl"
}


#line 89 "adhes.cpl"

#line 90 "adhes.cpl"
 void Cell::_cellInitialize()
 {
PointList InFigure; 
// Define the observer cell
cell[ 1] = new Cell( cell[0], FALSE);
cell[ 1]->area = 0;
cell[ 1]->dummy = TRUE;
cell[ 1]->tissueType = 1;
cell[ 1]->stateCounter  = tissue[ 1]->state;
cell[ 1]->code = stateCode[ cell[ 1]->stateCounter];


#line 91 "adhes.cpl"

#line 92 "adhes.cpl"

#line 93 "adhes.cpl"
InFigure.AddHexagon(26,26,25);
while ( !InFigure.emptyList()) {
matrix->markCell( InFigure.delget(), Cell::numberDefined);
cell[ Cell::numberDefined - 1] = new Cell( cell[0], FALSE);
cell[ Cell::numberDefined - 1]->area = matrix->getArea( Cell::numberDefined - 1);

cell[ Cell::numberDefined - 1]->tissueType = 2;
cell[ Cell::numberDefined - 1]->stateCounter  = tissue[ 2]->state;
cell[ Cell::numberDefined - 1]->code = stateCode[ cell[ Cell::numberDefined - 1]->stateCounter];

#line 94 "adhes.cpl"
}

#line 95 "adhes.cpl"
} // end _cellInitialize()

void Cell::setCodePointers()
//link the code function in each state to its correct code
{
  stateCode[ 0] = &_CPLdoNothing;
  stateCode[ 1] = &_CPLsplitUp;
  stateCode[ 2] = &_CPLmotion;
  stateCode[ 3] = &_CPLunnamedState_a;
}
