#ifndef HEADER_H
#define HEADER_H
#define _NEW_STREAMS
#include <math.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include "bool.h"
#include "hash_define.h"
#ifndef UNIT_CELLS
#undef SPACE_SAVER
#undef EIGHT_NEIGHBORHOOD
#else
#define SPACE_SAVER
#endif UNIT_CELLS

typedef int Int; // Use this for all short int declarations, later
		   // depending on performance we will decide whether to use
		   // "int", "short" or "char"; unsigned or signed
// with short the range is -16384 to +16384
typedef float Float; // The floating point representation we use
class Cell;
typedef void (Cell::*pmf)();
enum divideOptions {HORIZONTAL, VERTICAL, SHORTEST, ANY, PERPENDICULAR};
enum {Undefined = -9999};

extern void error(char* );
extern int randBetween( int low, int high);
extern int floatToInt(float );
extern void initializeTissue();
enum {MAX_INT= 0x7fff};
enum VARTYPE {INTEGER, FLOAT, VECTOR};
#define MAX_FLOAT 0x7fff

#ifdef  EIGHT_NEIGHBORHOOD
  const  NumberOfNeighbors = 8;
#else
  const int NumberOfNeighbors = 6;
#endif
#endif HEADER_H
