#############################################################################
##
#A  init.g                      GAP library                  Martin Schoenert
##
#A  @(#)$Id: init.g,v 3.34 1993/11/08 23:10:15 martin Rel $
##
#Y  Copyright 1990-1992,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file is read by  GAP  upon startup.  It displays the banner and then
##  defines all the functions in the library as autoreadable.  Note this file
##  is automatically generated by 'makeinit', you almost certainly should not
##  edit it.
##
#H  $Log: init.g,v $
#H  Revision 3.34  1993/11/08  23:10:15  martin
#H  added the irreducible solvable linear groups library
#H
#H  Revision 3.33  1993/10/19  18:38:13  martin
#H  improved 'ReplacedString' slightly
#H
#H  Revision 3.32  1993/10/18  13:30:12  martin
#H  improved 'VERSION' and 'ReplacedString'
#H
#H  Revision 3.31  1993/07/30  12:06:59  martin
#H  added 'IsomorphismTypeFiniteSimpleGroup' and 'DisplayCompositionSeries'
#H
#H  Revision 3.30  1993/07/30  09:26:29  martin
#H  added the functions for the Abelianized Reidemeister-Schreier method
#H
#H  Revision 3.29  1993/07/29  22:27:11  martin
#H  replaced "lattgrp" by "grplatt"
#H
#H  Revision 3.28  1993/07/29  21:32:18  martin
#H  removed "chevgrp" and "recsl", added "ratclass"
#H
#H  Revision 3.27  1993/07/26  10:50:21  martin
#H  added 'CharacterDegrees', 'RootsMod', and 'CharTableLibrary'
#H
#H  Revision 3.26  1993/07/26  10:14:38  martin
#H  move 'IsIdentical' to the kernel, added 'Agemo' etc.,
#H  added 'InterpolatedPolynomial', added 'GL' etc.
#H
#H  Revision 3.25  1993/03/25  22:04:12  martin
#H  'CharTable' for abelian groups, 'EuclideanQuotient' et.al.
#H
#H  Revision 3.24  1993/02/11  17:54:45  martin
#H  added 'UnionBlist' etc.
#H
#H  Revision 3.23  1993/02/10  15:18:24  martin
#H  changed 'ReadSys' to 'ReadPath', which returns status
#H
#H  Revision 3.22  1993/02/10  15:06:16  martin
#H  added the new names to the banner
#H
#H  Revision 3.21  1993/02/10  10:14:10  martin
#H  added "permcser", composition series for permutation groups
#H
#H  Revision 3.20  1993/02/04  11:24:28  martin
#H  changed because strings are now lists
#H
#H  Revision 3.19  1993/01/22  14:11:55  martin
#H  added the 3-groups library
#H
#H  Revision 3.18  1993/01/21  08:37:14  martin
#H  added matrix group library
#H
#H  Revision 3.17  1993/01/20  17:49:28  martin
#H  added the table of marks library
#H
#H  Revision 3.16  1993/01/18  19:03:49  martin
#H  added 'AgGroup' for permutation groups and character table computation
#H
#H  Revision 3.15  1992/09/10  10:46:52  martin
#H  added subgroup lattice printing functions
#H
#H  Revision 3.14  1992/08/12  13:30:46  sam
#H  added file 'ctgapmoc.g'
#H
#H  Revision 3.13  1992/08/11  11:02:03  sam
#H  added some functions dealing with library tables
#H
#H  Revision 3.12  1992/07/15  13:38:33  martin
#H  added packages "fpsgpres" and "fptietze"
#H
#H  Revision 3.11  1992/07/14  13:16:10  martin
#H  added package "permprod"
#H
#H  Revision 3.10  1992/06/27  08:07:28  martin
#H  moved 'OnTuples', 'OnSets', etc. into the kernel
#H
#H  Revision 3.9  1992/06/24  16:18:58  goetz
#H  new version of 'ctsymmet.g'.
#H
#H  Revision 3.8  1992/06/04  08:34:50  martin
#H  added "ctlattic", renamed "finpoly" to "polyfin" etc
#H
#H  Revision 3.7  1992/06/03  17:34:33  martin
#H  added "fldpoly", "ratpoly", "recsl", and "chevgrp"
#H
#H  Revision 3.6  1992/05/21  15:35:55  martin
#H  added 'NormedVector'
#H
#H  Revision 3.5  1992/05/08  16:29:43  martin
#H  added the packages for polynomials
#H
#H  Revision 3.4  1992/05/08  16:26:06  martin
#H  added 'VERSION'
#H
#H  Revision 3.3  1992/05/08  16:24:30  martin
#H  fixed 'ReplacedString' to replace the last occurence, not the first
#H
#H  Revision 3.2  1992/05/08  16:23:28  martin
#H  changed the banner to 'Version 3 Release 2'
#H
#H  Revision 3.1  1992/04/07  20:05:03  martin
#H  initial revision under RCS
#H
##
VERLIB := "v3r3p0 1993/11/09";
if not IsBound( VERSRC ) then  VERSRC := "unknown";  fi;
if not IsBound( VERSYS ) then  VERSYS := "unknwon";  fi;

VERSION := [];
Append( VERSION,   "lib: " );  Append( VERSION, VERLIB );
Append( VERSION, ", src: " );  Append( VERSION, VERSRC );
Append( VERSION, ", sys: " );  Append( VERSION, VERSYS );

if not QUIET and BANNER then
PR := function ( str )  Print("           ",str,"\n");  end;
PR("                                                                  ");
PR("      ########            Lehrstuhl D fuer Mathematik             ");
PR("    ###    ####           RWTH Aachen                             ");
PR("   ##         ##                                                  ");
PR("  ##          #             #######            #########          ");
PR(" ##                        #      ##          ## #     ##         ");
PR(" ##           #           #       ##             #      ##        ");
PR(" ####        ##           ##       #             #      ##        ");
PR("  #####     ###           ##      ##             ##    ##         ");
PR("    ######### #            #########             #######          ");
PR("              #                                  #                ");
PR("             ##           Version 3              #                ");
PR("            ###           Release 3              #                ");
PR("           ## #           09 Nov 93              #                ");
PR("          ##  #                                                   ");
PR("         ##   #  Alice Niemeyer, Werner Nickel,  Martin Schoenert ");
PR("        ##    #  Johannes Meier, Alex Wegner,    Thomas Bischops  ");
PR("       ##     #  Frank Celler,   Juergen Mnich,  Udo Polis        ");
PR("       ###   ##  Thomas Breuer,  Goetz Pfeiffer, Hans U. Besche   ");
PR("        ######   Volkmar Felsch, Heiko Theissen, Alexander Hulpke ");
PR("                 Ansgar Kaup,    Akos Seress                      ");
PR("                                                                  ");
PR("                 For help enter: ?<return>                        ");
fi;

ReadIndent := "";

if not IsBound( InfoRead1 )  then InfoRead1 := Ignore;  fi;
if not IsBound( InfoRead2 )  then InfoRead2 := Ignore;  fi;

ReplacedString := function ( string, old, new )
    local  res,  i,  k,  l;
    res := [];
    k := 1;
    l := false;
    for i  in [1..Length(string)]  do
        if string{[i..i+Length(old)-1]} = old  then
            l := i;
        fi;
        if string[i] = ';'  then
            if l <> false  then
                Append( res, string{[k..l-1]} );
                Append( res, new );
                Append( res, string{[l+Length(old)..i]} );
            else
                Append( res, string{[k..i]} );
            fi;
            k := i + 1;
            l := false;
        fi;
    od;
    if l <> false  then
        Append( res, string{[k..l-1]} );
        Append( res, new );
        Append( res, string{[l+Length(old)..Length(string)]} );
    else
        Append( res, string{[k..Length(string)]} );
    fi;
    return res;
end;

ReadPath := function ( path, name, ext, infomsg )
    local   readIndent, i, k, file, found;
    readIndent := Copy( ReadIndent );
    Append( ReadIndent, "  " );
    InfoRead1( "#I",ReadIndent,infomsg,"( \"", name, "\" )\n" );
    i := 1;
    found := false;
    while not found  and i <= Length(path)+1 do
        k := Position( path, ';', i-1 );
        if k = false  then k := Length(path)+1;  fi;
        file := path{[i..k-1]};  Append( file, name );  Append( file, ext );
        InfoRead2("#I  trying '",file,"'\n");
        found := READ( file );
        i := k + 1;
    od;
    ReadIndent := readIndent;
    if found and ReadIndent = ""  then
        InfoRead1( "#I  ",infomsg,"( \"", name, "\" ) done\n" );
    fi;
    return found;
end;

Read := function ( name )
    if not ReadPath( "", name, "", "Read" )  then
     Error("the file '",name,"' must exist and be readable");
    fi;
end;

ReadLib := function ( name )
    if not ReadPath( LIBNAME, name, ".g", "ReadLib" )  then
     Error("the library file '",name,"' must exist and be readable");
    fi;
end;

GRPNAME := ReplacedString( LIBNAME, "lib", "grp" );

ReadGrp := function ( name )
    if not ReadPath( GRPNAME, name, ".grp", "ReadGrp" )  then
     Error("the group library file '",name,"' must exist and be readable");
    fi;
end;

TWONAME := ReplacedString( LIBNAME, "lib", "two" );

ReadTwo := function ( name )
    if not ReadPath( TWONAME, name, ".grp", "ReadTwo" )  then
     Error("the 2-group library file '",name,"' must exist and be readable");
    fi;
end;

THRNAME := ReplacedString( LIBNAME, "lib", "thr" );

ReadThr := function ( name )
    if not ReadPath( THRNAME, name, ".grp", "ReadThr" )  then
     Error("the 3-group library file '",name,"' must exist and be readable");
    fi;
end;

TBLNAME := ReplacedString( LIBNAME, "lib", "tbl" );

ReadTbl := function ( name )
    if not ReadPath( TBLNAME, name, ".tbl", "ReadTbl" )  then
     Error("the character table file '",name,"' must exist and be readable");
    fi;
end;

TOMNAME := ReplacedString( LIBNAME, "lib", "tom" );

ReadTom := function ( name )
    if not ReadPath( TOMNAME, name, ".tom", "ReadTom" )  then
     Error("the table of marks file '",name,"' must exist and be readable");
    fi;
end;


AUTO( ReadLib( "abattoir" ),
  LengthString, SubString, ConcatenationString, ChiefSeries, FpGroup, Edit,
  ProductPol, ValuePol, MergedRecord, UnionBlist, IntersectionBlist,
  DifferenceBlist, SetPrintLevel, Save, SetPkgname, PKGNAME, LOADED_PACKAGES,
  ReadPkg, ExecPkg, LoadPackage, RequirePackage );

AUTO( ReadLib( "agcent" ),
  cs_ag_time, cs_ag_trivial_cnt, cs_ag_general_cnt, ec_ag_time,
  ec_ag_central_cnt, ec_ag_non_central_cnt, cen_ag_time, cen_ag_central_cnt,
  cen_ag_non_central_cnt, MainEntryCSAgGroup, CentralCaseCentAgGroup,
  GeneralCaseCentAgGroup, MainEntryCentAgGroup, CentralCaseECAgWords,
  GeneralCaseECAgWords, MainEntryECAgWords, MainEntryACAgWords );

AUTO( ReadLib( "agclass" ),
  ecs_ag_time, ecs_ag_centrality_cnt, ecs_ag_central_cnt,
  ecs_ag_non_central_cnt, ncs_ag_time, ncs_ag_central_cnt,
  ncs_ag_non_central_cnt, scs_ag_time, scs_ag_central_cnt,
  scs_ag_non_central_cnt, InHomSolutions, CommutatorGauss,
  CorrectedStabilizer, AffineOrbitsAgGroup, MinimalVectorAgOrbit,
  CentralCaseECSAgGroup, GeneralCaseECSAgGroup, MainEntryECSAgGroup,
  FusionsECSAgGroup, Fusions2ECSAgGroup, SubEntryNECSAgGroup,
  MainEntryNECSAgGroup, SubEntrySECSAgGroup, MainEntrySECSAgGroup,
  NumberConjugacyClasses, StructureConjugacyClasses, ConjugacyClassAgGroupOps );

AUTO( ReadLib( "agcomple" ),
  BaseSteinitz, AffineBlocksCO, NextCentralizerCO, NextCocyclesCO,
  NextCentralCO, NextNormalCO, NextComplementsCO, ComplementsCO,
  ComplementsCO2, Complementclasses, Complement );

AUTO( ReadLib( "agcoset" ),
  RightCosetAgGroupOps, LeftCosetAgGroupOps, AGDoubleCosets, FactorAgSubgroup,
  ElementVector, MainEntryCCEAgGroup, GenRelOrdersAgGroup );

AUTO( ReadLib( "agctbl" ),
  AgGroupClassMatrixColumn, IdentificationAgGroup, InitAgConjugacyTest );

AUTO( ReadLib( "aggroup" ),
  AgGroupOps, AgSubgroup, ChangeCollector, RefinedAgSeries, SiftedAgWord,
  Exponents, FactorArgOps, FactorArg, MinimalGeneratingSet, AgGroupPcp,
  MatGroupAgGroup, PermGroupAgGroup, AgGroupFpGroup, DirectProductAgGroupOps,
  SemidirectProductAgGroupOps, SemidirectMatProduct, CollectorlessFactorGroup,
  CanonicalAgWord7, CanonicalAgWord4, CanonicalAgWord5, CanonicalAgWord6a,
  CanonicalAgWord6b, CayleyInputAgGroup, GapInputAgGroup, SogosInputAgGroup,
  CGSInputAgGroup, MergeOperationsEntries );

AUTO( ReadLib( "aghall" ),
  GS_LIMIT, ConjugatingWordGS, ConjugatingWordCN, ComplementConjugatingAgWord,
  CoprimeComplement, HallEAS, HallComposition, HallSubgroup,
  HallConjugatingAgWord, SylowSystem, SylowComplements );

AUTO( ReadLib( "aghomomo" ),
  AbstractIgs, HomomorphicIgs, KernelHomomorphismAgGroupPermGroup,
  KernelHomomorphismAgGroupAgGroup, AgGroupHomomorphismOps,
  AgGroupHomomorphismByImagesOps, CompositionHomomorphismOps,
  CompositionFactorGroup, HomomorphismsSeries, IsomorphismAgGroup );

AUTO( ReadLib( "aginters" ),
  GS_SIZE, ExtendedIntersectionSumAgGroup, SumFactorizationFunctionAgGroup,
  GlasbyCover, GlasbyShift, GlasbyStabilizer, GlasbyIntersection,
  IntersectionSumAgGroup, SumAgGroup );

AUTO( ReadLib( "agnorm" ),
  NormalizeIgsMod, NormalizeIgsModLess, StabilizerOp1, StabilizerOp2,
  Stabilizer1NO, Stabilizer2NO, StabilizerNO, GlasbyNO, AbstractBaseMat,
  CoboundsNO, LinearNO, NormalizerNO );

AUTO( ReadLib( "agprops" ),
  IsAgGroup, IsElementAgSeries, IsConsistent, IsElementaryAbelianAgSeries,
  PiPowerSubgroupAgGroup, IsPNilpotent, FactorsAgGroup, MaximalElement,
  SmallGeneratingSetAgGroup );

AUTO( ReadLib( "agsubgrp" ),
  MergedIgs, MergedCgs, Igs, Cgs, IsNormalized, Normalized, Normalize,
  CopyAgGroup, PRump, CompositionSubgroup, MeltElementaryAbelianSeriesAgGroup,
  ElementaryAbelianSeriesThrough, RefinedSubnormalSeries, AgOrbitStabilizer,
  LinearOperation, AffineOperation );

AUTO( ReadLib( "agwords" ),
  WordList, LetterInt, AgWords, AgWordsOps, CanonicalAgWord, CentralWeight,
  CompositionLength, Depth, LeadingExponent, MappedAgWord, RelativeOrder,
  FactorGroupAgWord, FactorGroupAgWordOps );

AUTO( ReadLib( "cdaggrp" ),
  con_col_list, f2_orbit_priv, f2_orbits_priv, ls_orbit_priv, ls_orbits_priv,
  omega_1_priv, kernel_priv_ag_char, ProjectiveCharDegAgGroup, CharDegAgGroup,
  CharacterDegrees, char_sec_prev, char_sec, CharTableSSGroup );

AUTO( ReadLib( "combinat" ),
  Factorial, Binomial, Bell, Stirling1, Stirling2, CombinationsA,
  CombinationsK, Combinations, NrCombinationsK, NrCombinations, ArrangementsA,
  ArrangementsK, Arrangements, NrArrangementsA, NrArrangementsK,
  NrArrangements, UnorderedTuplesK, UnorderedTuples, NrUnorderedTuples,
  TuplesK, Tuples, NrTuples, PermutationsListK, PermutationsList,
  NrPermutationsList, DerangementsK, Derangements, NrDerangementsK,
  NrDerangements, Permanent2, Permanent, PartitionsSetA, PartitionsSetK,
  PartitionsSet, NrPartitionsSet, PartitionsA, PartitionsK, Partitions,
  NrPartitions, OrderedPartitionsA, OrderedPartitionsK, OrderedPartitions,
  NrOrderedPartitions, RestrictedPartitionsA, RestrictedPartitionsK,
  RestrictedPartitions, NrRestrictedPartitionsK, NrRestrictedPartitions,
  SignPartition, AssociatedPartition, PowerPartition, PartitionTuples, Lucas,
  Fibonacci, Bernoulli2, Bernoulli );

AUTO( ReadLib( "ctautoms" ),
  FamiliesOfRows, MatAutomorphismsFamily, MatAutomorphisms,
  TableAutomorphisms, TransformingPermutationFamily, TransformingPermutations,
  TransformingPermutationsCharTables );

AUTO( ReadLib( "ctbasic" ),
  IsCharTable, CharTableOps, BrauerTableOps, KernelChar, InitClassesCharTable,
  InverseClassesCharTable, PrintToCAS, TestCharTable, ClassNamesCharTable,
  CharTable, DisplayCharTable, ClassMultCoeffCharTable,
  ClassStructureCharTable, MatClassMultCoeffsCharTable, RealClassesCharTable,
  ClassOrbitCharTable, NrPolyhedralSubgroups, ClassRootsCharTable,
  SortCharactersCharTable, SortClassesCharTable, SortCharTable );

AUTO( ReadLib( "ctcharac" ),
  ScalarProduct, MatScalarProducts, InverseMatMod, PadicCoefficients,
  LinearIndependentColumns, DecompositionInt, IntegralizedMat, Decomposition,
  Tensored, Reduced, ReducedOrdinary, Symmetrisations, Symmetrizations,
  SymmetricParts, AntiSymmetricParts, MinusCharacter, RefinedSymmetrisations,
  OrthogonalComponents, SymplecticComponents, PrimeBlocks, Eigenvalues,
  IrreducibleDifferences );

AUTO( ReadLib( "ctfilter" ),
  StepModGauss, ModGauss, ContainedDecomposables, ContainedCharacters );

AUTO( ReadLib( "ctgapmoc" ),
  FieldInfo, Subfields, MAKElb11, StructureConstants, PowerInfo, ScanMOC,
  MOCChars, GAPChars, MOCTableOps, MOCTable, MOCTable0, MOCTableP, PrintToMOC );

AUTO( ReadLib( "ctgeneri" ),
  CharTableRegular, CharTableDirectProduct, CharTableFactorGroup,
  CharTableNormalSubgroup, CharTableSplitClasses, CharTableCollapsedClasses,
  CharTableIsoclinic, CharTableQuaternionic, GEN_Q_P, PrimeBase,
  CharTableSpecialized );

AUTO( ReadLib( "ctlattic" ),
  LLLReducedBasis, LLLReducedGramMat, LLL, ShortestVectors, Extract,
  Decreased, OrthogonalEmbeddings, OrthogonalEmbeddingsSpecialDimension,
  DnLattice, DnLatticeIterative );

AUTO( ReadLib( "ctmapcon" ),
  CharString, UpdateMap, NonnegIntScalarProducts, IntScalarProducts,
  ContainedSpecialVectors, ContainedPossibleCharacters,
  ContainedPossibleVirtualCharacters, InitFusion, CheckPermChar, ImproveMaps,
  CommutativeDiagram, CheckFixedPoints, TransferDiagram, TestConsistencyMaps,
  InitPowermap, Congruences, ConsiderKernels, ConsiderSmallerPowermaps,
  PowermapsAllowedBySymmetrisations, Powermap, ConsiderTableAutomorphisms,
  OrbitFusions, OrbitPowermaps, RepresentativesFusions,
  RepresentativesPowermaps, FusionsAllowedByRestrictions, SubgroupFusions );

AUTO( ReadLib( "ctmapusi" ),
  InverseMap, CompositionMaps, ProjectionMap, Indeterminateness,
  PrintAmbiguity, Parametrized, ContainedMaps, Indirected, GetFusionMap,
  StoreFusion, ElementOrdersPowermap, Restricted, Inflated, Induced,
  CollapsedMat, Powmap, InducedCyclic, Power, Indicator );

AUTO( ReadLib( "ctpermch" ),
  SubClass, TestPerm1, TestPerm2, TestPerm3, Inequalities, Permut, PermBounds,
  PermComb, PermCandidates, PermCandidatesFaithful, PermChars, PermCharInfo );

AUTO( ReadLib( "ctpgrp" ),
  RepresentationsPGroup, MatRepresentationsPGroup, CharTablePGroup,
  FusionConjugacyClasses, SupersolvableResiduumAgGroup, SupersolvableResiduum );

AUTO( ReadLib( "ctsymmet" ),
  BetaSet, CentralizerWreath, PowerWreath, InductionScheme,
  MatCharsWreathSymmetric, CharValueSymmetric, CharTableSymmetric,
  CharTableAlternating, CharValueWeylB, CharTableWeylB, CharTableWeylD,
  CharValueWreathSymmetric, CharTableWreathSymmetric );

AUTO( ReadLib( "cyclotom" ),
  IntCyc, RoundCyc, CoeffsCyc, CycList, Atlas1, EB, EC, ED, EE, EF, EG, EH,
  NK, Atlas2, EY, EX, EW, EV, EU, ET, ES, EM, EL, EK, EJ, ER, EI, StarCyc,
  Quadratic, GeneratorsPrimeResidues, GaloisMat, RationalizedMat );

AUTO( ReadLib( "domain" ),
  IsDomain, Domain, DomainOps, Elements, IsFinite, Size, IsSubset,
  Intersection, IntersectionSet, Union, UnionSet, CartesianProduct,
  Difference, Representative, Random, DefineName );

AUTO( ReadLib( "field" ),
  IsField, FieldOps, GaloisGroup, Conjugates, Norm, Trace, CharPol, MinPol,
  FieldElementsOps, FieldElements, Field, DefaultField, IsFieldHomomorphism,
  KernelFieldHomomorphism, FieldHomomorphismOps,
  CompositionFieldHomomorphismOps, IdentityFieldHomomorphismOps );

AUTO( ReadLib( "finfield" ),
  IsFiniteField, FiniteFieldOps, OrderFFE, IntFFE, GF, FiniteField,
  GaloisField, FiniteFieldElementsOps, FiniteFieldElements, IsBaseFF,
  IsFrobeniusAutomorphism, FrobeniusAutomorphism, FrobeniusAutomorphismI,
  FrobeniusAutomorphismOps );

AUTO( ReadLib( "fpgrp" ),
  FreeGroup, Words, WordsOps, IsFpGroup, FpGroupOps, CyclicPermutationsWords,
  RelatorRepresentatives, RelsSortedByStartGen, CosetTableFpGroup,
  MostFrequentGeneratorFpGroup, GeneratorsCosetTable, OperationCosetsFpGroup,
  FpGroupHomomorphismByImagesOps, LowIndexSubgroupsFpGroup );

AUTO( ReadLib( "fpsgpres" ),
  PresentationSubgroupMtc, AugmentedCosetTableMtc, PresentationSubgroupRrs,
  PresentationSubgroup, PresentationNormalClosureRrs,
  PresentationNormalClosure, AugmentedCosetTableRrs, SpanningTree,
  RenumberTree, RewriteSubgroupRelators, PresentationAugmentedCosetTable,
  AbelianInvariantsSubgroupFpGroupMtc, RelatorMatrixAbelianizedSubgroupMtc,
  AbelianInvariantsSubgroupFpGroupRrs, AbelianInvariantsSubgroupFpGroup,
  RelatorMatrixAbelianizedSubgroupRrs, RelatorMatrixAbelianizedSubgroup,
  AbelianInvariantsNormalClosureFpGroupRrs,
  AbelianInvariantsNormalClosureFpGroup,
  RelatorMatrixAbelianizedNormalClosureRrs,
  RelatorMatrixAbelianizedNormalClosure, RewriteAbelianizedSubgroupRelators,
  CanonicalRelator, ReducedRrsWord );

AUTO( ReadLib( "fptietze" ),
  TZ_NUMGENS, TZ_NUMRELS, TZ_TOTAL, TZ_GENERATORS, TZ_INVERSES, TZ_RELATORS,
  TZ_LENGTHS, TZ_FLAGS, TZ_MODIFIED, TZ_NUMREDUNDS, TZ_STATUS,
  TZ_LENGTHTIETZE, TR_TREELENGTH, TR_PRIMARY, TR_TREENUMS, TR_TREEPOINTERS,
  TR_TREELAST, PresentationOps, AddGenerator, AddRelator, DecodeTree,
  FpGroupPresentation, PresentationFpGroup, RemoveRelator, SimplifiedFpGroup,
  TzCheckRecord, TzEliminate, TzEliminateFromTree, TzEliminateGen,
  TzEliminateGen1, TzEliminateGens, TzFindCyclicJoins, TzGeneratorExponents,
  TzGo, SimplifyPresentation, TzGoGo, TzHandleLength1Or2Relators,
  TzMostFrequentPairs, TzNewGenerator, TzPrint, TzPrintGenerators,
  TzPrintLengths, TzOptionNames, TzRecordOps, TzPrintOptions, TzPrintPairs,
  TzPrintPresentation, TzPrintRelators, TzPrintStatus, TzRecoverFromFile,
  TzRemoveGenerators, TzSearch, TzSearchEqual, TzSort, TzSubstitute,
  TzSubstituteCyclicJoins );

AUTO( ReadLib( "gaussian" ),
  IsGaussInt, GaussianIntegersOps, GaussianIntegers, TwoSquares,
  GaussianIntegersAsAdditiveGroupOps, IsGaussRat, GaussianRationalsOps,
  GaussianRationals, GaussianRationalsAsRingOps );

AUTO( ReadLib( "group" ),
  GroupString, GroupOps, Group, AsGroup, IsGroup, IsParent, Parent,
  MaintainedGroupInfo, Subgroup, AsSubgroup, Centralizer, Centre, Closure,
  CommutatorFactorGroup, CommutatorSubgroup, Core, DerivedSubgroup,
  FittingSubgroup, FrattiniSubgroup, NormalClosure, NormalIntersection,
  Normalizer, PCore, Radical, SylowSubgroup, TrivialSubgroup, DerivedSeries,
  ElementaryAbelianSeries, CompositionSeries, DisplayCompositionSeries,
  LowerCentralSeries, PCentralSeries, SubnormalSeries, UpperCentralSeries,
  IsAbelian, IsCentral, IsConjugate, IsCyclic, IsElementaryAbelian,
  IsNilpotent, IsNormal, IsPerfect, IsSimple, IsSolvable, IsSubgroup,
  IsSubnormal, IsTrivial, AbelianInvariants, Exponent, Index,
  SmallestGenerators, Agemo, AgemoAbove, JenningsSeries,
  DimensionsLoewyFactors, IsomorphismTypeFiniteSimpleGroup, IsConjugacyClass,
  ConjugacyClassGroupOps, ConjugacyClass, ConjugacyClasses, IsRationalClass,
  RationalClassGroupOps, RationalClass, RationalClasses, ConjugateSubgroup,
  ConjugateSubgroups, AbstractElementsGroup, Factorization, AgGroup,
  PermGroup );

AUTO( ReadLib( "grpcoset" ),
  Transversal, RightTransversal, LeftTransversal, IsRightCoset, IsCoset,
  RightCoset, Coset, RightCosetGroupOps, RightCosets, Cosets, IsLeftCoset,
  LeftCoset, LeftCosetGroupOps, LeftCosets, IsDoubleCoset, DoubleCoset,
  DoubleCosetGroupOps, DoubleCosets, CalcDoubleCosets, AscendingChain,
  RefinedChain, Extension, CanonicalRightTransversal, CanonicalCosetElement,
  OnCanonicalCosetElements, PermutationCharacter, IsFactorGroupElement,
  FactorGroupElement, FactorGroupElementOps, FactorGroupElements,
  FactorGroupElementsOps, FactorGroup, NaturalHomomorphism,
  NaturalHomomorphismOps, FactorGroupOps );

AUTO( ReadLib( "grpctbl" ),
  USECTPGROUP, IsLargeGroup, CharTableDixonSchneider, DixonRecord,
  DixonRecordOps, DixonInit, RegisterNewCharacter, DixontinI, SortDixonRecord,
  DixonSplit, OrbitSplit, CombinatoricSplit, SplitCharacters,
  IncludeIrreducibles, DxLinearCharacters, ClassComparison, DxCalcPowerMap,
  DxPowerClass, SplitStep, SplitTwoSpace, DxLiftCharacter,
  GeneratePrimeCyclotomic, ModProduct, ModularCharacterDegree,
  DegreeCandidates, FrobSchurInd, BestSplittingMatrix, SplitDegree,
  CharacterMorphismGroup, AsCharacterMorphismFunction,
  CharacterMorphismOrbits, GaloisOrbits, RootsOfPol, ModRoots,
  ModularValuePol, BMminpol, KrylovSequence, Eigenbase, ActiveCols, PadicInt,
  ClassElementLargeGroup, ClassElementSmallGroup, DoubleCentralizerOrbit,
  StandardClassMatrixColumn, IdentificationGenericGroup, DxAbelianPreparation,
  AbelianNormalSubgroups );

AUTO( ReadLib( "grpelms" ),
  IsGroupElement, GroupElements, GroupElementsOps, GroupElementOps, Order,
  LeftNormedComm );

AUTO( ReadLib( "grphomom" ),
  IsGroupHomomorphism, KernelGroupHomomorphism, GroupHomomorphismOps,
  CompositionGroupHomomorphismOps, IdentityGroupHomomorphismOps,
  ConjugationGroupHomomorphism, ConjugationGroupHomomorphismOps,
  InnerAutomorphism, GroupHomomorphismByImages, GroupHomomorphismByImagesOps );

AUTO( ReadLib( "grplatt" ),
  IsConjugacyClassSubgroups, ConjugacyClassSubgroups,
  ConjugacyClassSubgroupsGroupOps, ConjugacyClassesSubgroups, Lattice,
  LatticeSubgroups, LatticeSubgroupsOps, PrintClassSubgroupLattice,
  ConjugacyClassesPerfectSubgroups, RepresentativesPerfectSubgroups,
  IsomorphismPerfectGroupHelp, IsomorphismPerfectGroup, NormalSubgroups );

AUTO( ReadLib( "grpprods" ),
  IsDirectProductElement, DirectProductElement, DirectProductElementOps,
  IsDirectProduct, DirectProduct, DirectProductOps, EmbeddingDirectProductOps,
  ProjectionDirectProductOps, SubdirectProduct, SubdirectProductOps,
  IsSemidirectProductElement, SemidirectProductElement,
  SemidirectProductElementOps, IsSemidirectProduct, SemidirectProduct,
  SemidirectProductOps, EmbeddingSemidirectProductOps,
  ProjectionSemidirectProductOps, IsWreathProductElement,
  WreathProductElement, WreathProductElementOps, IsWreathProduct,
  WreathProduct, WreathProductOps );

AUTO( ReadLib( "integer" ),
  IntegersOps, Integers, NrBitsInt, Primes, Primes2, TraceModQF, IsPrimeInt,
  IsPrimePowerInt, NextPrimeInt, PrevPrimeInt, FactorsRho, FactorsInt,
  DivisorsSmall, DivisorsInt, Sigma, Tau, MoebiusMu, PowerModInt, LcmInt,
  Gcdex, Int, AbsInt, SignInt, ChineseRem, LogInt, RootInt, SmallestRootInt,
  IntegersAsAdditiveGroupOps );

AUTO( ReadLib( "lattperf" ),
  PerfectGroupsCatalogue );

AUTO( ReadLib( "list" ),
  List, Apply, Concatenation, Flat, Reversed, Sublist, Filtered, Number,
  Collected, Equivalenceclasses, ForAll, ForAny, First, PositionProperty,
  Cartesian2, Cartesian, Sort, SortParallel, Sortex, Permuted, PositionSorted,
  Product, Sum, Iterated, Maximum, Minimum, R_N, RandomList, RandomSeed );

AUTO( ReadLib( "mapping" ),
  IsGeneralMapping, IsMapping, IsInjective, IsSurjective, IsBijection,
  IsBijective, IsHomomorphism, IsMonomorphism, IsEpimorphism, IsIsomorphism,
  IsEndomorphism, IsAutomorphism, Image, Images, ImagesRepresentative,
  PreImage, PreImages, PreImagesRepresentative, CompositionMapping,
  IdentityMapping, InverseMapping, PowerMapping, Kernel, MappingOps,
  CompositionMappingOps, InverseMappingOps, MappingByFunction,
  MappingByFunctionOps, Embedding, Projection, Mappings, MappingsOps );

AUTO( ReadLib( "matgrp" ),
  IsMatGroup, MatGroupOps, RightCosetMatGroupOps, MatGroup, RandomMatGroup,
  Transposed, InvariantSubspace, IsInvariantSubspace, IrreducibilityTest,
  AbsoluteIrreducibilityTest, CompositionFactors, EquivalenceTest,
  AddNextMatrixFunction, NextMatrix, SmallCorankMatrixRecord,
  RandomMatrixRecord, Fingerprint, ClassicNextMatrix,
  ExtendedClassicNextMatrix, NextMatrix1, NextMatrix2, NextMatrix3 );

AUTO( ReadLib( "matring" ),
  IsMatrixRing, MatrixRingOps );

AUTO( ReadLib( "matrix" ),
  MatricesOps, Matrices, DimensionsMat, IdentityMat, NullMat, RandomMat,
  RandomInvertableMat, RandomUnimodularMat, TransposedMat, KroneckerProduct,
  OrderMatLimit, OrderMat, TraceMat, RankMat, DeterminantMat, TriangulizeMat,
  BaseMat, NullspaceMat, DiagonalizeMat, ElementaryDivisorsMat, SolutionMat,
  FieldMatrices, FieldMatricesOps, MinimalPolynomial,
  CharacteristicPolynomial, FiniteFieldMatrices, FiniteFieldMatricesOps );

AUTO( ReadLib( "module" ),
  ModuleOps, Module, IsModule );

AUTO( ReadLib( "numfield" ),
  IsNumberField, IsCyclotomicField, NumberFieldOps, IsNFAutomorphism,
  NFAutomorphism, NFAutomorphismOps, OrderCyc, NormalBaseNumberField,
  ZumbroichBase, LenstraBase, NF, NumberField, CyclotomicFieldOps, CF,
  CyclotomicField, NumberRingOps, NumberRing, CyclotomicRing, CyclotomicsOps,
  Cyclotomics );

AUTO( ReadLib( "numtheor" ),
  PrimeResiduesSmall, PrimeResidues, Phi, Lambda, OrderMod,
  IsPrimitiveRootMod, PrimitiveRootMod, Jacobi, Legendre, RootModPrime,
  RootModPrimePower, RootMod, RootsModPrime, RootsModPrimePower, RootsMod,
  RootsUnity1ModPrime, RootsUnity1ModPrimePower, RootsUnity1Mod, LogMod,
  IsResidueClass, ResidueClass, ResidueClassOps, ResidueClasses,
  ResidueClassesOps, ResidueClassGroupOps, PrimeResidueClassGroup );

AUTO( ReadLib( "onecohom" ),
  OCAgGroupOps, OCPermGroupOps, OneCoboundariesOC, ConjugatingWordOC,
  EquationMatrixOC, SmallEquationMatrixOC, EquationVectorOC,
  SmallEquationVectorOC, OneCocyclesOC, OneCoboundaries, OneCocycles,
  PPrimeSetsOC );

AUTO( ReadLib( "operatio" ),
  OnRightCosets, OnLeftCosets, OnLines, Cycle, CycleLength, Cycles,
  CycleLengths, Permutation, IsFixpoint, IsFixpointFree, DegreeOperation,
  IsTransitive, Transitivity, IsRegular, IsSemiRegular, Orbit, OrbitLength,
  Orbits, OrbitLengths, Operation, OperationHomomorphism,
  OperationHomomorphismOps, Blocks, MaximalBlocks, IsPrimitive, Stabilizer,
  RepresentativeOperation, RepresentativesOperation, IsEquivalentOperation );

AUTO( ReadLib( "permag" ),
  MaximalBlocksPGroup, OrderFactorGroupElement, InsertStabChain,
  ClosureNormalizingElementPermGroup, ExtendElementaryAbelianSeriesPermGroup,
  BaseStrongSubnormalGeneratingSetPPermGroup, ExponentsPermSolvablePermGroup,
  PcPresentationPermGroup, CompositionSeriesSolvablePermGroup,
  SubnormalSeriesPPermGroup, CentralCompositionSeriesPPermGroup );

AUTO( ReadLib( "permcose" ),
  RightCosetPermGroupOps, PermRefinedChain, MainEntryCCEPermGroup );

AUTO( ReadLib( "permcser" ),
  CompositionSeriesPermGroup, NonPerfectCSPG, PerfectCSPG, CasesCSPG,
  FindNormalCSPG, NinKernelCSPG, RegularNinKernelCSPG, NormalizerStabCSPG,
  TransStabCSPG, PullbackKernelCSPG, PullbackCSPG, CosetRepAsWord,
  ImageInWord, SiftAsWord, InverseAsWord, RandomElmAsWord,
  CentralizerNormalCSPG, CentralizerNormalTransCSPG, CentralizerTransSymmCSPG,
  IntersectionNormalClosurePermGroup, ActionAbelianCSPG, ImageOnAbelianCSPG );

AUTO( ReadLib( "permctbl" ),
  IdentificationPermGroup, RationalIdentificationPermGroup, FingerprintPerm );

AUTO( ReadLib( "permgrp" ),
  IsPermGroup, PermGroupOps, SC_level, ReduceStabChain, ExtendStabChain,
  MakeStabChain, MakeStabChainStrongGenerators, MakeStabChainRandom,
  ListStabChain, ConjugacyClassPermGroupOps );

AUTO( ReadLib( "permhomo" ),
  PermGroupHomomorphismByImagesOps, TransConstHomomorphismOps,
  BlocksHomomorphismOps );

AUTO( ReadLib( "permnorm" ),
  SortedOrbitsButler, SortedOrbitsPermGroup, BaseForNormalizerPermGroup,
  SigmaSets );

AUTO( ReadLib( "permprod" ),
  DirectProductPermGroupOps, EmbeddingDirectProductPermGroupOps,
  ProjectionDirectProductPermGroupOps );

AUTO( ReadLib( "permutat" ),
  PermutationsOps, Permutations, CycleStructurePerm, SmallestMovedPointPerm,
  ListPerm, MappingPermListList, RestrictedPerm );

AUTO( ReadLib( "polyfin" ),
  FiniteFieldPolynomialRingOps, FiniteFieldLaurentPolynomials,
  FiniteFieldLaurentPolynomialsOps, FiniteFieldPolynomials,
  FiniteFieldPolynomialsOps, FiniteFieldPolynomialOps, PrimePowersInt,
  ProductPP, LcmPP, OrderKnownDividendList, OKDInd );

AUTO( ReadLib( "polyfld" ),
  FieldPolynomialRingOps, FieldLaurentPolynomialRingOps );

AUTO( ReadLib( "polynom" ),
  Polynomial, IsPolynomial, CompanionMatrix, EmbeddedPolynomial, RandomPol,
  Value, Indeterminate, X, InterpolatedPolynomial, LaurentPolynomialRing,
  IsLaurentPolynomialRing, LaurentPolynomialRingOps, Derivative,
  PolynomialRing, IsPolynomialRing, PolynomialRingOps, LaurentPolynomials,
  LaurentPolynomialsOps, Polynomials, PolynomialsOps, PolynomialOps, Degree,
  LeadingCoefficient, DisplayPolynomial );

AUTO( ReadLib( "polyrat" ),
  RationalsPolynomialOps, RationalsPolynomials, RationalsPolynomialsOps,
  LandauMignotteBoundGcd, LandauMignotteBound, TryCombinations );

AUTO( ReadLib( "pq" ),
  PQpOps, PQp, SavePQp, InitPQp, AddGeneratorsPQp, DefineGeneratorsPQp,
  TailsPQp, EchelonizePQp, ConsistencyPQp, ElimTailsPQp, LiftHomomorphismPQp,
  CleanUpPQp, FirstClassPQp, PQuotient, pQuotient, PrimeQuotient,
  NextClassPQp, Weight );

AUTO( ReadLib( "ratclass" ),
  InjectionPrimeResidues, GroupsPrimeResidues, AgGroupPrimeResiduesOps,
  GroupPrimeResidues, ResidueAgWord, AgWordResidue,
  AgOrbitTransversalStabilizer, RationalClassPermGroupOps,
  RepresentativeRatConjElmsCoset, CompleteGaloisGroupPElement,
  OrbitsVectorSpace, ConstructList, SubspaceVectorSpaceAgGroup,
  PreImageProjectionSubspace, CentralStepConjugatingElement,
  CentralStepRationalClasses2Group, CentralStepIdentifyRationalClasses2Group,
  CentralStepRationalClassesPGroup, CentralStepIdentifyRationalClassesPGroup,
  SortRationalClasses, RationalClassesPAgGroup,
  RationalClassesElementaryAbelianSubgroup, FusionRationalClassesPSubgroup,
  RationalClassesAgGroup, RationalClassesPermGroup, RationalClassesPElements );

AUTO( ReadLib( "rational" ),
  RationalsOps, Rationals, RationalsAsRingOps );

AUTO( ReadLib( "ring" ),
  IsRing, RingOps, IsCommutativeRing, IsIntegralRing,
  IsUniqueFactorizationRing, IsEuclideanRing, Quotient, IsUnit, Units,
  IsAssociated, StandardAssociate, Associates, IsIrreducible, IsPrime,
  Factors, EuclideanDegree, EuclideanRemainder, EuclideanQuotient,
  QuotientRemainder, Mod, QuotientMod, PowerMod, Gcd, GcdRepresentation, Lcm,
  RingElementsOps, RingElements, Ring, DefaultRing, AsRing );

AUTO( ReadLib( "rowmodul" ),
  RowModuleOps, RowModule, IsRowModule, Submodule, Representation,
  ProperSubmodule );

AUTO( ReadLib( "rowspace" ),
  IntegerTable, RowSpace, IsRowSpace, RowSpaceOps, BaseTypeRowSpace,
  SiftedVector, ModspaceOps );

AUTO( ReadLib( "string" ),
  StringInt, StringRat, StringCyc, StringFFE, StringPerm, StringAgWord,
  StringBool, StringList, StringRec, String, PrintArray, PrintRecIgnore,
  PrintRecIndent, RecordOps, PrintRec, DaysInYear, DaysInMonth, DMYDay,
  DayDMY, NameWeekDay, WeekDay, NameMonth, StringDate, HMSMSec, SecHMSM,
  StringTime, StringPP, Ordinal );

AUTO( ReadLib( "tom" ),
  IsTom, TableOfMarks, Marks, NrSubs, WeightsTom, TomMat, MatTom,
  DecomposedFixedPointVector, TestRow, TestTom, DisplayTom, NormalizerTom,
  IntersectionsTom, IsCyclicTom, PermCharsTom, FusionCharTableTom, MoebiusTom,
  CyclicExtensionsTom, IdempotentsTom, ClassTypesTom, ClassNamesTom,
  TomCyclic, TomDihedral, TomFrobenius );

AUTO( ReadLib( "vecspace" ),
  VectorSpace, IsVectorSpace, VectorSpaceOps, IsSubspace, Base, AddBase,
  Dimension, Information, Coefficients, LinearCombination, Enumeration,
  LineEnumeration, NormedVector, STMappingOps, STMapping );

AUTO( ReadGrp( "basic" ),
  CyclicGroup, AbelianGroup, ElementaryAbelianGroup, DihedralGroup,
  PolyhedralGroup, AlternatingGroup, SymmetricGroup, GeneralLinearGroup,
  SpecialLinearGroup, SymplecticGroup, GeneralUnitaryGroup,
  SpecialUnitaryGroup, GL, SL, GU, SU, SP, ExtraspecialGroup );

AUTO( ReadGrp( "irredsol" ),
  IrredSolJSGens, IrredSolGroupList, IrreducibleSolvableGroup,
  IsLinearlyPrimitive, MinimalBlockDimension, AllIrreducibleSolvableGroups,
  OneIrreducibleSolvableGroup, PrimitivePermGroupIrreducibleMatGroup );

AUTO( ReadGrp( "matgrp" ),
  MatGroupLib, SpecialLinearMatGroup, GeneralLinearMatGroup,
  SymplecticMatGroup, GeneralUnitaryMatGroup, SpecialUnitaryMatGroup );

AUTO( ReadGrp( "permgrp" ),
  PermGroupLib, CyclicPermGroup, AbelianPermGroup, ElementaryAbelianPermGroup,
  DihedralPermGroup, PolyhedralPermGroup, AlternatingPermGroup,
  AlternatingPermGroupOps, SymmetricPermGroup, SymmetricPermGroupOps );

AUTO( ReadGrp( "primitiv" ),
  PGGens, FAC, PGTable, PG, PrimitiveGroup, AllPrimitiveGroups,
  OnePrimitiveGroup );

AUTO( ReadGrp( "solvable" ),
  AGTable, AGGroup, SolvableGroup, IsNontrivialDirectProduct,
  AllSolvableGroups, OneSolvableGroup );

AUTO( ReadTwo( "twogp" ),
  TGParts, TGLoad, TGGroup, TwoGroup, Rank, pClass, AllTwoGroups, OneTwoGroup );

AUTO( ReadThr( "thrgp" ),
  ThGParts, ThGLoad, ThGGroup, ThreeGroup, AllThreeGroups, OneThreeGroup );

AUTO( ReadTbl( "ctprimar" ),
  GALOIS, TENSOR, MBT, EvalChars, LowercaseString, FirstNameCharTable,
  FileNameCharTable, PrintText, BlanklessPrint, ShrinkChars, PrintToLib,
  ConstructMixed, ConstructProj, BrauerTree, DecMat, BasicSetBrauerTree,
  AddDecMats, PartsBrauerTableName, BrauerTable, CharTableLibrary, OfThose,
  Simple, SporadicSimple, SchurMultiplier, AllCharTableNames, NotifyCharTable,
  NotifyCharTableName, MakeLIBLIST );

AUTO( ReadTom( "tmprimar" ),
  TOM, TOMLIST, TomLibrary );

