/******************************************************************************
  anf_ideal_2_normal_assure.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "anf.h"

t_void
anf_ideal_2_normal_assure WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
             
	Tries to find a 2-Element-Normal-Presentation of the integer
	ideal id if not given yet.
	Be careful! If the first generator of id is not a prime
	integer, maybe you will not find any Normal Presentation
	by using this method!
  
Calling sequence:
 
        anf_ideal_2_normal_assure(ord, id);
 
        order   	ord:        order over which id is defined
        anf_ideal       id:	    integer ideal to be in 2-Element-
				    Normal-Presentation
 
History:

	92-06-26 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	integer_big	a;
	anf_elt		alpha, gen2, hlp;
	anf_ideal	id1;
	vector		loop_vec, temp;
	order		Z;
	integer_small	i, go, bound;
 
	order_must_be_over_z(ord);

	anf_ideal_2_assure( ord, id );

	if( !anf_ideal_2_normal_check( ord, id ) )
	{

/******* If we have no 2-Element-Normal-Presentation we try to   *******/
/******* find one by using a probabilistic method :              *******/
/******* for the algebraic numbers                               *******/
/*******        beta := b(1)*w(1) + ... + b(n)*w(n)              *******/
/******* ( 1-a <= b(i) <= a-1;   w(1), ..., w(n) order basis;    *******/
/*******   with a = first generator of id (must be positive!) )  *******/
/******* we test if the presentation ( a , alpha + a*beta ) of   *******/
/******* id is normal (alpha = second generator of id).          *******/

		a = anf_ideal_gen1(id);
		alpha = anf_ideal_gen2(id);
		go = 1;
		Z = m_z_str_incref(structure_z);
		bound = integer_min( a, 50 ) - 1;
		id1 = anf_ideal_2_create( ord, a, a );
		loop_vec = vector_index_init( order_abs_degree( ord ), -bound);
		for( i= -1; (vector_index_inc( loop_vec, -bound, bound ))&&(go); i++ )
		{            

/******* This algorithm could be implemented also by adding 'a'  *******/
/******* -- instead of multiplying a vector and adding an alge-  *******/
/******* braic number -- every time. But this would require      *******/
/******* various bounds for the vector entries. In practice we   *******/
/******* either find solutions very soon or we will not find any *******/
/******* (see comment in header documentation). So we decided to *******/
/******* use this simple way.                                    *******/

			temp = mat_z_scalar_mult( Z, loop_vec, a );
			hlp = vec_to_anf_elt( ord, temp );
     			anf_elt_delete( ord, &anf_ideal_gen2( id1 ) );
			anf_ideal_gen2( id1 ) = anf_add( ord, alpha, hlp );
			if( anf_ideal_2_normal_check( ord, id1 ))
			{             
				anf_elt_delete( ord, &alpha );
			        anf_ideal_gen2( id ) = anf_elt_incref( anf_ideal_gen2( id1) );
				integer_delref( anf_ideal_gen_g( id ));
				anf_ideal_gen_g( id ) = integer_incref( a );
				go = 0;
			}
			vec_delete( Z, &temp );
     			anf_elt_delete( ord, &hlp );
		}
		if( anf_print_level > 5 )
			printf("\nnumber of false trials in anf_ideal_2_normal_assure: %d",i);
		anf_ideal_delete( ord, &id1 );
		vec_delete( Z, &loop_vec );
		ring_delete( &Z );
		if(go)
			error_internal
			("anf_ideal_2_normal_assure: No 2-Element-Normal-Presentation found.");
	}
	return;
}
