#include "kant.h"
#include "integer.e"
#include "mat.h"
#include "anf.h"

/*
 
This file contains:
 
anf_ideal_mult           (generic)
anf_ideal_2_mult         
anf_ideal_z_mult         
 
*/
 
 
 

anf_ideal
anf_ideal_mult WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2

)
/*******************************************************************************
 
anf_ideal_mult.c
 
JS September 1991
Last modification: 02.10.91
 
Multiplies two ideals
 
This routine multplies id1 and id2. If possible, the multiplication
is done via 2-element presentation. If the presentations are not compatible
or if they are not given, the multiplication is done via Z-basis
presentation. If this has not been computed yet, it is done automatically.
 
*******************************************************************************/
{
	block_declarations;
 
	integer_big	g1, g2;

	g1 = anf_ideal_gen_g(id1);
	g2 = anf_ideal_gen_g(id2);
                                                       
/*
    Can we use 2-element presentations?
*/
	if(g1 > 1 && !integer_compare(g1,g2))
		return anf_ideal_2_mult(ord, id1, id2);
 
/*
    If not, are there Z-basis presentations?
*/
 	if(!anf_ideal_is_z(id1)) anf_ideal_2_z(ord, id1);
 	if(!anf_ideal_is_z(id2)) anf_ideal_2_z(ord, id2);
 
/*
   Now multiplication via Z-bases
*/
	return anf_ideal_z_mult(ord, id1, id2);
 
}
   
 

anf_ideal
anf_ideal_2_mult WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2

)
/*******************************************************************************
 
anf_ideal_2_mult.c
 
JS September 1991                                               Version 24.09.91
 
Multiplies two ideals given in 2-element presentation 
 
The multiplication is done componentwise without any check whether the
presentations are compatible. The calling routine has to care for that.
This routine can be used for example for computing successive powers
of an ideal in 2-element-presentation. In this case the power of the
ideal is given simply by computing the powers of the two generators.
 
If the g-values of id1 and id2 coincide the g-value of the result is set
to the same value, in the other case to 1.
 
*******************************************************************************/
{
	block_declarations;
 
	anf_ideal	id;
	integer_big	g1, g2;

	g1 = anf_ideal_gen_g(id1);
	g2 = anf_ideal_gen_g(id2);

	id = anf_ideal_alloc();
 
	anf_ideal_gen1(id) = anf_mult(ord, anf_ideal_gen1(id1), 
					   anf_ideal_gen1(id2));
 
	anf_ideal_gen2(id) = anf_mult(ord, anf_ideal_gen2(id1), 
					   anf_ideal_gen2(id2));
 
	anf_ideal_gen_g(id) = (integer_compare(g1, g2))  ?  1  :  g1;
 
	return id;
}
 
 
 
 

anf_ideal
anf_ideal_z_mult WITH_3_ARGS(
	order,		ord,
	anf_ideal,	id1,
	anf_ideal,	id2

)
/*******************************************************************************
 
anf_ideal_z_mult.c
 
JS September 1991                                               Version 25.09.91
 
Multiplies two ideals given in Z-element presentation 
 
This routine multiplies the elements of the Z-basis of
id1 by those of id2. This is done via successive matrix multiplication
and Hermite reduction:
We multiply all representation matrices of the basis elements of id1
by the transformation matrix of id2. The resulting (n,n*n)-Matrix then is
being successively HNF-reduced.
   
*******************************************************************************/
{
	block_declarations;
 
	anf_ideal	id;
	order		ordcoef;
	t_handle		z;
	integer_small	deg, twodeg, deg1;
	matrix		trans1, trans2, matr, mat0, mat1, mat2, hnf;
	anf_elt		alpha;
	integer_small	i;
  
	order_must_be_over_z(ord);
 
	deg = order_rel_degree(ord);
	twodeg = deg+deg;
	deg1   = deg+1;
        ordcoef = order_coef_order(ord);
 
	trans1 = anf_ideal_tran(id1);
	trans2 = anf_ideal_tran(id2);
 
	id = anf_ideal_alloc();
 
/*
    hnf contains the actual transformation matrix. We attach deg-1 additional
    matrix products and compute deg-1 Hermite normal forms.
*/ 
	for (i=1; i<=deg; ++i)
	{
		alpha = mat_order_col_to_anf_elt(ord, trans1, i);  
        	matr  = anf_rep_mat(ord, alpha);
		mat1  = mat_ring_mult(ordcoef, matr, trans2);
 
		if(i == 1)
		{
			mat0 = mat_new(deg, twodeg);
			mat_ring_create_zero_sub(ordcoef, &mat0);
			hnf = mat_ring_insert(ordcoef, mat0, mat1, 1, 1);
		}
		else
		{
			mat0= hnf;
			mat2= mat_ring_insert(ordcoef, hnf, mat1, 1, deg1);
			hnf = mat_ring_hnf_col_upper(ordcoef, mat2);
			mat_delref(ordcoef, &mat2);
		}
 
		anf_elt_delete(ord, &alpha);
		mat_delref(ordcoef, &matr);
		mat_delref(ordcoef, &mat0);
		mat_delref(ordcoef, &mat1);
	}
 
	anf_ideal_tran(id) = mat_ring_submat(ordcoef, hnf, 1, 1, deg, deg);
        anf_ideal_tran_hnf(id) = 1;
 
/*
    denominator
*/
        anf_ideal_tran_den(id)	= integer_mult(anf_ideal_tran_den(id1), 
					       anf_ideal_tran_den(id2));


	z = m_z_str_incref(structure_z);                 
	mat_z_simplify ( z, anf_ideal_tran(id), &anf_ideal_tran_den(id) );           
	ring_delete(&z);

	if((order_one_position(ord) == 1) && (anf_ideal_tran_den(id) == 1))
	{
		anf_ideal_min(id) = 
		integer_incref(mat_elt(anf_ideal_tran(id), 1, 1));
	}
	mat_delref(ordcoef, &hnf);
 

	return id;
}
