/******************************************************************************
  mat_ring_diminish.c
******************************************************************************/
#include "kant.h"

t_void
mat_ring_diminish WITH_4_ARGS (
	t_handle,	rrng,
	matrix*,	mat,
	integer_small,	row,
	integer_small,	col
)
/******************************************************************************
 
Description:	Deletes a column and a row of a matrix.

Calling sequence:
 
	mat_ring_diminish(rrng,&mat,row,col)
 
History:
 
	93-02-17 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,j,ccol,rrow;
	matrix		m,mm;

	mm = *mat;
	rrow = mat_row(mm);
	ccol = mat_col(mm);

	if ((rrow == 1) || (ccol == 1))
	{
		mat_delref(rrng,&mm);
		*mat = MEM_NH;
		return;
	} 

	m = mat_new(ccol-1,rrow-1);
	for (i=1;i<row;i++)
	{
		for (j=1;j<col;j++) mat_elt(m,i,j) = ring_elt_incref(rrng,mat_elt(mm,i,j));
		for (j=col+1;j<=ccol;j++) mat_elt(m,i,j-1) = ring_elt_incref(rrng,mat_elt(mm,i,j));
	}
	for (i=row+1;i<=rrow;i++)
	{
		for (j=1;j<col;j++) mat_elt(m,i-1,j) = ring_elt_incref(rrng,mat_elt(mm,i,j));
		for (j=col+1;j<=ccol;j++) mat_elt(m,i-1,j-1) = ring_elt_incref(rrng,mat_elt(mm,i,j));
	}
	mat_delref(rrng,&mm);
	*mat = m;
	return;
}		





