#include "stdio.h"        
#include "kant.h"
#include "anf.h"
#include "mat.h"

void
order_mult_table_write WITH_2_ARGS(
	order,		ord,
	integer_small,	mode
)
/*******************************************************************************
 
order_mult_table_write.c
 
JS August 1991
Last modification: 17.10.91
 
Printing the multplication table of an order (using anf_elt_write).
 
mode = 1: Only non zero entries are printed, each in a row.
mode = 2: All matrices are printed
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
	order		ordcoef;
	matrix		mat;
	anf_elt		alpha;
	integer_small	i, j, k;
 
 
	deg = order_rel_degree(ord);
	ordcoef = order_coef_order(ord);
 
	printf("Multiplication table for basis elements:\n");
 
 	for (k=1; k<=deg; ++k) 
	{
		printf("Matrix No. %d:\n",k);
		mat = order_mult_matrix(ord,k);

		if(mode == 1)
		{ 
		 	for (i=1; i<=deg; ++i) 
			{	
				for (j=1; j<=deg; ++j) 
				{     
					alpha = mat_elt(mat, i, j);
					if(alpha) 
					{
					    printf("  Element (%d,%d) = ",i,j);
					    anf_elt_write(ordcoef, alpha);
					    printf("\n");
					}
				}
			}
		}
		else if(mode == 2)
		{
			mat_anf_write(ordcoef, mat);
		}
	}
			
  
	return;
}
