#include "defs.h"
#include "ring.h"
#include "mat.h"


void
mat_ring_col_hnf_mod_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	q,
	matrix *,	hnf
)
/*
** Calculates the Modular Column Hermite Normal Form of a, placing it in
** *hnf. Calculations are done mod q.
*/
{
	switch( ring_type( cring ))
	{
	case RING_Z:
		mat_z_col_hnf_mod_sub( cring, a, q, hnf );
		return;

	default:
		break;
	}

	error_internal( "generic MHNF not coded" );
}


matrix
mat_ring_col_hnf_mod WITH_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	q
)
/*
** Calculates the Modular Column Hermite Normal Form of a mod q.
*/
{
	matrix	hnf;

	hnf = 0;
	mat_ring_col_hnf_mod_sub( cring, a, q, &hnf );
	return hnf;
}
 
 
 
matrix
mat_ring_hnf_mod_upper WITH_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	q
)
/*
** Return the upper modular HNF column form of a.
*/
{
	matrix		hnf;
	integer_small	i, j, r, rows, half_rows, cols, half_cols;

	rows = mat_row(a);
	cols = mat_col(a);
	r = ( rows > cols ? cols : rows );
	half_rows = rows / 2;
	half_cols = r / 2;
	 
	for (i=1, j=rows; i<=half_rows; ++i, --j)
		mat_ring_row_swap(cring, a, i, j, 1, cols);

	hnf = 0;
	mat_ring_col_hnf_mod_sub( cring, a, q, &hnf );
 
	for (i=1, j=rows; i<=half_rows; ++i, --j)
		mat_ring_row_swap(cring, hnf, i, j, 1, r);
 
	for (i=1, j=r; i<=half_cols; ++i, --j)
		mat_ring_col_swap(cring, hnf, i, j, 1, rows);
 
	return hnf;
}

