#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "dyn_arr.e"
 
t_handle
mat_z_null_space	WITH_2_ARGS(
    t_handle,	ring,
    t_handle,	mat
)
{
    /*
     *  Given a m x n matrix A over a field, return a basis of the kernel of A
     *    i.e., of row vectors V such that VA = 0
     */
    
    register t_int	i, j, k;
    t_int		m, n;
    t_handle	hnf, trn;
    t_handle	nullsp;
    t_ring_elt	zero = ring_zero(ring);

    /*
     *  Compute column hermite normal form and transformation matrix
     */
    hnf = mat_new( mat_row( mat ), mat_col( mat ));
    trn = mat_new( mat_row( mat ), mat_row( mat ));
    mat_ring_hnf_row_sub(ring, mat, &hnf, &trn, TRUE);

    /*
     *                                ( *  *  * )
     *                                (  * *  * )
     *  At this point, trn * mat =    ( 0 ... 0 )
     *                                ( .  .  . )
     *                                ( 0 ... 0 )
     *    so last rows of trn generate the null space
     */
    m = mat_row(mat);
    j = n = mat_col(mat);
    for (i = 1; i <= m && j <= n; i++)
    {
	if (mat_elt(hnf, i, 1) != zero)
	    continue;
	for (j = 2; j <= n && mat_elt(hnf, i, j) == zero; j++)
	    ;
    }
    if (j <= n)
    {
	/* no zero rows: null space is empty */
	return dyn_arr_alloc(0);
    }
    i--;	/* i is the first row of zeros */
    nullsp = mat_new(m - i + 1, m);
    for (k = 1; i <= m; i++, k++)
    {
	for (j = 1; j <= m; j++)
	    mat_elt(nullsp, k, j) = mat_elt(trn, i, j);
    }
    mat_incref_entries(ring, nullsp);
 
    mat_delref(ring, &trn);
    mat_delref(ring, &hnf);

    return nullsp;
}
