#include "defs.h"
#include "mp.e"
#include "mp.h"

#ifdef MP_USE_RECALL
mp_float    mp_catalan_precise_val;
mp_int	      mp_catalan_precise_len;
#endif MP_USE_RECALL

mp_float
mp_catalan    WITH_1_ARG(
    mp_float,	 x
)
/*
Sets x to Catalan's constant according to the precision of x.
*/
{
    mp_ptr_type	       xp = mp_ptr(x);
    mp_base_type    b = mp_b(xp);
    mp_length	     t = mp_t(xp), new_t;
    mp_int	  i, j;
    mp_acc_float    sum, term, p, temp;
    mp_ptr_type	       term_ptr, sum_ptr, p_ptr, temp_ptr;
    mp_round_type    save_round = round;

#ifdef MP_USE_RECALL
    if (mp_catalan_precise_len >= 0)
    {
	if (mp_catalan_precise_len >= t)
	{
	    /*
	    ** Return imprecise copy of recalled value of catalan.
	    */

	    mp_priv_move(mp_catalan_precise_val, x);
	    return x;
	}

	/*
	** Delete copy of catalan, needed to greater accuracy.
	*/

	mp_delete_float(mp_catalan_precise_val);
    }

    /*
    ** Can assume that no precise value is remembered at this moment in
    ** time. (Re)calculate catalan and store result in mp_catalan_precise_val.
    */

    mp_catalan_precise_val = mp_alloc(b, t);
    mp_catalan_precise_len = t;
#endif MP_USE_RECALL

    new_t = t + 1 + mp_extra_guard_digits(1, b);
    mp_acc_float_alloc_4(b, new_t, sum, term, p, temp);

    round = MP_TRUNC;

    mp_q_to_mp(1, 2, sum);
    mp_copy(sum, term);
    mp_copy(term, p);

    term_ptr = mp_acc_float_ptr(term);
    sum_ptr = mp_acc_float_ptr(sum);
    p_ptr = mp_acc_float_ptr(p);
    temp_ptr = mp_acc_float_ptr(temp);

    mp_change_up();

    i = 1;
    j = 3;

#define fix()	      if (mp_has_changed())	       \
	    {			 \
		term_ptr = mp_acc_float_ptr(term);    \
		temp_ptr = mp_acc_float_ptr(temp);    \
		p_ptr = mp_acc_float_ptr(p);	\
		sum_ptr = mp_acc_float_ptr(sum);    \
	    }

    do
    {
	mp_length	 mul_t = new_t + 2 + mp_expt(term_ptr);

	if (mul_t <= 2)
	    break;

	if (mul_t > new_t)
	    mul_t = new_t;

	mp_t(p_ptr) = mp_t(term_ptr) = mp_t(temp_ptr) = mul_t;

	mp_mul_q_eq(p, i, j);
	mp_mul_q_eq(term, i, j);

	mp_div_int(p, j, temp);

	mp_add_eq(term, temp);

	fix();
	mp_t(term_ptr) = new_t;

	mp_add_eq(sum, term);

	i++;
	j += 2;

	fix();
    } while (mp_expt(sum_ptr) - mp_expt(term_ptr) <= new_t + 1);

    mp_move(sum, x);

    mp_acc_float_delete(temp);
    mp_acc_float_delete(p);
    mp_acc_float_delete(term);
    mp_acc_float_delete(sum);

    mp_change_down();

    round = save_round;

#ifdef MP_USE_RECALL
    /*
    ** Record value for later recall.
    */

    mp_copy(x, mp_catalan_precise_val);
#endif MP_USE_RECALL

    return x;
}
