
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_zero_poly WITH_2_ARGS(
        t_handle,    pring,
        t_poly,   apoly
)
/*
 * create the zero polynomial with the same princvar and least_princvar
 * as apoly.
 */

{
    t_handle       aph;
    t_handle       resph;
    t_handle       temp;
    t_int  lpvar;
    t_int  pvar;
    t_int  varno;

    if (m_poly_const (apoly))
        return 0;

    aph = m_poly_poly_to_handle (apoly);
    pvar = m_poly_princvar (aph);
    lpvar = m_poly_least_pvar (aph);
    resph = m_poly_poly_to_handle (0);

    for (varno = lpvar; varno >= pvar; varno --)
    {
        m_poly_create_empty(&temp, varno, lpvar, 1);
        m_poly_coefft (temp, 0) = m_poly_handle_to_poly(resph);
        m_poly_expt (temp, 0) = 0;
        resph = temp;
    }

    m_poly_nterms(resph) = 1;

    return m_poly_handle_to_poly(resph);

} /* poly_z_zero_poly () */



t_bool
poly_z_is_zero_poly WITH_2_ARGS(
        t_handle,    pring,
        t_poly,   apoly
)
/*
 * return TRUE iff apoly is the zero poly
 */

{
    t_handle    aph;

    if (m_poly_const (apoly))
        return (apoly == 0);

    aph = m_poly_handle_to_poly (apoly);

    for (;;)
    {
        if (m_poly_nterms (aph) != 1)
            return FALSE;
        if (m_poly_expt (aph, 0) != 0)
            return FALSE;
        if (m_poly_univariate (aph))
            return (m_poly_coefft (aph, 0) == 0);
        aph = m_poly_poly_to_handle (m_poly_coefft (aph, 0));
    }
} /* poly_z_is_zero_poly () */

