#include "kant.h"


t_logical  
anf_ideal_idempotent WITH_5_ARGS (order       ,  ord  ,
                                  anf_ideal   ,  a    ,
                                  anf_ideal   ,  b    ,
                                  anf_elt   * , alpha ,
                                  anf_elt   * , beta    )

/* This function tries to find alpha in a and beta in b such that : */
/*                                                                  */
/*                alpha  + beta  = 1                                */
/*                                                                  */
/* The function will return FALSE if this in not possible           */
/* (iff a and b are NOT comaximal)                                  */
/* Otherwise TRUE will be returned.                                 */
{

             block_declarations;

             t_handle         Z;
             matrix         hnf,m,trans;
             matrix         mat1;
                         
             anf_elt        temp1,temp2,temp3;
           
             integer_small  n,i,onepos;
             t_logical        comax;

  order_must_be_over_z (ord);
 
  onepos = order_one_position(ord);
  if (onepos <= 0) 
    error_internal("ANF_IDEAL_IDEMPOTENT : One not in basis.");


  anf_ideal_z_assure (ord,a);
  anf_ideal_z_assure (ord,b);

                                    
  Z      = order_coef_order (ord);
  n      = order_abs_degree (ord);


  hnf    = MEM_NH;
  trans  = MEM_NH;

  *alpha = MEM_NH;
  *beta  = MEM_NH;




  mat1 = mat_new (n,n+n);      
  m    = mat_ring_insert (Z,mat1,anf_ideal_tran (a),1,1);
  mat_delref (Z,&mat1);
                                    
  mat1 = m;
  m  = mat_ring_insert (Z,m,anf_ideal_tran (b),1,n+1);
  mat_delref (Z,&mat1);
       

/* Ok We have got the Matrix to be hermite reduced ... (it's m) */

  mat_ring_hnf_col_sub (Z,m,&hnf,&trans,1);


  if (anf_print_level > 4)
  {
    puts("HNF reduced ideal rep. matrix:");
    mat_anf_write(Z, hnf); 
    puts("Trafo matrix:");
    mat_anf_write(Z, trans); 
  }
         
  mat1 = mat_ring_submat (Z,hnf,1,1,n,n);

  if (mat_ring_is_one (Z,mat1))  /* Great a and b are comaximal */
                                 /* so we can find a solution   */
  {                                                               
     comax = TRUE;

     *alpha  = 0;
     *beta   = 0;

  /* We frist store the coeff's of alpha .. */
    
     for (i=1;i<=n;i++)
     {
       temp1  = mat_order_col_to_anf_elt (ord,anf_ideal_tran (a),i);
       temp2  = anf_elt_mult (ord,temp1,mat_elt (trans,i,onepos));
       temp3  = *alpha;
       *alpha = anf_elt_add (ord,*alpha,temp2);                         
                                               
       anf_elt_delete (ord,&temp1);
       anf_elt_delete (ord,&temp2);
       anf_elt_delete (ord,&temp3);
     }


  /* Now we store the coeff's of beta .. */
    
     for (i=1;i<=n;i++)
     {
       temp1  = mat_order_col_to_anf_elt (ord,anf_ideal_tran (b),i);
       temp2  = anf_elt_mult (ord,temp1,mat_elt (trans,i+n,onepos));
       temp3  = *beta;
       *beta = anf_elt_add (ord,*beta,temp2);                         
                                               
       anf_elt_delete (ord,&temp1);
       anf_elt_delete (ord,&temp2);
       anf_elt_delete (ord,&temp3);
     }
  }
  else
    comax = FALSE;


 
  mat_delref (Z,&mat1);
  mat_delref (Z,&trans);
  mat_delref (Z,&m);
  mat_delref (Z,&hnf);

  return comax;
}
