#include "kant.h"


/* Factors a given prime ( in ZZ) into ideals in the integral closure */
/* of an alg. number field                                            */







handle
order_prime_factorize_remainder WITH_2_ARGS (order          , ord ,
                                             integer_small  ,  p    )
{
              trbl_declarations;

              anf_ideal        ideal,a,b;

              handle           fac;
              dyn_arr_handle   p_ideal_val;

              anf_elt          alpha;  
              integer_big      i_norm,a_norm,den,rem,temp,dummy;
              integer_small    i,m,n,x,e,a_val;
              Logical          ok,is_prime,new_p_ideal;

  if (anf_print_level >5)
    puts ("START FACTO.");              


  order_must_be_over_z (ord);

  n           = order_abs_degree (ord);
  m           = 0;
  x           = n;
  p_ideal_val = BH_NIL_HANDLE;


  ideal  = anf_ideal_2_create (ord,p,p);
  anf_ideal_2_z (ord,ideal);

  if (anf_print_level >1)
  {
    printf ("We want to fact. the ideal : ");anf_ideal_2_write (ord,ideal);puts("");
  }


  anf_ideal_remainder_init (&alpha);

  while (    (ok = anf_ideal_remainder_next (ord,ideal,&alpha)) 
          && (x > 0)                                           )
  {
    if (!anf_elt_is_zero (ord,alpha))
    {
      if (anf_print_level >5)
      {
        puts ("... next");
        printf ("Testing element alpha = ");anf_elt_write (ord,alpha);puts (""); 
      }


/* There are still more possible ideals, which are divisors of p O(F)  */

/* Create a possible divisor                                           */
/* Some checks have to be done in order to check whether or not        */
/* this ideal is a prime - divisor.                                    */

/* If the norm the present element is not divided by p the ideal a can */
/* not be a divisor.                                                   */
  

      anf_norm (ord,alpha,&a_norm,&den);
      temp = integer_rem (a_norm,p);
      rem  = integer_abs (temp);
 
      integer_delref (temp);

      if (anf_print_level >5)
      {
        cay_print ("With norm : %d\n",a_norm);
        cay_print ("and with remainder : %d\n",rem);
      }

      if (rem == 0) /* This ideal (created by p and alpha)               */
                    /* might be a prime ideal, we  check it              */
      {

        a = anf_ideal_2_create (ord,p,alpha);

        anf_ideal_norm (ord,a,&i_norm,&den);      

        a_val    = integer_prime_val (i_norm,p);

        if (anf_print_level >5)
        {
          printf ("Checking ideal : ");anf_ideal_2_write (ord,a);
          cay_print (" with norm %d  (p-val = %d)\n",i_norm,a_val);
        }

        if (a_val != 1) 
        {
/* We have to do an additional check, since the norm of the ideal      */
/* is NOT prime.                                                       */ 
          is_prime = anf_ideal_is_prime_ideal (ord,a,&b);              

          if (!is_prime)
            anf_ideal_delete (ord,&b);
        } 
        else /* Since norm(a) equals p we have a prime ideal              */
          is_prime = TRUE;



        if (is_prime)
        {
/* Check if ideal a (which is prime) has already been detected as an   */
/* divisor of    p O(F).                                               */

          if (anf_print_level >2)
          {
            printf ("We found a new prime ideal : ");
            anf_ideal_2_write (ord,a);puts ("");
          }

          new_p_ideal = TRUE;
          i = 0;
  
          if (anf_print_level >2)
            puts ("checking the new PI (does it already ex. ?)");

          while (    (i<m)
                  && (new_p_ideal) ) 
          {
            if (dyn_arr_element (p_ideal_val,i) == a_val)
            {
               b = ipoly_faclst_factor (fac,i);
             
               anf_ideal_tran_assure_hnf_upper (ord,b);
               if (anf_print_level > 6)
               {
                 printf("Testing : ");anf_elt_write (ord,alpha);
                 printf(" in ideal : ");anf_ideal_2_write (ord,b);
                 puts ("");
                 puts ("Z - Basis of ideal ");anf_ideal_z_write (ord,b);
                 puts ("");
               }               

               if (anf_elt_in_ideal (ord,alpha,b))
                 new_p_ideal = FALSE;        
               if (anf_print_level > 6)
               {
                 if (new_p_ideal)
                   puts ("NOT in");
                 else
                   puts ("IN");
               }
            }
            i++;
          }

          if (anf_print_level >2)
            puts ("check done");     

          if (new_p_ideal)
	  {
            if (anf_print_level >2)
              puts ("A NEW DIVISOR");

            m++; /* We have a new prime ideal */

            anf_ideal_tran_assure_hnf_upper (ord,a);
            anf_ideal_min_assure (ord,a); 
        
            anf_ideal_degree (a) = a_val;           
         
            e = anf_ideal_ram_index_p (ord,p,a,&x);

            if (anf_print_level >3)
            {
              cay_print ("Norm of new prime ideal   : %d\n",i_norm);  
              printf ("Degree                    : %d\n",a_val);
              printf ("ramification index        : %d\n",e);
              printf ("product                   : %d\n",e*a_val);

              printf ("new bound                 : %d\n", x);
            }

            if (m == 1) /* Everything is new -- create all data */ 
            {
              p_ideal_val = dyn_arr_alloc (1);
              dyn_arr_element (p_ideal_val,0)   = a_val;
	      dyn_arr_curr_length (p_ideal_val) = 1;

              fac = ipoly_faclst_alloc (1); 
              ipoly_faclst_power (fac,0)  = e;
              ipoly_faclst_factor (fac,0) = anf_ideal_incref (a);
              ipoly_faclst_len_put (fac,1);
            }      
            else /* We already created the needed structures */
              {
/* First store the data in p_ideal_val    */
                dyn_arr_assure_space (p_ideal_val,m,1);
                dyn_arr_element (p_ideal_val,m-1)   = a_val;
                dyn_arr_curr_length (p_ideal_val)   = m;

/* Now store the prime ideal a with ram. index e in faclst */
                ipoly_faclst_assure_space (fac,m);
                ipoly_faclst_power (fac,m-1)  = e;
                ipoly_faclst_factor (fac,m-1) = anf_ideal_incref (a);
                ipoly_faclst_len_put (fac,m);         
              } 
          }
        } 
        integer_delref (i_norm);
        anf_ideal_delete (ord,&a);
      }
      integer_delref (a_norm);
      integer_delref (rem);
    }
  }

  if (anf_print_level >1)
    puts ("FINISHED BRUTE FORCE SEARCHING");


/* Now delete the dynamic array p_ideal_val                      */
/* Remember : there are just small integers stored in this array */

  if (p_ideal_val != BH_NIL_HANDLE)
    dyn_arr_delete (&p_ideal_val);



  if (m == 0) /* We found no ideal */
  {
    fac = ipoly_faclst_alloc (1); 
    ipoly_faclst_power (fac,0)  = 1;
    ipoly_faclst_factor (fac,0) = anf_ideal_incref (ideal);
    ipoly_faclst_len_put (fac,1);
  }      

  anf_elt_delete (ord,&alpha);
  anf_ideal_delete (ord,&ideal);

  if (anf_print_level > 1)
  {
    printf ("Factorization of %d\n",p);
    anf_ideal_faclst_write (ord,fac); 
  }

  return fac;
}
 






