#include "kant.h" 
#include "anf_rel_sort.h"


anf_rel_sort
anf_con_sort_sub WITH_4_ARGS(
	order,		ord,
	order,		ord_sub,
	anf_elt,	a_elt,
	anf_elt,	b_elt_sub
)
/*******************************************************************************
 
AJ January 1992
Last modification: 

	92-06-25 AJ    new definition of sort  
 
 
Description:
 
	The elements a_elt, b_elt_sub must be have one same 
	conjugate (see anf_elts_same_con_aj.c) and b_elt_sub 
	must be a primitive element of F!!

	The function sorts the conjugates of a_elt and stores the result
	in sort (see description in anf_rel_sort.h).

 
Calling sequence:
 
	anf_con_sort_sub(ord, ord_sub, a_elt, b_elt_sub);
                                                                        
      	order       ord      = t_handle of order 
      	order       ord_sub  = t_handle of an order in a subfield
      	anf_elt     a_elt    = algebraic number in ord (conjugates)
      	anf_elt     a_elt    = algebraic number in ord_sub (conjugates)
      
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
	block_declarations;         

  	int		i,j, ac_sign, bc_sign,is_real, lauf, h1;
        integer_small   erg, erg2, r1, r2, r1_sub, r2_sub, sj, tj;
   	t_handle          reals;
        t_real          loceps, a, ac, b, bc, sq2, zero, temp1; 

	anf_rel_sort	sort;

                            

/*** Initialisation  **********************************************************/
                              
        r1= order_r1(ord);
        r2= order_r2(ord);

        r1_sub= order_r1(ord_sub);
        r2_sub= order_r2(ord_sub); 

	sq2  = order_sqrt_2(ord);    

        sort= anf_rel_sort_create(ord, ord_sub);

        reals = order_reals(ord); 
        loceps= real_make(reals, 10, -real_dec_prec(reals)+2 );  
        zero= conv_int_to_real(reals,0);
 
/*** Sorting the real conjugates  ********************************************/
                            
        for (j= 1;j<= r1_sub; j++) 
         {           
	  lauf= 0;
          b= real_incref(anf_con(b_elt_sub, j));

	  for (i= 1;i<= r1; i++) 
	   {        
            a= real_incref(anf_con(a_elt, i)); 
            erg= real_equality_eps(reals, a, b, loceps);  
          
   	    if (anf_print_level >=5 )
     	     {
              printf("\nanf_con_sort_sub:\n"); 		   
              printf("Real (%d,%d):\n",j,i); 		   
              real_write(reals, b, 20); printf("\n");
              real_write(reals, a, 20); printf("\n");
   	      printf("Result:  %d\n\n", erg); 		   
	     }

            real_delete(&a);

            if (erg)  
	     {        
	      lauf= lauf+1;
	      anf_rel_sort_real_zeroes_elt(sort,j)++;
	      anf_rel_sort_ordering_elt(sort,j,lauf)= i;  
	     }
           }  /* end for: i<= r1 */

	  for (i= r1+1;i<= r1+r2; i++) 
	   {        
            a= real_incref(anf_con(a_elt, i));
            ac= real_abs(reals, anf_con(a_elt, r2+i));
	    ac_sign= real_sign(reals, anf_con(a_elt, r2+i));  

	    if (real_equality_eps(reals, ac, zero, loceps))
	     {              
	      temp1= real_mult(reals, b, sq2);
	      erg= real_equality_eps(reals, a, temp1, loceps);  

   	      if (anf_print_level >=5 )
     	       {
                printf("\nanf_con_sort_sub:\n"); 		   
                printf("Real (%d,%d):\n",j,i); 		   
                real_write(reals, temp1, 20); printf("\n");
                real_write(reals, a, 20); printf("\n");
   	        printf("Result:  %d\n\n", erg); 		   
	       }

              real_delete(&temp1);

              if (erg)  
	       {        
	        lauf= lauf+1;
	        anf_rel_sort_comp_zeroes_elt(sort,j)++;
	        anf_rel_sort_ordering_elt(sort,j,lauf)= i;  
	        lauf= lauf+1;
	        anf_rel_sort_ordering_elt(sort,j,lauf)= i+r2;  
	       }
	     }

            real_delete(&a);
            real_delete(&ac);

           }  /* end for: i<= r1+r2 */

          real_delete(&b);

         }  /* end for: j<= r1_sub */


/*** Sorting the complex conjugates  ******************************************/
                   

        for (j= r1_sub+1;j<= r1_sub+r2_sub; j++) 
	 {
	  lauf= 0;
          b= real_incref(anf_con(b_elt_sub, j));
          bc=      real_abs(reals, anf_con(b_elt_sub, r2_sub+j)); 
          bc_sign= real_sign(reals, anf_con(b_elt_sub, r2_sub+j));
	  

	  for (i=r1+1;i<= r1+r2; i++)         
	   {
            a= real_incref(anf_con(a_elt, i)); 		    

            /* comparisation of the real part of the conjugates */

            erg= real_equality_eps(reals, a, b, loceps); 

  	    if (anf_print_level >=5 )
	     {
              printf("\nanf_con_sort_sub:\n"); 		   
              printf("Complex real-part(%d,%d):\n",j,i); 		 
              real_write(reals, b, 20); printf("\n");
              real_write(reals, a, 20); printf("\n");
              printf("Result:  %d\n\n", erg);
	     }

            real_delete(&a);     

	    if (erg)
	     {   
	      /* if the real parts are equal we test the absolute values
	         of imaginary parts */
              ac= real_abs(reals, anf_con(a_elt, r2+i)); 
              ac_sign= real_sign(reals, anf_con(a_elt, r2+i));
             
	      erg2= real_equality_eps(reals, ac, bc, loceps);
                 
  	      if (anf_print_level >=5 )
	       {
                printf("\nanf_con_sort_sub:\n"); 		   
                printf("Con. complex absolute (%d,%d):\n",j,i); 		   
                real_write(reals, bc, 20); 
	        printf("    sign= %d", bc_sign); printf("\n");
                real_write(reals, ac, 20); 
	        printf("    sign= %d", ac_sign); printf("\n");
	        printf("Result:  %d\n\n", erg2);
   	       }

              real_delete(&ac);     

              if (erg2) 
	       /* if the absolute values of the imaginary parts are equal */
               {
	        if (ac_sign == bc_sign)
 	         {
	          lauf= lauf+1;
	          anf_rel_sort_ordering_elt(sort,j,lauf)= i;  
	          anf_rel_sort_ordering_elt(sort,j+r2_sub,lauf)= i+r2;  
	         }
	        else
	         {
	          lauf= lauf+1;
	          anf_rel_sort_ordering_elt(sort,j,lauf)= i+r2;  
	          anf_rel_sort_ordering_elt(sort,j+r2_sub,lauf)= i;  
	         }          

	       }  /*  endif: erg2 */

             }  /*  endif: erg */

       	   } /* end for: i */  

          real_delete(&b);     
          real_delete(&bc);     

       	 } /* end for: j */  


/*** For the real fields the ordering over F^(j) ******************************/
                                        
	
	if (anf_print_level>=5)
 	   printf("\nSignatures over F^(j): \n");

        for (j= 1;j<= r1_sub; j++) 
	 { 
	  sj= anf_rel_sort_real_zeroes_elt(sort,j);
	  tj= anf_rel_sort_comp_zeroes_elt(sort,j);
 
          if (anf_print_level>=5)                           
	    printf("\nF^(%d):  s= %d,  t= %d ", j, sj, tj); 
	  
          for (i= sj+1 ;i<= sj+tj; i= i+2) 
	   {
	    h1=  anf_rel_sort_ordering_elt(sort,j,i+1);
	    anf_rel_sort_ordering_elt(sort,j,i+1)= 
	                                 anf_rel_sort_ordering_elt(sort,j,i+tj);
	    anf_rel_sort_ordering_elt(sort,j,i+tj)= h1;
	   }
	 }	

/*** End of sorting ***********************************************************/

	real_delete(&loceps);
	real_delete(&zero);

	return sort;   

} 

