/******************************************************************************
  rel_lat_create.c
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"

rel_lattice
rel_lat_create WITH_NO_ARGS(
)
/*******************************************************************************
 
Description:	Allocating space for a relative lattice
		The task of this routine is to allocate sufficient space for
		the table which describes a lattice. 
 
		The invariants of the lattice are set to t_void.
 
Calling sequence:
 

 
History:
 
	92-03-11 AJ    written
 
*******************************************************************************/
{
	rel_lattice rel_lat;

	rel_lat = mem_alloc_zero(sizeof(rel_lattice_struct));
 
	block_init(rel_lat, REL_LATTICE_BLOCK_TYPE);

	rel_lat_rank(rel_lat) 		= -1;
	rel_lat_number_con(rel_lat) 	= -1;
 
        rel_lat_coef_ord(rel_lat)       = MEM_NH;
        rel_lat_coef_ord_gram(rel_lat)  = MEM_NH;

        rel_lat_basis(rel_lat)          = MEM_NH;
        rel_lat_basis_ring(rel_lat)     = MEM_NH;
  
        rel_lat_gram(rel_lat)           = MEM_NH;
        rel_lat_gram_ring(rel_lat)      = MEM_NH;
 
        rel_lat_chol(rel_lat)           = MEM_NH;
        rel_lat_chol_ring(rel_lat)      = MEM_NH;
                                                        
        rel_lat_disc(rel_lat)           = MEM_NH;
        rel_lat_disc_ring(rel_lat)      = MEM_NH;
 
	return rel_lat;
}
