#include "kant.h"
#include "rel_lattice.h"

t_void
rel_lat_elt_delete WITH_2_ARGS(
	t_handle,		rel_lat,
	rel_lat_elt *,	rel_elt
)
/*******************************************************************************
 
rel_lat_elt_delete.c
 
AJ March 1992
Last modification: -
 
Deleting a relative lattice element. The element is delreffed. If there are
no other references it is deleted completely.
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	rank, i;
	t_handle		Z;


	if (!rel_lat_elt_has_other_refs(*rel_elt))
	 {
          Z= m_z_str_incref(structure_z);

          rank = rel_lat_rank(rel_lat);
	  for(i=1; i<=rank; ++i)           
	   {
            if (rel_lat_elt_coef(*rel_elt, i)!= MEM_NH)
	     {
	       anf_elt_delref(rel_lat_coef_ord(rel_lat), 
	                      &rel_lat_elt_coef(*rel_elt, i));
	     }
	    rel_lat_elt_coef(*rel_elt, i)= 0;
	   }
	 }

	vec_delete(Z,rel_elt);
 
	*rel_elt = MEM_NH;

	ring_delete(&Z);
 
	return;
}
