#include "kant.h"
#include "thue.h" 

vector
thue_lf_init_delta WITH_4_ARGS(
                thue,                	th,
                integer_small,          j,
                integer_small,          k,
                t_real,                 log_delta_r
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg,r,u, l, nr, i, i_max;
	t_real		h1, h2, h3, h4, h5, h6, h7, h8;
        t_comp          con1, con2; 
        order           ord;
        vector          delta;
	t_handle	R;
        anf             field;
        anf_elt         gamma;
        dyn_arr_handle  delta2;
     
        deg = thue_abs_degree(th);
        ord = thue_order(th);
        r = order_r(ord);
	R = order_reals(ord);
        field = order_anf(ord);
        
        delta = vec_new(r+1);
        for (u=1; u<r; u++)
                {
        	con1 = anf_elt_ith_con(ord, order_unit(ord, u), k);
        	con2 = anf_elt_ith_con(ord, order_unit(ord, u), j);
        	h1 = comp_re(R, con1);
        	h2 = comp_re(R, con2);
        	h3 = real_divide(R, h1, h2);
        	real_delete(&h1);
        	real_delete(&h2);       
        	comp_delete(&con1);
        	comp_delete(&con2);
         	h1 = real_abs(R, h3);
        	real_delete(&h3);
                h2 = real_log(R, h1);
                real_delete(&h1);
                vec_entry(delta, u) = real_divide(R, h2, log_delta_r);
                real_delete(&h2);
                } 

        vec_entry(delta, r) = conv_int_to_real(R, 1);

        i_max = dyn_arr_curr_length(thue_gamma(th) );

        delta2 = dyn_arr_alloc(1);
        nr = 0;
        for (l=1;l<=deg;l++)
                {
                if ((j != l) && (k != l))
                        {
                        for (i=1; i<=i_max; i++)
                                {
                                gamma = thue_ith_gamma(th, i);
                        	++nr;
                        	dyn_arr_assure_space(delta2, nr, nr+10);
                        	dyn_arr_curr_length(delta2) = nr;

		        	h1 = anf_poly_z_zero(field, 1, j);
		    		h2 = anf_poly_z_zero(field, 1, k);
		        	h3 = anf_poly_z_zero(field, 1, l);
		        	h4 = real_subtract(R, h2, h3);
		        	h5 = real_subtract(R, h1, h3);
		        	h8 = real_divide(R, h4, h5);    
		        	real_delete(&h4);
		        	real_delete(&h5);
                                con1 = anf_elt_ith_con(ord, gamma, j);
                                con2 = anf_elt_ith_con(ord, gamma, k);
                                h4 = comp_re(R, con1);
                                h5 = comp_re(R, con2);
                                comp_delete(&con1);
                                comp_delete(&con2);
                                h6 = real_divide(R, h4, h5);
                                h7 = real_mult(R, h6, h8);
                                real_delete(&h6);
                                real_delete(&h8);
		        	h4 = real_abs(R, h7);
		       		real_delete(&h7);
		        	h5 = real_log(R, h4);
		        	real_delete(&h4);
		        	dyn_arr_element(delta2, nr-1) = real_divide(R, h5, log_delta_r);
		        	real_delete(&h5);
                                }
                        }
                }

	vec_entry(delta, r+1) = delta2;
        return delta;

}
