#include "kant.h"
#include "thue.h" 

vector
thue_waldschmidt_init_delta WITH_5_ARGS(
                thue,           th,
                integer_small,  j,
                integer_small,  k,
                integer_small,  l,
                anf_elt,        gamma
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg,r,u;
	t_handle	R;
	t_real		h1, h11, h2, h22, h3, h4, h44, h5, h55, h6, h7, h8, h9;
        t_comp          con1, con2, c1, c2, c3; 
        order           ord;
        anf             field;
        vector          delta;

        deg = thue_abs_degree(th);
        ord = thue_order(th);
        R = thue_reals(th);
        r = order_r(ord);
        field = order_anf(ord);

        delta = vec_new(r+1);
        for (u=1; u<=r; u++)
                {
                con1 = anf_elt_ith_con(ord, order_unit(ord, u), k);
                con2 = anf_elt_ith_con(ord, order_unit(ord, u), j);
                h1 = comp_re(R, con1);
                h2 = comp_re(R, con2);
                comp_delete(&con1);
                comp_delete(&con2);
                vec_entry(delta, u) = real_divide(R, h1, h2);
                real_delete(&h1);
                real_delete(&h2);
                }
        h1 = anf_poly_z_zero(field, 1, j);
        h2 = anf_poly_z_zero(field, 1, k);
        h3 = anf_poly_z_zero(field, 1, l);
        con1 = anf_elt_ith_con(ord, gamma, j);
        con2 = anf_elt_ith_con(ord, gamma, k);
        h4 = comp_re(R, con1);
        h5 = comp_re(R, con2);
        comp_delete(&con1);
        comp_delete(&con2);
        h7 = real_divide(R, h4, h5);
        real_delete(&h4);
        real_delete(&h5);
        h6 = real_subtract(R, h2, h3);
        h8 = real_subtract(R, h1, h3);
	h5 = real_divide(R, h6, h8);
        vec_entry(delta, r+1) = real_mult(R, h5, h7);
        real_delete(&h5);
        real_delete(&h6);
        real_delete(&h7);
        real_delete(&h8);

        return delta;
}
