/*******************************************************************************
-----------------------------------------------------------------------------

    ACHTUNG:
    Zur Vermeidung von zu grossen Kompatibilitaetsproblemen duerfen
    Aenderungen in den Strukturdefinitionen nur nach gemeinsamer
    Eroerterung bzw. Einigung zwischen der Cayley- und der Kant-Gruppe
    durchgefuehrt werden.
    Sydney, 25.9.1992             John Cannon, Johannes Gf. Schmettow

-----------------------------------------------------------------------------

    ATTENTION:

    To avoid major problems of incompatibility, changes to the structure
    definitions should only be made after common discussion and agreement
    between the Cayley and Kant groups.

    Sydney, 25/9/1992             John Cannon, Johannes Ct. Schmettow

-----------------------------------------------------------------------------
                    
anf.h
   
This header file includes structure definitions for 
  - algebraic number fields
  - orders in algebraic number fields 
  - algebraic numbers
  - fractional ideals of orders
  - ceilings of algebraic number fields
 
  
Still to be implemented:
  - Representation of 1 if it is not element of the basis
  - Galois group of field  
 

History:
        92-09-17 JS        Move to Cayley V4
        92-09-09 JS        v3_df instead of df
        92-06-04 JS        ceilings
        92-06-04 JS        splitting up anf.h
        92-05-04 JS/MD     order_factor_basis and order_relation_matrix etc.
        92-04-22 JS        order_factor_basis
        92-03-31 JS        units_log_lat etc
        92-03-19 JS        order_set_real_values, class groups, subfields
        92-03-17 JS        anf_ideal_alloc, anf_ideal_*_create
        92-03-16 JS        kant_cominp
	91-10-21 JS        minor changes
	91-08-31 MB/WB/JS  first version
  
*******************************************************************************/

#ifndef INCLUDED_ANF_H
#define INCLUDED_ANF_H
 
#include "debug.h"
#include "att.h"
#include "dyn_arr.h"
#include "integer.e"
#include "real.e"
#include "poly.e"
#include "vector.h"
#include "mat.h"
#include "ring.h"
#include "lattice.h"
 
/*******************************************************************************
/
/  Introducing new types
/
*******************************************************************************/
 
typedef t_handle	anf;
typedef t_handle	order;
typedef t_word  anf_elt;
typedef t_handle	anf_ideal;
typedef t_handle	anf_ceiling;
  
/*******************************************************************************
/
/  General macros
/
*******************************************************************************/
       
/*
    If the Compiler flag -DKANT is set:
    error_internal is substituted by anf_error. This routine has got exactly 
    the same calling syntax but prints out a different error message and then
    aborts the program run.
*/
 
 
#ifdef KANT
  
#define error_internal	anf_error
 
#endif /* KANT */
  
/*
    Distinguishing orders from fields
*/
 

#define handle_is_anf(h)        ((block_type(h) == RING_BLOCK_TYPE) && \
                                 (ring_type(h) == RING_ANF))

#define handle_is_order(h)      ((block_type(h) == RING_BLOCK_TYPE) && \
                                 (ring_type(h) == RING_ORDER))


 
/*
    just in case...
*/
 
#define anf_elt_negate		anf_negate
#define anf_elt_add		anf_add
#define anf_elt_z_add		anf_z_add
#define anf_elt_mult		anf_mult
#define anf_elt_power		anf_power
#define anf_elt_mult_z		anf_mult_z
#define anf_elt_z_mult		anf_z_mult
#define anf_elt_div		anf_div
#define anf_elt_div_z		anf_div_z
#define anf_elt_inverse		anf_inverse
#define anf_elt_norm		anf_norm
#define anf_elt_norm_rel	anf_norm_rel
#define anf_elt_rep_mat		anf_rep_mat
#define anf_elt_trace		anf_trace
#define anf_elt_simplify	anf_simplify
#define anf_elt_denom		anf_elt_den
#define order_invtran_denom	order_invtran_den
#define anf_ideal_tran_denom	anf_ideal_tran_den
 
/*
   old function names
*/
 
#define anf_start               kant_start
#define kant_cominp             order_read_v1
#define order_set_real_values	order_reals_create
#define order_set_reals		order_reals_set
 
/*
    Levels for intermediate output
*/
 
#define ANF_PRINT_LEVEL		41
#define anf_print_level		v3_df[ANF_PRINT_LEVEL]

/*******************************************************************************
/
/  Including the anf header files.
/
*******************************************************************************/
       
#include "anf_anf.h"
#include "anf_order.h"
#include "anf_elt.h"
#include "anf_ideal.h"
#include "anf_ceiling.h"

/*******************************************************************************
/
/   End
/
*******************************************************************************/
 
#endif /* INCLUDED_ANF_H */
 

