
#ifndef BV_INCLUDED
#define BV_INCLUDED

#include "defs.h"

#ifndef BV_BLOCK_TYPE  

#endif


/*
The header for a block containing a bit_vector has the following structure:
*/
 
typedef
    struct
        {
            t_block_header         block_header;
	    t_int		numbits;
	    t_int		numints;
        }
    bit_vector_header;
 
/*
Its length in units of one t_word is:
*/
 
#define BV_HDR_LEN    (MEM_BYTES_TO_WORDS( sizeof( bit_vector_header ) ))
 
/* A bit_vector has the following structure :
*/

typedef
	struct
	{
		bit_vector_header	bv_hdr;
		t_uint			bv_vect[VARIABLE_LENGTH];
	} bv_struct;

#define BV_INT_SIZE (sizeof(int) << 3)
/* sizeof(int) = # of bytes reqd to store an int. 
** multiply by 8 bits (per byte), so BV_INT_SIZE is the size of an
** integer in bits.
*/

#define BV_BIT_MASK (BV_INT_SIZE - 1)


/*
 *      returns the required integer array length for "n" bits
 */

#define bv_bits_to_ints(n)       (((n) + BV_BIT_MASK) >> 5)

#define bv_required_size(n)	(BV_HDR_LEN + bv_bits_to_ints(n))


#define bv_incref(bv)	block_incref(bv)
#define bv_delref(bv)	block_decref_delete(bv)

#define	bv_access(bv)		((bv_struct *) (mem_access(bv)))
#define bv_hdr_access(bv)	(bv_access(bv)->bv_hdr)
#define bv_num_bits(bv)		(bv_hdr_access(bv).numbits)
#define bv_num_ints(bv)		(bv_hdr_access(bv).numints)
#define bv_vector(bv)		(bv_access(bv)->bv_vect)
#define bv_int(bv, i)		(bv_access(bv)->bv_vect[i])

#define maxbits(a, b)		((bv_num_bits(a) > bv_num_bits(b)) ? \
				bv_num_bits(a) : bv_num_bits(b))

#define minbits(a, b)		((bv_num_bits(a) < bv_num_bits(b)) ? \
				bv_num_bits(a) : bv_num_bits(b))

extern t_bit_vector    f_bit_vector_create MEM_P_1(t_uint);
#define bit_vector_create(n) f_bit_vector_create MEM_CALL_1(n)

#endif
