/******************************************************************************
  anf_elt_ceiling.c
******************************************************************************/
 
#include "kant.h"

anf_ceiling
anf_elt_ceiling WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
	Computes the ceiling referring to an algebraic number.
        Here we have
                lambda_j = a_j/nnrm
        where
             a_j  = absolute value of the j-th conjugate of alpha
             nnrm = n-th root of the absolute value of the norm of alpha 
             n    = absolute degree of the number field.
  
Calling sequence:
 
	ceil = anf_elt_ceiling(ord, alpha);

	order		ord	= order over which ceil is defined
	anf_elt		alpha	= algebraic number

History:
 
	92-06-04  JS    first version
 
*******************************************************************************/
{
        integer_small   deg, r1, r2, r12, i;
        t_handle          R;
        vector          aabs;
        t_real          nrm, temp, sq;
        anf_ceiling     ceil;
                
        deg  = order_abs_degree(ord);
        r1   = order_r1(ord);
        r2   = order_r2(ord);
        r12  = r1 + r2;
        R    = order_reals(ord);
 
        ceil = anf_ceiling_alloc(ord);
        aabs = anf_elt_abs(ord, alpha);
        nrm  = conv_int_to_real(R, 1);
 
        for (i=1; i<=r1; i++)
        {
                temp = nrm;
                nrm  = real_mult(R, temp, vec_entry(aabs, i));  
 
                real_delete(&temp);     
        }
        for (i=r1+1; i<=r12; i++)
        {
                temp = nrm;
                sq   = real_power(R, vec_entry(aabs, i), 2);  
                nrm  = real_mult(R, temp, sq);
 
                real_delete(&temp);     
                real_delete(&sq);     
        }
         
 
        temp =  real_root(R, nrm, deg);
 
        for (i=1; i<=r12; i++)
        {       
                anf_ceiling_lambda(ceil, i) = 
			real_divide(R, vec_entry(aabs, i), temp);
        }
        for (i=r12+1; i<=deg; i++)
        {
                anf_ceiling_lambda(ceil, i) = 
			real_incref(anf_ceiling_lambda(ceil, i-r2));
        }
 
        real_delete(&temp);     
        real_delete(&nrm);     
        vec_delete(R, &aabs);
  
	return ceil;
}

