/******************************************************************************
  anf_elt_is_minus1.c                                                           
******************************************************************************/
                 
#include "kant.h"

t_logical
anf_elt_is_minus1 WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
	Returns TRUE if alpha is -1.
 
  
Calling sequence:
 
	if (anf_elt_is_minus1(ord, alpha)) ...
 
      	order       ord   = t_handle of order alpha, beta are given referring to
        anf_elt     alpha = algebraic number 
     
History:
 
	92-09-07 JS    first version

*******************************************************************************/
{       
	block_declarations;
 
	integer_big     a;
        t_logical         result;
                                   
        if (anf_elt_is_integer_sub(ord, alpha, &a))
        {
                result = (a == -1);
                integer_delref(a);
		return result;
        }
 
        return 0;
} 

