#include "kant.h"

t_logical
anf_elt_lift_down WITH_4_ARGS(
	order,		ord1,
	anf_elt,	alpha,
	order,		ord2,
        anf_elt *,      beta
)
/*********************************************************************************

Description:

        if ord2 is given as a subfield_order of ord1, alpha (given referring to ord1)
        will be expressed referring to the basis of ord2 (if possible).
        the new alpha is returned as beta...

Calling sequence:
       
        beta = anf_elt_lift_down(ord1, alpha, ord2 &beta);
        
        order           ord1,ord2    = t_handle to order
        anf_elt         alpha,beta   = algebraic numbers 	

History:

	92-09-17 JS  anf_elt_to_mat_order_col
	92-09-15 JPS written
*********************************************************************************/

{
	block_declarations;
 
	anf_elt		basis_elt;
	integer_small	i, j, k, deg1, deg2;
        t_handle          Z;
        matrix          mat;
        vector          loesung, b;
        t_logical         solved;
        order_must_be_over_z(ord2);
                    
        if (anf_print_level > 2)
        {
                printf("Start trying to lift down "); 
		anf_elt_write(ord1, alpha);
                printf(" from %d to %d.\n", ord1, ord2);
        }
        if (anf_elt_is_integer(alpha) ) 
                {
                *beta = anf_elt_incref(alpha);
                return TRUE;
                }

        k = order_subfield_order_count(ord1);
        i = 1;
        while (i<=k && order_subfield_order(ord1, i) != ord2)
                 ++i;
        if (order_subfield_order(ord1, i) != ord2)  
                {
	        if (anf_print_level > 2)
                printf("Order %d not subfield order of order %d.\n", ord2, ord1);
                return FALSE;
                } 
        
        if (anf_elt_is_con(alpha) )
                {    
                error_internal("anf_elt_lift_down: Conjugates not supported!");
                }
        else
                {
                deg1 = order_abs_degree(ord1);
                deg2 = order_abs_degree(ord2);
                Z = m_z_str_incref(structure_z); 

                mat = mat_new(deg1, deg2);
                b = vec_new(deg1);

                for (j=1; j<=deg2; j++)
                        {
                        basis_elt = order_subfield_order_basis_elt(ord1, i, j); 
                        anf_elt_to_mat_order_col(ord1, basis_elt, mat, j);
                        }
                for (k=1; k<=deg1; k++)
                        vec_entry(b, k) = integer_incref(anf_elt_coef(alpha, k));
                loesung = mat_ring_solve_equat(Z, mat, b);
                anf_elt_alloc(*beta, deg2); 
                solved = FALSE;
                for (j=1; j<=deg2; j++)
                        {
                        anf_elt_coef(*beta, j) = integer_incref(vec_entry(loesung, j));
                        if (vec_entry(loesung, j) != 0 )
                        	{
                                solved = TRUE;
                                }
                        }
                anf_elt_den(*beta) = integer_incref(anf_elt_den(alpha));
                vec_delete(Z, &b);
                vec_delete(Z, &loesung);
                mat_delref(Z, &mat);
                }
        if (!solved)    
                {
  	        if (anf_print_level > 2) puts("Downlift not possible.");
                anf_elt_delete(ord2, beta);
                }
        else if (anf_print_level > 2)
                {
	        printf("Downlift successful. Element= "); 
		anf_elt_write(ord2, *beta); puts("");
                }       

        return solved;
}

