/******************************************************************************
  anf_elt_order_coerce.c                                                           
******************************************************************************/
         
#include "kant.h"

t_logical
anf_elt_order_coerce WITH_4_ARGS(
	order,		ord1,
	anf_elt,	alpha1,
	order,		ord2,
	anf_elt *,	alpha2
)
/*******************************************************************************
 
Description:
 
	Tries to coerce alpha1 from ord1 into ord2.
        Also tries to install homomorphisms if possible.
 
        uses:
             anf_elt_move       (for easy cases)
             anf_elt_hom_find  
             anf_elt_lift_up/down
             anf_elt_embed      (last chance)
 
 
Calling sequence:
 
	if (anf_elt_order_coerce(ord1, alpha1, ord2, &alpha2))...
 
      	order       ord1  = t_handle of order alpha1 is given referring to
        anf_elt     alpha1= algebraic number to move    
      	order       ord2  = t_handle of order alpha2 will be given referring to
        anf_elt     alpha2= moved number
 

History:
 
	92-09-16 JS    first version

*******************************************************************************/
{
	block_declarations;
 
	anf_elt		temp, beta;
	integer_small	i, cnt, deg1, deg2;
        dyn_arr_handle  orders;
 
/*   Easy cases  */
 
	if (	
		(ring_type(ord2) == RING_Z)
	     || (anf_elt_is_integer(alpha1))
             || (ord1 == ord2)
             || (order_coef_order(ord2) == ord1)
             || (order_basis_is_rel(ord2) && order_suborder(ord2) == ord1)
             || (order_basis_is_rel(ord1) && order_suborder(ord1) == ord2) )
    
	{       
                if (anf_print_level > 2) puts("anf_elt_coerce: simple case.");
               	*alpha2 = anf_elt_move(ord1, alpha1, ord2);
                return TRUE;
        }  
         
        order_sig_assure(ord1);
        order_sig_assure(ord2);
        deg1 = order_abs_degree(ord1);
        deg2 = order_abs_degree(ord2);
 
/*   does it make sense at all? */
 
        if (integer_gcd(deg1, deg2) == 1) return FALSE;
 
/*   Looking for a hom-tower from ord1 to ord2 */
        
        orders = 0;
            
       	if ( !(deg2 % deg1) && order_hom_tower_find(ord1, ord2, &orders))
       	{          
                if (anf_print_level > 2) puts("anf_elt_order_coerce: Start uplift.");
           	cnt     = dyn_arr_curr_length(orders);
           	beta    = anf_elt_incref(alpha1);
           	for (i=cnt-2; i>=0; --i)
              	{
	        	temp = beta;
	                beta = anf_elt_lift_up(dyn_arr_element(orders, i+1), temp,
					       dyn_arr_element(orders, i));
	                anf_elt_delete(dyn_arr_element(orders, i+1), &temp);
               }
               *alpha2 = anf_elt_lift_up(dyn_arr_element(orders, 0), beta, ord2);
               anf_elt_delete(dyn_arr_element(orders, 0), &beta);
               for (i=0; i<cnt; ++i) order_delete(&dyn_arr_element(orders, i));
               dyn_arr_delete(&orders);
 
               return TRUE;
       	} 
 	else if ( !(deg1 % deg2) && order_hom_tower_find(ord2, ord1, &orders))
       	{          
                if (anf_print_level > 2) puts("anf_elt_order_coerce: Start downlift.");
           	cnt     = dyn_arr_curr_length(orders);
           	if (!anf_elt_lift_down(ord1, alpha1, dyn_arr_element(orders, 0), &beta))
        	{
	        	for (i=0; i<cnt; ++i) order_delete(&dyn_arr_element(orders, i));
	                dyn_arr_delete(&orders);
        	        return FALSE;
                }

           	for (i=1; i<cnt; ++i)
              	{
	        	temp = beta;
	                if (!anf_elt_lift_down(dyn_arr_element(orders, i-1), temp,
					       dyn_arr_element(orders, i), &beta))
	        	{
		                anf_elt_delete(dyn_arr_element(orders, i-1), &temp);
		        	for (i=0; i<cnt; ++i) order_delete(&dyn_arr_element(orders, i));
	        	        dyn_arr_delete(&orders);
        	        	return FALSE;
	                }
	                anf_elt_delete(dyn_arr_element(orders, i-1), &temp);
               }
               for (i=0; i<cnt; ++i) order_delete(&dyn_arr_element(orders, i));
               dyn_arr_delete(&orders);
 
               *alpha2 = beta;
               return TRUE;
       	} 
       

/* No chain of homomorphisms found. We try to install one. */
        
        if ( !(deg2 % deg1) && order_find_hom(ord1, ord2))
        {
                *alpha2 = anf_elt_lift_up(ord1, alpha1, ord2);
                return TRUE;
        }
 
/*  other direction */
 
        if ( !(deg1 % deg2) && order_find_hom(ord2, ord1))
        {
                if (anf_elt_lift_down(ord1, alpha1, ord2, alpha2)) 
			return TRUE;
        }
 
/*  last chance: We directly search for alpha1 in ord2 */

        if (anf_print_level > 2) puts("anf_elt_coerce: Trying to embed number...");

        if (anf_elt_embed(ord1, alpha1, 0, ord2, alpha2))
                return TRUE;
        else
                return FALSE;
 
}
