#include "kant.h"
#include "poly_z_faclst.h"
#include "anf.h"

t_void
anf_ideal_faclst_write WITH_2_ARGS(
	order,		ord,
	t_handle,		h
)
/*******************************************************************************
 
anf_ideal_faclst_write.c
 
JS October 1991 
Last modification: 25.10.91
      
Writes a faclst of ideals, assuming they are given in 2-element presentation.
 
*******************************************************************************/
{
	integer_small	i;
	anf_ideal	id;
	integer_small	power;
	integer_small	len;

	len = m_poly_z_faclst_len(h);

	for (i=0; i<len; ++i)
	{
		id    = m_poly_z_faclst_factor(h, i);
		power = m_poly_z_faclst_power(h, i);

		anf_ideal_2_write(ord, id);
		cay_print( " ^ %d\n", power );
	}
}
