/*******************************************************************************
  disc_factors_get.c      

   disc_factors_get
   faclst_append
********************************************************************************/
    


#include <stdio.h>
#include "kant.h" 
#include "anf.h" 
#include "faclst.e" 
#include "faclst.h"
#include "poly_z_faclst.h"  


void faclst_append ();      /* code at eof */

void disc_factors_get WITH_3_ARGS (order   ,  start,
                                   faclst* ,  factors,
                                   faclst  ,  known )
/*******************************************************************************

Description:                                                   
	Returns the factorisation of the discriminant of  
	the given order start.                            
                                                   
	Normally start will be a eqaution order      
     
        In the faclst known the calling function can store known factors. 
        

Calling sequence:

         disc_factors_get (ord,factors);

            order          ord        : The discriminat of this order will
                                        be factorised.
            faclst         *factors   : the arry for the prime factors and 
                                        there powers.                      
            faclst         known      : known factors of the disc. 

History:  
        MD 92-05-20       adding the red. disc.
	JS 92-02-11       0 instead of 1 as last argument of factorisation
	MD 92-01-06       first version
********************************************************************************/
{
	block_declarations;         
                                       

        faclst          trail;

	integer_big	disc,prime,power,temp;
        dyn_arr_handle  rem;
                              
        integer_small   i,maxx;

  rem = 0;    
  trail = MEM_NH;



/* Get the absolute value of the disc */

  if (order_disc_known (start)) 
    disc  = integer_abs(order_disc(start));
  else      
    {
      order_disc_calc(start);
      disc  = integer_abs(order_disc(start));
    }                     



  if (anf_print_level >2)
  {
    cay_print ("Discriminant: %d\n",disc);
  }


         

  if (known != MEM_NH) /* We know some primes , so do some trail */
                              /* division                               */
  {   

    maxx = faclst_num_prime (known);   /* The number of known prime      */
                                      /* factors.                       */

    trail = faclst_alloc (maxx);       /* Create a list for the known things */ 
    faclst_num_prime (trail) = maxx;   /* We know it's size                  */



    for (i=0;i<maxx;i++)  /* Do a trail divison for all primes in known */
    { 
      faclst_prime (trail,i) = integer_incref (faclst_prime (known,i));
      faclst_expon (trail,i) = faclst_expon (known,i);
              
      prime = faclst_prime (known,i);
      power = integer_power (prime,faclst_expon (known,i));


/* Divide out what we know    */

      temp = disc;                    
      disc = integer_div (disc,power); 
      integer_delref (temp);        
      integer_delref (power);
              


      while ( (temp = integer_rem (disc,prime)) == 0 ) /* Check whether the prime  */
                                                       /* still divides the "disc" */
      {
        faclst_expon (trail,i)++;         /* Ok, one more */

        temp = disc;                      /*              */
        disc = integer_div (disc,prime);  /* division     */
        integer_delref (temp);            /*              */
      } 
      integer_delref (temp);
    }
  }



  if (disc != 1) /* Bad : There is still a rest */                          
  {
#ifndef KANT
    integer_lst_factorise(disc, factors, &rem, 50, 1000, 1023, 10, 500, 3, 100, disc, 1);
#else
    integer_lst_factorise   (disc, factors, &rem, 50, 1000, 262144, 0, 0, 0, 0, disc, 0);
#endif 
 
    if (trail != MEM_NH)
      faclst_append (factors,trail);  /* append trail on factors */

  }
  else           /* Ok we have made it known was a good list. */
    *factors =  trail;
            

  if (anf_print_level >2)      /* Do some output .... */
  {
    printf("\nFactorization of discriminant: ");
    faclst_print(*factors); 
    if (rem) printf(" ... with a composite remainder ... ");
    printf("\n");
  }

  if (rem) 
    dyn_arr_delete (&rem);

  integer_delref(disc);

  return;
}               



void 
faclst_append WITH_2_ARGS (faclst*  , first,
                           faclst   , second )
/*******************************************************************************

Description:                                                   

    Appends the faclst second to the faclst first. No check for double 
    factors is done.

Calling sequence:         
    
         faclst      first           : A factorisation 
         faclst      second          : dito
                                           

       faclst_append (&first,second);

    first changes to "first+second"


History:

	MD 92-05-09       first version

********************************************************************************/
{

       int     max_f,max_s,i;



  max_f = faclst_num_prime (*first);
  max_s = faclst_num_expon (second);

  faclst_assure_space(*first,max_f+max_s, 2);

  for (i=0;i<max_s;i++)                
  {
    faclst_prime (*first, max_f+i) = faclst_prime (second,i);
    faclst_expon (*first, max_f+i) = faclst_expon (second,i);
  }

  faclst_num_prime(*first) = max_s + max_f;
}


