/******************************************************************************
  lat_enum_create.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"     
#include "mat.h"    

lat_enum_env
lat_enum_create WITH_1_ARG(
	lattice,	lat
)
/******************************************************************************
 
Description:	Allocating space for the appropriate enumeration environment
		of a lattice
 
		The task of this routine is to allocate sufficient space 
		for the table which describes an enumeration environment.
 
Calling sequence:
 
	env = lat_enum_create(lat)

	lat_enum_env	env	= t_handle of enumeration environment
	lattice		lat	= t_handle of lattice	
 
History:
 
	92-03-12 KW	minor changes
	92-03-10 KW	minor changes
	92-02-28 KW	minor changes
	92-01-?? JS	written
 
******************************************************************************/
{
	block_declarations;

	lat_enum_env	env;
	integer_small   i, rank;
	t_handle		r;  
	t_real		zero;

	r = real_str_create(20);

	zero = ring_zero(r);	
 
/*	MJ 11.02.93 
        env = mem_alloc_zero(sizeof(lat_enum_env_struct));  
*/
	env = mem_alloc_aligned(sizeof(double),sizeof(lat_enum_env_struct)); 
        mem_zero_block(env); 
	block_init(env, LAT_ENUM_ENV_BLOCK_TYPE);
 
	rank = lat_rank(lat); 

	lat_enum_ubound(env)		= MEM_NH;
	lat_enum_lbound(env)		= MEM_NH;
	lat_enum_ref_vector(env)	= MEM_NH;
	lat_enum_double_ref_vector(env)	= dmat_new(1,rank);
 
	lat_enum_request_set_shortest(env);
	lat_enum_strategy_set_down(env);
	lat_enum_status_set_new(env);
	lat_enum_precision_set_short(env);
 
	lat_enum_coef_ubounds_user(env)		= dyn_arr_alloc(rank);
	lat_enum_coef_lbounds_user(env)		= dyn_arr_alloc(rank);
	lat_enum_coef_bounds_user_flags(env)	= dyn_arr_alloc(rank);

	for (i=1; i<=rank; i++)
	{
		lat_enum_coef_ubound_user_flag_clear(env,i);
		lat_enum_coef_lbound_user_flag_clear(env,i); 
	}

	lat_elt_alloc(lat_enum_act_coefs(env), rank);

	lat_enum_act_length(env)	= real_incref(zero);

	lat_enum_act_real_coefs(env) 	= dyn_arr_alloc(rank);
	lat_enum_coef_lbounds(env)	= dyn_arr_alloc(rank);
	lat_enum_coef_ubounds(env)	= dyn_arr_alloc(rank);
	lat_enum_tmp_bounds(env)	= dyn_arr_alloc(rank);
	lat_enum_part_lengths(env)	= dyn_arr_alloc(rank);

	for (i=1;i<= rank;i++)
	{
		lat_enum_tmp_bound(env,i)	= real_incref(zero); 
		lat_enum_part_length(env,i)	= real_incref(zero);
		lat_enum_act_real_coef(env,i)	= real_incref(zero);
	}

	lat_enum_double_tmp_bounds(env)		= dmat_new(1,rank);
	lat_enum_double_part_lengths(env)	= dmat_new(1,rank);

	real_delete(&zero);
	ring_delete(&r);

	return env;
}
