/******************************************************************************
  lat_enum_delete.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"  


void
lat_enum_delete WITH_2_ARGS (
	lattice,	lat,
	lat_enum_env*,	env
)

/******************************************************************************
 
Description:	Deletes an enumeration environment.
		The enumeration environment is delreffed. If there are
		no other references it is deleted completely.
 
Calling sequence:
 
	lat_enum_delete(lat,&env)

	lattice		lat	= t_handle of (appropriate) lattice
	lat_enum_env	env	= t_handle of enumeration environment
				  to be deleted
 
History:

	92-03-10 KW	minor changes
	92-02-13 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i;

	if (block_ref_count(*env) == 1)
	{
		if (lat_enum_ubound(*env)) real_delete(&lat_enum_ubound(*env));
		if (lat_enum_lbound(*env)) real_delete(&lat_enum_lbound(*env));

		if (!lat_enum_ref_vector_is_zero(*env))
		{
			for(i=1;i<=lat_rank(lat);i++)
			{
				real_delete(&lat_enum_ref_vector_coef(*env,i));
			}
			dyn_arr_delete(&lat_enum_ref_vector(*env));
		}
		dmat_delete(&lat_enum_double_ref_vector(*env));

		for(i=1;i<=lat_rank(lat);i++)
		{
			integer_delref(lat_enum_coef_ubound_user(*env,i));
			integer_delref(lat_enum_coef_lbound_user(*env,i));
	        }
	        dyn_arr_delete(&lat_enum_coef_ubounds_user(*env));
	        dyn_arr_delete(&lat_enum_coef_lbounds_user(*env));
	        dyn_arr_delete(&lat_enum_coef_bounds_user_flags(*env));
	
		lat_elt_delete(lat,&lat_enum_act_coefs(*env));
		real_delete(&lat_enum_act_length(*env));

		for(i=1;i<=lat_rank(lat);i++)
		{
			integer_delref(lat_enum_coef_ubound(*env,i));
			integer_delref(lat_enum_coef_lbound(*env,i));

			real_delete(&lat_enum_act_real_coef(*env,i));
			real_delete(&lat_enum_part_length(*env,i));
			real_delete(&lat_enum_tmp_bound(*env,i));
		}
		dyn_arr_delete(&lat_enum_coef_ubounds(*env));
		dyn_arr_delete(&lat_enum_coef_lbounds(*env));

		dyn_arr_delete(&lat_enum_act_real_coefs(*env));
		dyn_arr_delete(&lat_enum_part_lengths(*env));
		dyn_arr_delete(&lat_enum_tmp_bounds(*env));

		dmat_delete(&lat_enum_double_tmp_bounds(*env));
		dmat_delete(&lat_enum_double_part_lengths(*env));
	}

	block_decref_delete(*env);

	*env = MEM_NH;
}
