/*******************************************************************************
  mat_ring_mlll_reduce.c 
********************************************************************************/
 
#include "kant.h" 
#include "ring.h" 
#include "integer.e" 
#include "real.e" 
#include "dyn_arr.h" 
#include "mat.h" 

t_void
mat_ring_mlll_reduce WITH_6_ARGS(
    t_handle,     	R,
    matrix,     	b,      
    t_ring_elt,         eps,
    integer_small *,	rank,
    matrix *,   	bl,
    matrix *,   	trans
)
                               	  
/*******************************************************************************

Description:                               
        
        Driver program for mlll_real_d_reduce/mlll_z_d_reduce.
        This function can be called with integer or real matrices
        whose columns are Z-linearly dependent. It computes a 
        LLL reduced basis and provides the caller with a transformation
        matrix describing the relations found.

Calling sequence:
 
 
History:  
                                                               
	92-05-06 JS	first version
                                                    
********************************************************************************/
{ 
        block_declarations;
       
        t_handle          Z;
        integer_small   r, c, i, j, i1, i2, rp, c1, c2, cact;
        integer_big     fac;
        matrix          bloc, b1, lloc, transr, trans1, trans2, transz;
        dyn_arr_handle  marr;
        t_logical         dep;
        t_ring_elt      zero, temp;
        t_logical         trivial;
                             
        Z    = m_z_str_incref(structure_z);
        r    = mat_row(b);
        c    = mat_col(b);
        zero = ring_zero(R);
                                   
/* zeroing small entries */

        if (ring_type(R) == RING_R)
	{
	        for (i=1; i<=r*c; ++i)
	        {
        	        if (real_equality_eps(R, mat_entry(b, i), zero, eps))
	                {
	                        temp = mat_entry(b, i);
	                        mat_entry(b, i) = ring_elt_incref(R, zero);
	                        ring_elt_delete(R, &temp);
	                }
	        } 
/*puts("In MLLL:"); mat_real_write(R, b);*/
        }
 
        *trans = mat_ring_create_id(Z, c);
        bloc   = mat_ring_copy(R, b);
 
/*
     looking for zero columns
*/     
        c1 = c;
        for (j=1, cact=0; j<=c1; j++)
        {       
                trivial = TRUE;
                for (i=1; i<=r; i++)
                {      
                        if (!ring_equality(R) (R, zero, mat_elt(bloc, i, j))) 
                        {
                                trivial = FALSE;
				break;
                        }       
                        else
                        {
                        }

                }       
                if (trivial)
                {  
			c2 = c1-j+cact+1; 
                          
			mat_ring_col_swap(R, bloc,   j, c2, 1, r);
			mat_ring_col_swap(Z, *trans, j, c2, 1, c);
 
                        j--; c1--;
                }
                else
                {
                        cact++;
                }
        }
 
/*
    trivial case
*/      
        if (cact < 2)
        {       
                *rank = cact;
	        *bl = mat_ring_submat(R, bloc, 1, 1, r, 1);
 
	        mat_delref(R, &bloc);
	        ring_elt_delete(R, &zero);
        	ring_delete(&Z);
 
                return;
        }         
 
/* puts("Trafo is now:"); mat_anf_write(Z, *trans); */

/*
    starting with the first column
*/ 
        *rank = 1; rp = 2;
        lloc = mat_ring_submat(R, bloc, 1, 1, r, 1);
 

        for (j=2; j<=cact; j++)
        { 
		/* 
		   j runs over all columns != 0 
                   b1 contains the input matrix for Wieb's LLL 
                   lloc holds the independent and LLL reduced vectors
		*/

                b1 = mat_new(r, rp);
                for (i1=1; i1<=r; i1++)
                {               
                        for (i2=1; i2<=*rank; i2++)
                                mat_elt(b1, i1, i2) = ring_elt_incref(R, mat_elt(lloc, i1, i2));
                        mat_elt(b1, i1, rp) = ring_elt_incref(R, mat_elt(bloc, i1, j));
                }
	        mat_delref(R, &lloc);
 
                /* now MLLL with the next vector */
                             
                if (ring_type(R) == RING_R)
                {
		        marr = 0; transr = 0;
		        mlll_real_d_reduce(R, b1, 0.75, eps, &dep, &lloc, &marr, &transr);
 
/*puts("in:"); mat_real_write(R, b1);
puts("out:"); mat_real_write(R, lloc);
puts("Probe:"); mat_real_write(R, mat_ring_mult(R, b1, transr));*/
 
		        transz = mat_real_to_mat_z(R, transr); 
	        	trans1 = mat_ring_create_zero(Z, c);
                }
                else if(ring_type(R) == RING_Z)
		{
		        marr = 0; transr = 0;
		        mlll_int_d_reduce(R, b1, 0.75, &dep, &lloc, &marr, &transr);
 
		        transz = mat_ring_copy(R, transr); 
	        	trans1 = mat_ring_create_zero(Z, c);
		}
		else
		{
			error_internal("MLLL not implemented for this ring type.\n");
                }
/* Next line added by MJ, hint from Wieb */    
                
                mat_incref_entries(Z, transz);
 
	        if (!dep) 
		{
	                /* no dependency */
 
                        for (i1=1; i1<=rp; i1++)
                        {
	                        for (i2=1; i2<=rp; i2++)
                                        mat_elt(trans1,i1,i2) = mat_elt(transz,i1,i2);
                        }
                        for (i1=rp+1; i1<=c; i1++) mat_elt(trans1,i1,i1) = 1;

			*rank = *rank + 1; 
			rp++;
		}
                else
                {       
	                /* dependency found: put the 0-vector to the end */
                        c1 = cact-j+rp;
                        for (i1=1; i1<=rp; i1++)
                        {
	                        for (i2=1; i2<rp; i2++)
                                        mat_elt(trans1,i1,i2) = mat_elt(transz,i1,i2);
                                mat_elt(trans1,i1,c1) = mat_elt(transz,i1,rp);
                        }
                        for (i1=rp;   i1<c1; i1++) mat_elt(trans1,i1+1,i1) = 1;
                        for (i1=c1+1; i1<=c; i1++) mat_elt(trans1,i1,i1) = 1;
                }
                    
/*  new trafo matrix (for the whole matrix) */

                trans2 = *trans;
                *trans = mat_ring_mult(Z, trans2, trans1);
/*puts("Trafo multiplied by:"); mat_anf_write(Z, trans1);
puts("Trafo is now:"); mat_anf_write(Z, *trans);*/
 
	        mat_delref(R, &transr);
	        mat_delref(Z, &transz);
	        mat_delref(Z, &trans1);
	        mat_delref(Z, &trans2);
	        mat_delref(R, &b1);
	        for (i=0; i<dyn_arr_curr_length(marr); i++)
	                ring_elt_delete(R, &dyn_arr_element(marr, i));
	        dyn_arr_delete(&marr);
        }
 
        *bl = mat_ring_submat(R, lloc, 1, 1, r, *rank);
 
        mat_delref(R, &bloc);
        mat_delref(R, &lloc);
        ring_elt_delete(R, &zero);
        ring_delete(&Z);
 
        return;
}
