#include "kant.h"
#include "z.e"
#include "anf.h"
#include "mat.e"
#include "mat.h"

void
mat_z_inverse_den WITH_4_ARGS(
        t_handle,         cring,
        matrix,         mat,
        matrix*,        invmat,
        integer_big*,   den
)
/*******************************************************************************
 
mat_z_inverse_den.c
 
KW November 1991
Last modification: 18.11.91

Invertierung von Z-Matrizen
 
*******************************************************************************/

{
        block_declarations;

        matrix          hnf;
        matrix          trans;
        matrix          temp;
        integer_big     temp1,temp2,temp3;
        integer_small   dim,i,j,k;

        if (mat_row(mat) != mat_col(mat)) error_internal("Error in mat_z_inverse_den: matrix non square");

        /* Hermit-Normalform mit Transformationsmatrix berechnen */
                           
        hnf = trans = 0;

        mat_z_hnf_col_sub(cring,mat,&hnf,&trans,TRUE);
        
        dim = mat_row(mat);

        /* Determinante berechnen */

        *den = 1;

        for (i=1 ; i <= dim ; i++)
        {
                temp1 = *den;
                *den = integer_mult(mat_elt(hnf,i,i),*den);
                integer_delref(temp1);
        }

        if (*den == 0) error_internal("Error in mat_z_inverse_den: matrix non regular");

        /* Matrix fuer invmat anlegen */                                 

        *invmat = mat_new(dim,dim);

        /* unteres Dreieck (inkl. Diagonale) von invmat berechnen */

        for (j=1 ; j <= dim ; j++)
        {
                mat_elt(*invmat,j,j) = integer_div(*den,mat_elt(hnf,j,j));

                for (i=j+1 ; i <= dim ; i++)

                {
                        temp1 = 0;
                        
                        for (k=1 ; k < i ; k++)
                        {
                                temp2 = temp1;

                                temp3 = integer_mult(mat_elt(hnf,i,k),mat_elt(*invmat,k,j));
                                temp1 = integer_add(temp2,temp3);

                                integer_delref(temp2);
                                integer_delref(temp3);
                        }

                        temp3 = integer_div(temp1,mat_elt(hnf,i,i));
                        mat_elt(*invmat,i,j) = integer_negate(temp3);
                        integer_delref(temp3);
                        integer_delref(temp1);
                }
        }
                                      
        /* oberes Dreieck (exkl. Diagonale) von invmat nullen */

        for (i=1 ; i <= dim ; i++)
        {
                for (j = i+1 ; j <= dim ; j++)
                {
                        mat_elt(*invmat,i,j) = 0;
                }
        }

        temp = *invmat;

        *invmat = mat_ring_mult(cring,trans,*invmat);

        mat_delref(cring,&temp);
        mat_delref(cring,&hnf);
        mat_delref(cring,&trans);
}




