/*******************************************************************************
  mat_z_row_hnf_mod.c
********************************************************************************/



#include <stdio.h>             
#include "kant.h"     
#include "integer.e"
#include "mat.h"
#include "mat.e"                         



   
matrix
mat_z_row_hnf_mod WITH_3_ARGS (t_handle      , cring,
                               matrix      , mat,
			       integer_big , modul)
/*******************************************************************************
Description:                               

      Calculates the Hermite - normal - form of an rational integer Matrix.
      All Transformations are row - orientated.
                 

calling sequence:                                                         

                     t_handle      cring : The ring corresponding to the matrix mat.
                                         Cring has to be a reference to ZZ.
                     matrix      mat   : matrix for Hermite - reduction.
                     integer_big modul : Since all operations are supposed to be
                                         done in a given remainder-system we 
                                         need to know the remainder system.
                                                                           
                     matrix      hnf   : Hermite normal - form of mat in
                                         ZZ/modul*ZZ.
                     

        hnf = mat_z_row_hnf_mod (cring,mat,modul);


History:

      MD 92-01-10   first version.

********************************************************************************/
{

     block_declarations;           


     matrix     mat1,mat2;


  if (ring_type (cring) == RING_Z) 
  {

     mat1 = mat_ring_trans (cring,mat);

     mat2 = mat_ring_col_hnf_mod (cring,mat1,modul);                                             

     mat_delref (cring,&mat1);
     mat1 = mat_ring_trans (cring,mat2);
     mat_delref (cring,&mat2);

     return mat1;
  }

}

 
