#include "kant.h"
      
t_logical
order_find_hom WITH_2_ARGS(
        order,          ord1,
        order,          ord2)

/*********************************************************************************

Description:

        Tests if ord1 is in ord2. If ord1 is in ord2 the basis elements of
        ord1 are represented referring to the basis elements of ord2 and saved. 
	ord1 is saved as a subfield_order of ord2 !

Calling sequence:
       
        L = order_find_hom( ord1, ord2 );
        
        order           ord1,ord2 = t_handle to order
        t_logical         L         = TRUE if ord1 is in ord2 else FALSE
	

History: 
        92-06-20 JPS transformation matrix for algebraic numbers given as conjugates
        92-06-05 JS  order_mult_assure
	92-05-11 JPS written
*********************************************************************************/
{
	block_declarations;

	integer_small		i, j, k, deg1, deg2;	
        vector			basis;
        anf_elt                 rho1, rho2, rho3, rho4, old;
        order                   suborder, coeff_ord;
        matrix                  tran;
        t_logical                 exit, dum;
        t_handle                  R;

        if (ring_type(ord1) == RING_Z) return TRUE;

 
        order_mult_assure(ord1);
        order_reals_assure(ord1);
        order_mult_assure(ord2);
        order_reals_assure(ord2);
 
        coeff_ord = order_coef_order(ord1);
        dum = order_find_hom(coeff_ord, ord2);
        /* order_delete(&coeff_ord); */
        
        k = order_subfield_order_count(ord2);
        for (i=1; i<=k; ++i)
                if (order_subfield_order(ord2, i) == ord1) return TRUE;

        if (anf_print_level > 2) 
	printf("Trying to install homomorphism between %d and %d ...\n", ord1, ord2);
 
        if (order_basis_is_power(ord1) || order_basis_is_pure(ord1))
                {
                rho1 =  order_basis_elt(ord1, 2);
                if (anf_elt_embed(ord1,rho1,MEM_NH,ord2,&rho2) )          
                        { 
                        k = order_subfield_order_count(ord2);
                        ++k;
                        order_subfield_order_count_set(ord2, k);
                        order_subfield_order(ord2, k) = order_incref(ord1); 
                        deg1 = order_abs_degree(ord1);
                        deg2 = order_abs_degree(ord2);
                        order_subfield_order_rel_degree(ord2, k) = deg2 / deg1;
                        order_subfield_order_basis(ord2, k) = vec_new(deg1 );
                        order_subfield_order_basis_elt(ord2, k, 1) = 1;
                        order_subfield_order_basis_elt(ord2, k, 2) = anf_elt_incref(rho2); 
                        rho3 = anf_elt_incref(rho2); 
                        for (j=3; j<=deg1; ++j)
                                {
                                old = rho3;
                                rho3 = anf_mult(ord2, rho2, rho3);
                                anf_elt_delref(ord2, &old);
                                order_subfield_order_basis_elt(ord2, k, j) = anf_elt_incref(rho3);
                                }
                        anf_elt_delref(ord2, &rho3);
                        anf_elt_delref(ord2, &rho2); 
                        rho3 = anf_elt_con(ord1, rho1);
                        rho2 = anf_elt_lift_up(ord1, rho1, ord2);
                        rho4 = anf_elt_con(ord2, rho2);
                        order_subfield_order_con_tran(ord2, k) = order_con_tran(ord1, ord2, rho3, rho4);
                        anf_elt_delref(ord1,&rho1);
                        anf_elt_delref(ord2,&rho2); 
                        anf_elt_delref(ord1,&rho3);
                        anf_elt_delref(ord2,&rho4); 
		        if (anf_print_level > 2) puts("Homomorphism installed.");
                        return TRUE;
                        } 
                else
                        { 
                        anf_elt_delref(ord1,&rho1);
		        if (anf_print_level > 2) puts("There is no homomorphism.");
                        return FALSE;
                        }
                }
        if (order_basis_is_rel(ord1))
                {
                suborder = order_suborder(ord1 );
                if (order_find_hom(suborder, ord2) )
                        { 

                        deg1 = order_abs_degree(ord1);
                        deg2 = order_abs_degree(ord2);
                        basis = vec_new(deg1);
                        exit = FALSE;
                        for (i=1; i<=deg1 && !exit; ++i)
                                {
                                rho2 = order_basis_elt(ord1, i);
                                rho3 = anf_elt_move(ord1, rho2, suborder); 
                                anf_elt_delref(ord1, &rho2);
                                rho2 = anf_elt_lift_up(suborder,rho3, ord2);
                                if (!anf_elt_is_integer(rho2) )
                                        if (abs(anf_elt_den(rho2)) != 1 )
                                                {
                                                exit = TRUE;
                                                }
                                vec_entry(basis, i) = anf_elt_incref(rho2);
                                anf_elt_delref(ord2, &rho2);
                                anf_elt_delref(suborder, &rho3);
                                }
                        if (!exit)
                                {
                                k = order_subfield_order_count(ord2);
                                ++k;
                                order_subfield_order_count_set(ord2, k);
                                order_subfield_order(ord2, k) = order_incref(ord1); 
                                order_subfield_order_rel_degree(ord2, k) = deg2 / deg1;
                                rho1 = order_primitive_elt(ord1);
                                rho3 = anf_elt_con(ord1, rho1);
                                rho2 = anf_elt_lift_up(ord1, rho1, ord2);
                                rho4 = anf_elt_con(ord2, rho2);
                                order_subfield_order_con_tran(ord2, k) = order_con_tran(ord1, ord2, rho3, rho4);
                                anf_elt_delref(ord1,&rho1);
                                anf_elt_delref(ord2,&rho2); 
                                anf_elt_delref(ord1,&rho3);
                                anf_elt_delref(ord2,&rho4);
                                order_subfield_order_basis(ord2, k) = basis; 
			        if (anf_print_level > 2) puts("Homomorphism installed.");
                                return TRUE;
                                }
                        else
                                {
			        if (anf_print_level > 2) puts("There is no homomorphism.");
                                vec_delete(ord2, &basis);
                                return FALSE;
                                }
                        }
                else
                        {
		        if (anf_print_level > 2) puts("There is no homomorphism.");
                        return FALSE;
                        }
                }
        if (order_basis_is_table(ord1))
                {
                exit = FALSE;
                i=1; 
                deg1 = order_abs_degree(ord1);
                basis = vec_new(deg1);
                while (!exit && i<=deg1)
                        {
                        rho1 = order_basis_elt(ord1, i);
                        if (!anf_elt_embed(ord1, rho1, MEM_NH, ord2, &rho2) ) 
                                exit = TRUE;
                        else
                                {
                                vec_entry(basis, i) = anf_elt_incref(rho2);
                                anf_elt_delref(ord2, &rho2);
                                } 
                        anf_elt_delref(ord1, &rho1);
                        } 
                if (!exit)
                        {
                        k = order_subfield_order_count(ord2);
                        ++k;
                        order_subfield_order_count_set(ord2, k);
                        order_subfield_order(ord2, k) = order_incref(ord1); 
                        deg1 = order_abs_degree(ord1);
                        deg2 = order_abs_degree(ord2);
                        order_subfield_order_rel_degree(ord2, k) = deg2 / deg1;
                        rho1 = order_primitive_elt(ord1);
                        rho3 = anf_elt_con(ord1, rho1);
                        rho2 = anf_elt_lift_up(ord1, rho1, ord2);
                        rho4 = anf_elt_con(ord2, rho3);
                        order_subfield_order_con_tran(ord2, k) = order_con_tran(ord1, ord2, rho3, rho4);
                        anf_elt_delref(ord1,&rho1);
                        anf_elt_delref(ord2,&rho2); 
                        anf_elt_delref(ord1,&rho3);
                        anf_elt_delref(ord2,&rho4);
                        order_subfield_order_basis(ord2, k) = basis;
                        }
                }
        } 

matrix
order_con_tran WITH_4_ARGS(
        order,          ord1,
        order,          ord2,
        anf_elt,        a,
        anf_elt,        b)

/*********************************************************************************

Description: 

        Returns transformation-matrix for algebraic numbers given as conjugates.
        a and b must be the same algebraic number, a given referring to ord1 and 
        b given referring to ord2.

        
Calling sequence:
       
        m = order_con_tran(ord1, ord2, a, b);
        
        matrix          m               transformation matrix   
        order           ord1, ord2      orders, ord1 is in ord2 !
        anf_elt         a,b             algebraic numbers (a = b)

History:

	92-05-20 JPS written
*********************************************************************************/
        {
	block_declarations;

	integer_small           m, n, i, j, cmp, sig1, sig2;
        matrix                  tran;
        t_real                  eps;
        t_handle                  R;
        m = order_abs_degree(ord1);
        n = order_abs_degree(ord2);
        sig1 = order_r1(ord1);
        sig2 = order_r1(ord2);
        R = order_reals(ord1); 
        eps = real_power(R, conv_int_to_real(R, 10), -order_real_prec(ord1 ) / 2 );
        tran = mat_new(n,m);
        
        for (i=1; i<=n; ++i)
                for (j=1; j<=m; ++j)
                        mat_elt(tran, i, j) = ring_zero(R);
        for (i=1; i<=sig2; ++i) 
                for (j=1; j<=sig1; ++j)
                        { 
                        cmp = real_compare_eps(R, anf_con(a, j), anf_con(b, i), eps);
                        if (cmp == 0)
                                {
                                real_delete(&mat_elt(tran, i, j) );
                                mat_elt(tran, i, j) = conv_int_to_real(R, 1);
                                }
                        } 
        for (i=1+sig2; i<=n; ++i) 
                for (j=1+sig1; j<=m; ++j)
                        {
                        cmp = real_compare_eps(R, anf_con(a, j), anf_con(b, i), eps );
                        if (cmp == 0)
                                {
                                real_delete(&mat_elt(tran, i, j) );
                                mat_elt(tran, i, j) = conv_int_to_real(R, 1);
                                }
                        else
                                { 
                                cmp = real_compare_eps(R, anf_con(a, j), real_negate(R, anf_con(b, i) ), eps);
                                if (cmp == 0)
                                        {
                                        real_delete(&mat_elt(tran, i, j) );
                                        mat_elt(tran, i, j) = conv_int_to_real(R, -1);
                                        }
                                } 
                        } 
        real_delete(&eps);
        return tran;
        }

