#include "defs.h"
#include "eseq.e"
#include "error.e"
#include "poly.e"
#include "anf.h"

public t_handle
order_equation_order(pring, p)
t_handle pring, p;
{
	return order_equation_create(poly_coeff_ring(pring), p);	
}


public t_void
order_str_print(s, o)
t_handle s, o;
{
	order_write(o);
}


public t_handle
glue_KANT_kant_poly_disc(pring, apoly)
t_handle	pring, apoly;
{
	t_int	s, t;
	return ipoly_disc(apoly, &s, &t);
}

public t_handle
glue_KANT_order_elt_add(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = anf_elt_add(s1, e1, e2);
	return NH;
}

public t_handle
glue_KANT_order_elt_subtract(s1, e1, e2, res_e)
t_handle s1, e1, e2, *res_e;
{
	*res_e = anf_elt_subtract(s1, e1, e2);
	return NH;
}

public t_handle
glue_KANT_order_elt_negate(s, e, res_e)
t_handle s, e, *res_e;
{
	*res_e = anf_elt_negate(s, e);
	return NH;
}

public t_handle
glue_KANT_order_elt_mult(str, e1, it1, e2, it2, res_e, res_it)
t_handle str, e1, it1, e2, it2, *res_e, *res_it;
{
	*res_e = anf_elt_mult(str, e1, e2);
	*res_it = 0;
	return NH;
}

public t_handle
glue_KANT_order_elt_power(s1, e1, it1, n, res_s, res_e, res_it)
t_handle s1, e1, it1, n, *res_s, *res_e, *res_it;
{
	*res_e = anf_elt_power(s1, e1, n);
	*res_s = order_incref(s1);
	*res_it = 0;
	return NH;
}

public t_handle
glue_KANT_order_eq(s1, e1, it1, s2, e2, it2)
t_handle s1, e1, it1, s2, e2, it2;
{
	if (s1 != s2)
		return FALSE;
	return anf_elt_equal(s1, e1, e2);
}

public t_handle
glue_KANT_order_is_minus_one(str, elt)
t_handle str, elt;
{
	return anf_elt_is_minus1(str, elt);
}
public t_handle
glue_KANT_order_is_one(str, elt)
t_handle str, elt;
{
	return anf_elt_is_one(str, elt);
}

public t_handle
glue_KANT_order_is_zero(str, elt)
t_handle str, elt;
{
	return anf_elt_is_zero(str, elt);
}

public t_handle
glue_KANT_order_is_member(s1, s2, e2, it2)
t_handle s1, s2, e2, it2;
{
	return (s1 == s2);
}

#ifndef KANT
public t_handle
glue_KANT_order_basis(O)
t_handle O;
{
        block_declarations;
        t_handle        darr;
        t_int           len, i;
        t_eseq          seq1;
        t_handle        temp;
	t_handle	eqord;
 
        darr = order_basis(O);
	eqord = anf_order_equation(order_anf(O));
        len = dyn_arr_curr_length(darr);
        seq1 = eseq_create (len, eqord);
        for (i=0; i<len; i++)
        {
                temp = dyn_arr_element(darr, i);
                eseq_put(seq1, i+1, temp, 0);
                anf_elt_delete(eqord, &temp);
        }
        block_decref_delete(darr);
	order_delete(&eqord);
        return seq1;
}
#endif

public t_handle
glue_KANT_order_field_of_fractions(O)
t_handle O;
{
	return anf_incref(order_anf(O));
}

public t_handle
glue_KANT_order_class_number(s1, e1, it1)
t_handle s1, e1, it1;
{
	if (!order_is_maximal(e1))
		error_runtime(ERR_NON_MAXIMAL_ORDER);
	return anf_order_class_number(e1);
}

public t_handle
glue_KANT_order_signature(h, res_s, res_t)
t_handle h, *res_s, *res_t;
{
	t_int   temp; 
	anf_order_sig(h, res_s, res_t, &temp); 

    return NH;
}

public t_handle
glue_KANT_order_unit_rank(h, res_e)
t_handle h, *res_e;
{
	t_int   temp1, temp2; 

	if (!order_is_maximal(h))
		error_runtime(ERR_NON_MAXIMAL_ORDER);

	anf_order_sig(h, &temp1, &temp2, res_e); 
	return NH;
}

public t_handle
glue_KANT_order_regulator(fld, res_s, res_e)
t_handle fld, *res_s, *res_e;
{
        anf_order_regulator(fld, res_s, res_e);
	return NH;
}
