#define MEM_GLOBALS
#include "mem.h"

static t_void mem_initial_callback()
{
    mem_puts("mem: fatal error - no callback yet");
    abort();
}

t_void mem_init()
/*
Initializes MEM.
*/
{
    t_int	i;

    if (memi_done_init)
	return;

    /*
    Calculate the cached small classes.
    */

    for (i = MIN_SIZE; i < CLASS_SMALL_LIMIT; i++)
	memi_classes[i] = memi_slow_class(i);


    SBRK_INITIAL_ALIGN();
    memi_base_mem = memi_high_mem = NULL;

    mem_size_limit = 0;
    mem_callback = mem_initial_callback;
    mem_extension_size = INITIAL_DATA_EXTENSION_SIZE;
    memi_extend_handle_table();
    memi_done_init = TRUE;

    TRACE_INIT();
}
