#include "mem.h"

t_void mem_save(fd, write_func)
t_int	fd;
t_int	(*write_func)();
/*
Save all handled-blocks via the given file descriptor & function.
*/
{
    t_handle	h;
    t_int	h_len, len;
    t_ptr	h_table, bp, hp;

    h_table = HANDLE_BASE;
    h_len = NEXT_BLOCK(h_table) - h_table;

    (*write_func)(fd, &h_len, sizeof h_len);

    len = memi_next_handle - h_table;
    (*write_func)(fd, &len, sizeof len);

    bp = memi_base_mem;

    while (bp < memi_high_mem)
    {
	hp = BLOCK_HANDLE(bp);
	if (IS_ACTIVE(hp) && !IS_SPECIAL(hp))
	{
	    h = hp - h_table;
	    (*write_func)(fd, &h, sizeof h);
	    len = NEXT_BLOCK(bp) - bp;
	    (*write_func)(fd, &len, sizeof len);
	    (*write_func)(fd, bp, PTRS_TO_BYTES(len - HEADER_SIZE));
	}
	bp = NEXT_BLOCK(bp);
    }

    h = 0;
    (*write_func)(fd, &h, sizeof h);
}

t_void mem_restore(fd, read_func)
t_int	fd;
t_int	(*read_func)();
/*
Restore handled-blocks via the given file descriptor & function.  Wipes
out all current handled-blocks first.
*/
{
    t_handle	h;
    t_int	h_len, len;
    t_ptr	h_table, bp, hp, ep, fp;

    memi_clean();

    (*read_func)(fd, &h_len, sizeof h_len);

    h_table = HANDLE_BASE = memi_get_block(h_len);
    BLOCK_HANDLE(h_table) = P_HANDLE_TABLE;
    bp = h_table;
    memi_handle_limit = ep = bp + h_len - HEADER_SIZE;
    while (bp < ep)
	DEREF(bp++) = NULL;

    (*read_func)(fd, &len, sizeof len);
    memi_next_handle = h_table + len;

    while ((*read_func)(fd, &h, sizeof h), h)
    {
	(*read_func)(fd, &len, sizeof len);
	bp = memi_get_block(len);
	(*read_func)(fd, bp, PTRS_TO_BYTES(len - HEADER_SIZE));
	BLOCK_HANDLE(bp) = hp = h_table + h;
	DEREF(hp) = bp;

	IF_TRACE_ALLOCS(
	    BLOCK_FILE_NAME(bp) = 0;
	    BLOCK_LINE_NUM(bp) = 0;
	)

	IF_USE_MARKS(
	    BLOCK_MARK(bp) = 0;
	)
    }

    fp = (t_ptr)&memi_free_handle_list;
    hp = h_table + 1;
    ep = memi_next_handle;

    while (hp < ep)
    {
	if (DEREF(hp) == NULL)
	{
	    DEREF(fp) = hp;
	    fp = hp;
	}
	hp++;
    }

    DEREF(fp) = NULL;
}
