
#include "defs.h"
#include "mp.e"
#include "comp.e"

t_comp
comp_mult WITH_3_ARGS(
	t_handle,		r,
	t_comp,		a,
	t_comp,		b
)
/*
** Returns a * b.
*/
{
	t_comp		c;
	mp_float	are, aim, bre, bim, cre, cim;
	mp_float	temp1, temp2, temp3, temp4;

	comp_split_mp( a, are, aim );
	comp_split_mp( b, bre, bim );

	c = comp_alloc(real_base, comp_beta_prec( r ));
	comp_split_mp( c, cre, cim );

	temp1 = mp_alloc( real_base, comp_beta_prec( r ));
	temp2 = mp_alloc( real_base, comp_beta_prec( r ));
	temp3 = mp_alloc( real_base, comp_beta_prec( r ));
	temp4 = mp_alloc( real_base, comp_beta_prec( r ));

	mp_add( are, aim, temp1 );
	mp_add( bre, bim, temp2 );
	mp_mul( temp1, temp2, temp3 );
	mp_mul( are, bre, temp1 );
	mp_mul( aim, bim, temp2 );
	mp_add( temp1, temp2, temp4 );
	mp_sub( temp3, temp4, cim );
	mp_sub( temp1, temp2, cre );

	mp_delete_float( temp1 );
	mp_delete_float( temp2 );
	mp_delete_float( temp3 );
	mp_delete_float( temp4 );

	return c;
}

