
#include "defs.h"
#include "real.e"
#include "integer.e"
#include "comp.e"
#include "mp.e"
#include "mp.h"
#include "conv.e"


t_comp
conv_comp_to_comp WITH_2_ARGS(
	t_comp,		x,
	t_handle,		newfld
)
/*
** Lifts/lowers x into a new complex field.
*/
{
	t_comp		b;
	mp_float	bre, bim, xre, xim;

	comp_split_mp( x, xre, xim );

	b = comp_alloc( real_base, comp_beta_prec( newfld ));
	comp_split_mp( b, bre, bim );

	mp_priv_move( xre, bre );
	mp_priv_move( xim, bim );

	return b;
}

