
#include "defs.h"
#include "real.e"
#include "integer.e"
#include "comp.e"
#include "mp.e"
#include "mp.h"
#include "conv.e"


t_comp
conv_int_to_comp WITH_2_ARGS(
	t_handle,		r,
	integer_big,	a
)
/*
** Returns the complex number correspoding to the integer a.
*/
{
	t_comp		b;
	mp_float	bre, bim;

	b = comp_alloc( real_base, comp_beta_prec(r) );
	comp_split_mp( b, bre, bim );

	conv_int_to_mp( a, bre );
	conv_int_to_mp( 0, bim );

	return b;
}

