/*  integer_add.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_add	WITH_2_ARGS(
    integer_big, aint,
    integer_big, bint
)
/*
Return the sum of the arguments
*/
{
    block_declarations;
    integer_big			result;

    DEBUG_INTEGER_2("+integer_add", aint, bint);

    if (integer_is_single(aint) && integer_is_single(bint))
    {
	/*
	commonest special case: both operands single-precision
	*/

	register intbig_medium	sum = aint + bint;

	DEBUG_INTEGER_0("-integer_add: both single");

	/*
	split if necessary
	*/

	if (sum >= BETA)
	    return inthdl_handle_to_big(inthdl_alloc_2(sum-BETA, 1));

	if (sum <= -BETA)
	    return inthdl_handle_to_big(inthdl_alloc_2(sum+BETA, -1));

	return sum;
    }

    /*
    special cases: zero operand
    */

    if (aint == 0)
    {
	DEBUG_INTEGER_0("-integer_add: arg 1 zero");
	return integer_incref(bint);
    }

    if (bint == 0)
    {
	DEBUG_INTEGER_0("-integer_add: arg 2 zero");
	return integer_incref(aint);
    }

    if (integer_is_single(aint))
    {
	inthdl_handle		bhdl;

	bhdl = inthdl_big_to_handle(bint);
	result = inthdl_buf_alloc(intbig_curr_size(bhdl) + 1);
	inthdl_add_beta(bhdl, aint, result);
    }
    else if (integer_is_single(bint))
    {
	inthdl_handle		ahdl;

	ahdl = inthdl_big_to_handle(aint);
	result = inthdl_buf_alloc(intbig_curr_size(ahdl) + 1);
	inthdl_add_beta(ahdl, bint, result);
    }
    else
    {
	/*
	Allocate storage of largest possible size for result
	*/

	inthdl_length	alen, blen;
	inthdl_handle	ahdl, bhdl;

	ahdl = inthdl_big_to_handle(aint);
	bhdl = inthdl_big_to_handle(bint);
	alen = intbig_curr_size(ahdl);
	blen = intbig_curr_size(bhdl);
	result = inthdl_buf_alloc((alen > blen ? alen : blen) + 1);

	inthdl_add(ahdl, bhdl, result);
    }

    result = inthdl_standardize(result);

    DEBUG_INTEGER_1("-integer_add", result);
    return result;
}
